/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.vo;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jsky.catalog.AbstractCatalogDirectory;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.astrocat.AstroCatalog;
import jsky.catalog.vo.VoCatalog;
import jsky.util.Preferences;
import jsky.util.Resources;
import jsky.util.gui.ProgressPanel;
import net.ivoa.registry.RegistryAccessException;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;
import uk.ac.starlink.vo.RegistryQuery;

public class VoCatalogDirectory
extends AbstractCatalogDirectory {
    private static final long serialVersionUID = 1L;
    private static final String[] STANDARD_IDS = new String[]{"ivo://ivoa.net/std/ConeSearch", "ivo://ivoa.net/std/SIA", "ivo://ivoa.net/std/SSA"};
    private static final String[] STANDARD_NAMES = new String[]{"Cone Search Services", "SIA Services", "SSA Services"};
    private static final Comparator<Catalog> CATALOG_COMPARATOR = new Comparator<Catalog>(){

        @Override
        public int compare(Catalog c1, Catalog c2) {
            return c1.getName().compareToIgnoreCase(c2.getName());
        }
    };
    private static Map<URL, VoCatalogDirectory> _voCatalogDirectory;
    private static boolean _reloadFlag;
    private transient ProgressPanel _progressPanel;

    private VoCatalogDirectory(String name, URL url) {
        super(name);
        this.setURL(url);
        this._load();
    }

    private VoCatalogDirectory(String name, List<Catalog> catalogs) {
        super(name);
        this.setCatalogs(catalogs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _load() {
        URL url = this.getURL();
        if (url == null) {
            return;
        }
        if (this._progressPanel == null) {
            this._progressPanel = ProgressPanel.makeProgressPanel("Updating list of available catalogs from: " + url.getHost());
        }
        this._progressPanel.start();
        try {
            ArrayList<Catalog> subdirs = new ArrayList<Catalog>();
            for (int i = 0; i < STANDARD_IDS.length; ++i) {
                RegResource[] resources;
                String standardId = STANDARD_IDS[i];
                String name = STANDARD_NAMES[i];
                ArrayList<Catalog> catalogs = new ArrayList<Catalog>();
                String queryStr = "capability/@standardID = '" + standardId + "'";
                this._progressPanel.setText("Query: capability = " + standardId);
                RegistryQuery query = new RegistryQuery(url.toString(), queryStr);
                try {
                    resources = query.getQueryResources();
                }
                catch (RegistryAccessException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                if (this._progressPanel.isInterrupted()) {
                    return;
                }
                if (resources == null || resources.length == 0) continue;
                for (RegResource resource : resources) {
                    RegCapabilityInterface[] caps;
                    for (RegCapabilityInterface cap : caps = resource.getCapabilities()) {
                        if (!standardId.equals(cap.getStandardId())) continue;
                        catalogs.add(new VoCatalog(resource, cap, this));
                    }
                }
                Collections.sort(catalogs, CATALOG_COMPARATOR);
                subdirs.add(new VoCatalogDirectory(name, catalogs));
            }
            this.setCatalogs(subdirs);
        }
        finally {
            this._progressPanel.stop();
        }
    }

    public static CatalogDirectory getDirectory(AstroCatalog cat) {
        URL url;
        try {
            url = cat.getBaseURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String name = cat.getName();
        if (name == null) {
            name = "unknown";
        }
        if (_voCatalogDirectory == null) {
            _voCatalogDirectory = new HashMap<URL, VoCatalogDirectory>();
        } else if (_voCatalogDirectory.containsKey(url)) {
            return _voCatalogDirectory.get(url);
        }
        return VoCatalogDirectory.getCatalogList(name, url);
    }

    public static VoCatalogDirectory getCatalogList(String name, URL url) {
        VoCatalogDirectory dir;
        if (!_reloadFlag && (dir = VoCatalogDirectory._loadPersistent(url)) != null) {
            dir.setName(name);
            return dir;
        }
        dir = new VoCatalogDirectory(name, url);
        _voCatalogDirectory.put(url, dir);
        VoCatalogDirectory._savePersistent(dir, url);
        return dir;
    }

    @Override
    public Catalog reload() {
        this._removePersistent(this.getURL());
        _reloadFlag = true;
        VoCatalogDirectory catDir = null;
        try {
            catDir = VoCatalogDirectory.getCatalogList(this.getName(), this.getURL());
        }
        finally {
            _reloadFlag = false;
        }
        return catDir;
    }

    @Override
    public CatalogDirectory loadSubDir(URL url) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean configNeedsUrl() {
        return true;
    }

    @Override
    public void save() {
    }

    private static void _savePersistent(VoCatalogDirectory dir, URL url) {
        try {
            String s = VoCatalogDirectory._getPersistentName(url);
            Preferences.getPreferences().serialize(s, dir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static VoCatalogDirectory _loadPersistent(URL url) {
        String name = VoCatalogDirectory._getPersistentName(url);
        VoCatalogDirectory dir = null;
        try {
            dir = (VoCatalogDirectory)Preferences.getPreferences().deserialize(name);
        }
        catch (Exception e) {
            try {
                String filename = name + ".ser";
                InputStream inputStream = Resources.getResourceAsStream(filename);
                if (inputStream != null) {
                    ObjectInputStream in = new ObjectInputStream(inputStream);
                    dir = (VoCatalogDirectory)in.readObject();
                    in.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        if (dir != null) {
            VoCatalogDirectory._updatePersistent(dir);
        }
        return dir;
    }

    private static void _updatePersistent(CatalogDirectory dir) {
        dir.setCatalogs(dir.getCatalogs());
        for (Catalog cat : dir.getCatalogs()) {
            if (cat instanceof VoCatalog) {
                ((VoCatalog)cat).initQueryArgs();
                continue;
            }
            if (!(cat instanceof CatalogDirectory)) continue;
            VoCatalogDirectory._updatePersistent((CatalogDirectory)cat);
        }
    }

    private void _removePersistent(URL url) {
        try {
            String s = VoCatalogDirectory._getPersistentName(url);
            Preferences.getPreferences().removeSerializedFile(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String _getPersistentName(URL url) {
        return url.getHost() + "-" + url.getPath().replaceAll("[^A-Za-z0-9_]", "-");
    }

    static {
        _reloadFlag = false;
    }
}

