/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.util.StringUtil;

public class CatalogTreeModel
extends DefaultTreeModel {
    private String _filter;
    private Set<String> _types;
    private Map<Catalog, DefaultMutableTreeNode> _nodeMap;

    public CatalogTreeModel(CatalogDirectory catDir, String filter, Set<String> types) {
        super(new DefaultMutableTreeNode(catDir));
        this._filter = filter;
        this._types = types;
        this._nodeMap = new HashMap<Catalog, DefaultMutableTreeNode>();
        this._updateModel();
    }

    private void addNodes(DefaultMutableTreeNode root) {
        CatalogDirectory catDir = (CatalogDirectory)root.getUserObject();
        List<Catalog> list = catDir.getCatalogs();
        for (Catalog cat : list) {
            boolean isDir;
            boolean bl = isDir = cat instanceof CatalogDirectory && ((CatalogDirectory)cat).getNumCatalogs() > 0;
            if (!isDir && !this._matches(cat)) continue;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(cat);
            root.add(node);
            if (!this._nodeMap.containsKey(cat)) {
                this._nodeMap.put(cat, node);
            }
            if (!isDir) continue;
            this.addNodes(node);
        }
    }

    private boolean _matches(Catalog cat) {
        if (this._filter != null && this._filter.length() != 0 && !StringUtil.match(this._filter, cat.getName())) {
            return false;
        }
        return this._types.contains(cat.getType());
    }

    private void _updateModel() {
        DefaultMutableTreeNode rootTreeNode = (DefaultMutableTreeNode)this.getRoot();
        CatalogDirectory dir = (CatalogDirectory)rootTreeNode.getUserObject();
        rootTreeNode.removeAllChildren();
        this._nodeMap.clear();
        this._nodeMap.put(dir, rootTreeNode);
        this.addNodes(rootTreeNode);
    }

    public TreePath getTreePath(Catalog cat) {
        DefaultMutableTreeNode node = this._nodeMap.get(cat);
        if (node != null) {
            return new TreePath(node.getPath());
        }
        return null;
    }

    public DefaultMutableTreeNode getTreeNode(Catalog cat) {
        return this._nodeMap.get(cat);
    }
}

