/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import jsky.catalog.Catalog;
import jsky.util.Resources;

public class CatalogTreeCellRenderer
extends DefaultTreeCellRenderer {
    public static final Icon IMAGE_SERVER_ICON = Resources.getIcon("WebComponentAdd16.gif");
    public static final Icon CATALOG_ICON = Resources.getIcon("File16.gif");
    public static final Icon ARCHIVE_ICON = Resources.getIcon("New16.gif");
    public static final Icon NAME_SERVER_ICON = Resources.getIcon("About16.gif");
    public static final Icon BUSY_ICON = Resources.getIcon("phone2.gif");

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.setBackgroundNonSelectionColor(tree.getBackground());
        if (value instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object o = node.getUserObject();
            if (o instanceof Catalog) {
                Catalog catalog = (Catalog)o;
                this.setToolTipText(catalog.getDescription());
                String servType = catalog.getType();
                if (servType.equals("directory")) {
                    this.setIcon(this.getOpenIcon());
                }
                if (servType.equals("catalog")) {
                    this.setIcon(CATALOG_ICON);
                }
                if (servType.equals("archive")) {
                    this.setIcon(ARCHIVE_ICON);
                }
                if (servType.equals("namesvr")) {
                    this.setIcon(NAME_SERVER_ICON);
                }
                if (servType.equals("imagesvr")) {
                    this.setIcon(IMAGE_SERVER_ICON);
                }
                this.setToolTipText(this.getText());
            } else if (o instanceof String) {
                this.setIcon(BUSY_ICON);
            }
        }
        return this;
    }
}

