/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog;

import java.io.IOException;
import java.util.List;
import java.util.Vector;
import jsky.catalog.RowCoordinates;
import jsky.catalog.TableQueryResult;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;

public class StarTableAdapter
extends AbstractStarTable {
    private TableQueryResult _cat;
    private ColumnInfo[] _colInfo;
    private int _colOffset = 0;

    public StarTableAdapter(TableQueryResult cat) {
        this._cat = cat;
        this._colInfo = this._getColInfo();
        if (this._colInfo.length > 0 && "JSky Id column (generated)".equals(this._colInfo[0].getDescription())) {
            this._colOffset = 1;
        }
    }

    @Override
    public int getColumnCount() {
        return this._cat.getColumnCount() - this._colOffset;
    }

    @Override
    public long getRowCount() {
        return this._cat.getRowCount();
    }

    @Override
    public String getName() {
        return this._cat.getName();
    }

    @Override
    public void setName(String name) {
        this._cat.setName(name);
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this._colInfo[icol + this._colOffset];
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        return new RowSequence(){
            private int _row = -1;

            @Override
            public boolean next() throws IOException {
                return ++this._row < StarTableAdapter.this._cat.getRowCount();
            }

            @Override
            public Object getCell(int icol) throws IOException {
                return StarTableAdapter.this._cat.getValueAt(this._row, icol + StarTableAdapter.this._colOffset);
            }

            @Override
            public Object[] getRow() throws IOException {
                return StarTableAdapter.this.getRow(this._row);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    @Override
    public boolean isRandom() {
        return true;
    }

    @Override
    public Object getCell(long irow, int icol) throws IOException {
        return this._cat.getValueAt((int)irow, icol + this._colOffset);
    }

    @Override
    public Object[] getRow(long irow) throws IOException {
        List<Object> rowData = this._cat.getRowData((int)irow);
        Object[] ar = new Object[rowData.size() - this._colOffset];
        if (this._colOffset == 1) {
            rowData.remove(0);
        }
        return rowData.toArray(ar);
    }

    private ColumnInfo[] _getColInfo() {
        ColumnInfo info;
        RowCoordinates rowCoords = this._cat.getRowCoordinates();
        int idIndex = rowCoords.getIdCol();
        int raIndex = rowCoords.getRaCol();
        int decIndex = rowCoords.getDecCol();
        int xIndex = rowCoords.getXCol();
        int yIndex = rowCoords.getYCol();
        Vector colNames = this._cat.getColumnIdentifiers();
        int numCols = this._cat.getColumnCount();
        ColumnInfo[] colInfos = new ColumnInfo[numCols];
        for (int i = 0; i < numCols; ++i) {
            ColumnInfo info2 = new ColumnInfo((String)colNames.get(i));
            info2.setContentClass(this._cat.getColumnClass(i));
            info2.setDescription(this._cat.getColumnDesc(i).getDescription());
            info2.setUnitString(this._cat.getColumnDesc(i).getUnits());
            info2.setUCD(this._cat.getColumnDesc(i).getUCD());
            colInfos[i] = info2;
        }
        if (raIndex >= 0 && raIndex < numCols && (info = colInfos[raIndex]).getUCD() == null) {
            info.setUCD("pos.eq.ra;meta.main");
            if (Number.class.isAssignableFrom(info.getContentClass())) {
                info.setUnitString("deg");
            }
        }
        if (decIndex >= 0 && decIndex < numCols && (info = colInfos[decIndex]).getUCD() == null) {
            info.setUCD("pos.eq.dec;meta.main");
            if (Number.class.isAssignableFrom(info.getContentClass())) {
                info.setUnitString("deg");
            }
        }
        if (idIndex >= 0 && idIndex < numCols && (info = colInfos[idIndex]).getUCD() == null) {
            info.setUCD("meta.id");
        }
        if (xIndex >= 0 && xIndex < numCols && (info = colInfos[xIndex]).getUCD() == null) {
            info.setUCD("pos.cartesian.x");
        }
        if (yIndex >= 0 && yIndex < numCols && (info = colInfos[yIndex]).getUCD() == null) {
            info.setUCD("pos.cartesian.y");
        }
        return colInfos;
    }
}

