/*
 * Decompiled with CFR 0.152.
 */
package alma.sourcecat.dao;

import alma.sourcecat.model.Measurement;
import alma.sourcecat.model.Source;
import alma.sourcecat.model.SourceName;
import alma.sourcecat.model.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.RowMapper;

class SourceRowMapper
implements RowMapper<Source> {
    private static final Log LOG = LogFactory.getLog(SourceRowMapper.class);
    private final Source source;
    private final HashSet<Integer> names;
    private final HashSet<Integer> types;
    private final HashSet<Integer> measurements;

    public SourceRowMapper(Source source) {
        this.source = source;
        this.names = new HashSet();
        this.types = new HashSet();
        this.measurements = new HashSet();
    }

    public Source mapRow(ResultSet result, int rowNum) throws SQLException {
        int measurementId;
        int typeId;
        int nameId;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("-> mapRow(" + rowNum + ")"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("source id: " + result.getInt("source_id")));
        }
        if (this.source.getId() == 0) {
            this.source.setId(result.getInt("source_id"));
            this.source.setRaDeg(result.getDouble("ra_deg"));
            this.source.setRaDegUncertainty(result.getDouble("ra_deg_uncertainty"));
            this.source.setDecDeg(result.getDouble("dec_deg"));
            this.source.setDecDegUncertainty(result.getDouble("dec_deg_uncertainty"));
            this.source.setUpdateUser(result.getString("update_user"));
            this.source.setUpdateDate(result.getDate("update_date"));
            this.source.setUpdateComment(result.getString("update_comment"));
        }
        if ((nameId = result.getInt("name_id")) > 0 && !this.names.contains(nameId)) {
            this.source.addName(new SourceName(nameId, result.getString("name")));
            this.names.add(nameId);
        }
        if ((typeId = result.getInt("type_id")) > 0 && !this.types.contains(typeId)) {
            this.source.addType(new Type(typeId, result.getString("type_name")));
            this.types.add(typeId);
        }
        if ((measurementId = result.getInt("measurement_id")) > 0 && !this.measurements.contains(measurementId)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"adding measurement");
            }
            Measurement measurement = new Measurement(measurementId, result.getInt("catalogue_id"), this.source.getId(), result.getDouble("ra"), result.getString("ra_uncertainty"), result.getDouble("dec"), result.getString("dec_uncertainty"), result.getDouble("frequency"), result.getDouble("flux"), result.getString("flux_uncertainty"), result.getString("degree"), result.getString("degree_uncertainty"), result.getString("angle"), result.getString("angle_uncertainty"), result.getString("origin"), result.getDate("date_observed"), result.getInt("valid") != 0, result.getDouble("ra_deg"), result.getDouble("ra_deg_uncertainty"), result.getDouble("dec_deg"), result.getDouble("dec_deg_uncertainty"));
            Double uvMin = result.getDouble("uvmin");
            if (!result.wasNull()) {
                LOG.debug((Object)("UVMIN was not null: " + uvMin));
                measurement.setUvMin(uvMin);
            } else {
                LOG.debug((Object)"JDBC said uvMin was null");
            }
            Double uvMax = result.getDouble("uvmax");
            if (!result.wasNull()) {
                measurement.setUvMax(uvMax);
            }
            this.source.addMeasurement(measurement);
            this.measurements.add(measurementId);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<- mapRow");
        }
        return null;
    }
}

