/*
 * Decompiled with CFR 0.152.
 */
package alma.sourcecat.dao;

import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public final class Position {
    private static final double FLOAT_TOLERANCE = 1.0E-10;

    private Position() {
    }

    public static PositionalSearchParameters calculatePositionalSearchParameters(Double ra, Double dec, Double radius) {
        PositionalSearchParameters parameters = new PositionalSearchParameters();
        if (dec != null && dec > -90.0000000001 && dec < 90.0000000001 && ra != null && ra > -1.0E-10 && ra <= 360.0 && radius != null && radius > -1.0E-10) {
            if (Math.abs(dec) + radius < 90.0) {
                double radelta = Math.toDegrees(2.0 * Math.asin(Math.sin(Math.toRadians(radius) / 2.0) / Math.cos(Math.toRadians(dec))));
                parameters.performRaSearch = true;
                double raMin = ra - radelta;
                double raMax = ra + radelta + 1.0E-10;
                if (raMin < 0.0) {
                    parameters.raMin1 = 360.0 + raMin;
                    parameters.raMax1 = 360.0000000001;
                    parameters.raMin2 = 0.0;
                    parameters.raMax2 = raMax;
                } else if (raMax > 360.0) {
                    parameters.raMin1 = raMin;
                    parameters.raMax1 = 360.0000000001;
                    parameters.raMin2 = 0.0;
                    parameters.raMax2 = raMax - 360.0;
                } else {
                    parameters.raMin1 = raMin;
                    parameters.raMax1 = raMax;
                }
            }
            parameters.performDecSearch = true;
            double decdelta = 2.0 * radius;
            parameters.decMin = dec - decdelta;
            parameters.decMax = dec + decdelta + 1.0E-10;
        }
        return parameters;
    }

    public static void addCone(MapSqlParameterSource args, Double ra, Double dec, Double radius) {
        double decS = 0.0;
        double radiusS = 0.0;
        double raS = 0.0;
        double toRadians = Math.PI / 180;
        raS = Math.toRadians(ra);
        decS = Math.toRadians(dec);
        radiusS = Math.sin(Math.toRadians(radius / 2.0));
        args.addValue("ra", (Object)raS);
        args.addValue("dec", (Object)decS);
        args.addValue("radius", (Object)radiusS);
        args.addValue("to_radians", (Object)(Math.PI / 180));
    }

    static class PositionalSearchParameters {
        boolean performRaSearch = false;
        boolean performDecSearch = false;
        double raMin1 = 0.0;
        double raMax1 = -1.0E-10;
        double raMin2 = 0.0;
        double raMax2 = -1.0E-10;
        double decMin = 0.0;
        double decMax = -1.0E-10;

        PositionalSearchParameters() {
        }
    }
}

