/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.jdbc.JDBCAuthenticator;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.task.ConnectionParameter;
import uk.ac.starlink.ttools.task.InputTableParameter;
import uk.ac.starlink.ttools.task.InputTablesParameter;
import uk.ac.starlink.ttools.task.TableConsumerParameter;
import uk.ac.starlink.ttools.task.TableEnvironment;
import uk.ac.starlink.ttools.task.TableProducer;

public class MapEnvironment
implements TableEnvironment {
    private final Map paramMap_;
    private final Map outputTables_ = new HashMap();
    private final ByteArrayOutputStream out_ = new ByteArrayOutputStream();
    private final ByteArrayOutputStream err_ = new ByteArrayOutputStream();
    private final PrintStream pout_ = new PrintStream(this.out_);
    private final PrintStream perr_ = new PrintStream(this.err_);
    private Class resourceBase_ = MapEnvironment.class;
    private boolean strictVot_;
    private boolean debug_;

    public MapEnvironment() {
        this(new HashMap());
    }

    public MapEnvironment(Map map) {
        this.paramMap_ = map;
    }

    public MapEnvironment(MapEnvironment env) {
        this(new HashMap(env.paramMap_));
        this.resourceBase_ = env.resourceBase_;
        this.debug_ = env.debug_;
        this.strictVot_ = env.strictVot_;
    }

    public PrintStream getOutputStream() {
        return this.pout_;
    }

    public PrintStream getErrorStream() {
        return this.perr_;
    }

    public void clearValue(Parameter param) {
        throw new UnsupportedOperationException();
    }

    public String[] getNames() {
        return this.paramMap_.keySet().toArray(new String[0]);
    }

    public String getOutputText() {
        this.pout_.flush();
        return new String(this.out_.toByteArray());
    }

    public String[] getOutputLines() {
        String text = this.getOutputText();
        return text.length() == 0 ? new String[]{} : text.split("\\n");
    }

    public MapEnvironment setValue(String paramName, Object value) {
        this.paramMap_.put(paramName, value);
        return this;
    }

    public MapEnvironment setResourceBase(Class clazz) {
        this.resourceBase_ = clazz;
        return this;
    }

    public StarTable getOutputTable(String paramName) {
        return (StarTable)this.outputTables_.get(paramName);
    }

    public void acquireValue(Parameter param) throws TaskException {
        String value;
        final String pname = param.getName();
        boolean isDefault = !this.paramMap_.containsKey(pname);
        String string = value = isDefault ? param.getDefault() : this.paramMap_.get(pname);
        if (isDefault && param instanceof TableConsumerParameter) {
            ((TableConsumerParameter)param).setValueFromConsumer(new TableConsumer(){

                public void consume(StarTable table) {
                    MapEnvironment.this.outputTables_.put(pname, table);
                }
            });
        } else if (value == null && param.isNullPermitted()) {
            param.setValueFromString((Environment)this, null);
        } else {
            if (value == null) {
                throw new IllegalArgumentException("No value supplied for param " + param);
            }
            if (param instanceof InputTableParameter && value instanceof StarTable) {
                ((InputTableParameter)param).setValueFromTable((StarTable)value);
            } else if (param instanceof ConnectionParameter && value instanceof Connection) {
                try {
                    ((ConnectionParameter)param).setValueFromConnection((Connection)((Object)value));
                }
                catch (SQLException e) {
                    throw new TaskException(e.getMessage(), (Throwable)e);
                }
            } else if (param instanceof InputTablesParameter && value instanceof StarTable[]) {
                StarTable[] tables = (StarTable[])value;
                int nTable = tables.length;
                TableProducer[] tablePs = new TableProducer[nTable];
                for (int i = 0; i < nTable; ++i) {
                    final StarTable table = tables[i];
                    tablePs[i] = new TableProducer(){

                        public StarTable getTable() {
                            return table;
                        }
                    };
                }
                ((InputTablesParameter)param).setValueFromTables(tablePs);
            } else if (param instanceof InputTableParameter && value instanceof String && value.indexOf(47) < 0) {
                String sval = value;
                String frag = "";
                int ihash = sval.indexOf(35);
                if (ihash > 0) {
                    frag = sval.substring(ihash);
                    sval = sval.substring(0, ihash);
                }
                param.setValueFromString((Environment)this, this.resourceBase_.getResource(sval).toString() + frag);
            } else if (value instanceof String) {
                param.setValueFromString((Environment)this, value);
            } else {
                throw new IllegalArgumentException("Can't fit value of type " + value.getClass() + " into parameter " + param);
            }
        }
    }

    public StarTableFactory getTableFactory() {
        return new StarTableFactory();
    }

    public StarTableOutput getTableOutput() {
        return new StarTableOutput();
    }

    public JDBCAuthenticator getJdbcAuthenticator() {
        return null;
    }

    public boolean isDebug() {
        return this.debug_;
    }

    public void setDebug(boolean debug) {
        this.debug_ = debug;
    }

    public boolean isStrictVotable() {
        return this.strictVot_;
    }

    public void setStrictVotable(boolean strict) {
        this.strictVot_ = strict;
    }
}

