/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.util.logging.Logger;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.MultiParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.task.AbstractInputTableParameter;
import uk.ac.starlink.ttools.task.TableProducer;

public class InputTablesParameter
extends AbstractInputTableParameter
implements MultiParameter {
    private TableProducer[] tables_;
    private String[] locs_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");

    public InputTablesParameter(String name) {
        super(name);
        this.setUsage("<table> ...");
        String indir = String.valueOf('@');
        this.setDescription(new String[]{"<p>Locations of the input tables.", "Either specify the parameter multiple times, or supply the", "input tables as a space-separated list within a single use.", "Each table location may be a filename or URL, and may point", "to data compressed in one of the supported compression formats", "(Unix compress, gzip or bzip2).", "</p>", "<p>A list of input table locations may be given in an external", "file by using the indirction character '" + indir + "'.", "Thus \"<code>" + this.getName() + "=" + indir + "filename</code>\"", "causes the file <code>filename</code> to be read for a list", "of input table locations.  The locations in the file should", "each be on a separate line.", "</p>"});
        this.getStreamParameter().setDescription(new String[]{this.getStreamParameter().getDescription(), "<p>The same streaming flag applies to all the tables specified by", "<code>" + this.getName() + "</code>.", "</p>"});
        this.getFormatParameter().setDescription(new String[]{this.getFormatParameter().getDescription(), "<p>The same format parameter applies to all the tables", "specified by <code>" + this.getName() + "</code>.", "</p>"});
    }

    public char getValueSeparator() {
        return '\u00a0';
    }

    public TableProducer[] tablesValue(final Environment env) throws TaskException {
        this.checkGotValue(env);
        if (this.tables_ == null) {
            this.getFormatParameter().stringValue(env);
            this.getStreamParameter().stringValue(env);
            String[] locs = this.stringsValue(env);
            int nloc = locs.length;
            TableProducer[] tables = new TableProducer[nloc];
            for (int i = 0; i < nloc; ++i) {
                final String loc = locs[i];
                tables[i] = new TableProducer(){

                    public StarTable getTable() throws TaskException {
                        return InputTablesParameter.this.makeTable(env, loc);
                    }
                };
            }
            this.tables_ = tables;
        }
        return this.tables_;
    }

    public String[] stringsValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        if (this.locs_ == null) {
            String locset = this.stringValue(env);
            String[] locs = locset.indexOf(this.getValueSeparator()) >= 0 ? locset.split("\\" + this.getValueSeparator()) : locset.trim().split(" +");
            this.locs_ = locs;
        }
        return this.locs_;
    }

    public void setValueFromTables(TableProducer[] tables) {
        this.tables_ = tables;
        this.locs_ = new String[tables.length];
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < tables.length; ++i) {
            this.locs_[i] = "table_" + (i + 1);
            if (i > 0) {
                sbuf.append(' ');
            }
            sbuf.append(this.locs_[i]);
        }
        this.setStringValue(sbuf.toString());
        this.setGotValue(true);
    }
}

