/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.util.ArrayList;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.task.FilterParameter;
import uk.ac.starlink.ttools.task.InputFormatParameter;
import uk.ac.starlink.ttools.task.InputTableParameter;
import uk.ac.starlink.ttools.task.InputTableSpec;
import uk.ac.starlink.ttools.task.MapperTask;
import uk.ac.starlink.ttools.task.TableMapper;

public class FixedMapperTask
extends MapperTask {
    private final InputTableParameter[] inTableParams_;
    private final FilterParameter[] inFilterParams_;

    public FixedMapperTask(String purpose, ProcessingMode outMode, boolean useOutFilter, TableMapper mapper, int nIn, boolean useInFilters) {
        super(purpose, outMode, useOutFilter, mapper);
        int i1;
        int i;
        ArrayList<Parameter> paramList = new ArrayList<Parameter>();
        this.inTableParams_ = new InputTableParameter[nIn];
        for (i = 0; i < nIn; ++i) {
            InputTableParameter inParam;
            i1 = i + 1;
            String ord = FixedMapperTask.getOrdinal(i1);
            this.inTableParams_[i] = inParam = new InputTableParameter("in" + i1);
            inParam.setPosition(i1);
            inParam.setUsage("<table" + i1 + ">");
            inParam.setPrompt("Location of " + ord + " input table");
            inParam.setDescription(inParam.getDescription().replaceFirst("the input table", "the " + ord + " input table"));
            InputFormatParameter fmtParam = inParam.getFormatParameter();
            fmtParam.setDescription(fmtParam.getDescription().replaceFirst("the input table", "the " + ord + " input table"));
            paramList.add(fmtParam);
            paramList.add(inParam);
        }
        this.inFilterParams_ = new FilterParameter[nIn];
        if (useInFilters) {
            for (i = 0; i < nIn; ++i) {
                FilterParameter fp;
                i1 = i + 1;
                this.inFilterParams_[i] = fp = new FilterParameter("icmd" + i1);
                fp.setPrompt("Processing command(s) for input table " + i1);
                fp.setDescription(new String[]{"<p>Commands to operate on the " + FixedMapperTask.getOrdinal(i1), "input table, before any other processing takes place.", "</p>", fp.getDescription()});
                paramList.add(fp);
            }
        }
        this.getParameterList().addAll(0, paramList);
    }

    protected InputTableSpec[] getInputSpecs(Environment env) throws TaskException {
        int nIn = this.inTableParams_.length;
        InputTableSpec[] specs = new InputTableSpec[nIn];
        for (int i = 0; i < nIn; ++i) {
            InputTableParameter tableParam = this.inTableParams_[i];
            FilterParameter filterParam = this.inFilterParams_[i];
            specs[i] = InputTableSpec.createSpec(tableParam.stringValue(env), filterParam == null ? null : filterParam.stepsValue(env), tableParam.tableValue(env));
        }
        return specs;
    }

    private static String getOrdinal(int i) {
        switch (i) {
            case 1: {
                return "first";
            }
            case 2: {
                return "second";
            }
            case 3: {
                return "third";
            }
            case 4: {
                return "fourth";
            }
            case 5: {
                return "fifth";
            }
        }
        return "next";
    }
}

