/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import uk.ac.starlink.table.ColumnPermutedStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.jel.ColumnIdentifier;
import uk.ac.starlink.ttools.task.InputTableSpec;
import uk.ac.starlink.ttools.task.TableMapper;
import uk.ac.starlink.ttools.task.TableMapping;
import uk.ac.starlink.ttools.task.WordsParameter;

public class ColumnSelectionMapper
implements TableMapper {
    private final WordsParameter colsParam_ = new WordsParameter("cols");

    public ColumnSelectionMapper() {
        this.colsParam_.setUsage("<col-id> ...");
        this.colsParam_.setDescription(new String[]{"<p>Columns to use for this task.", "One or more <code>&lt;col-id&gt;</code> elements, ", "separated by spaces, should be given.", "Each one represents a column in the table, using either its", "name or index.", "</p>"});
        this.colsParam_.setPrompt("Space-separated list of input columns");
    }

    public Parameter[] getParameters() {
        return new Parameter[]{this.colsParam_};
    }

    public TableMapping createMapping(Environment env, int nin) throws TaskException {
        final String[] colids = this.colsParam_.wordsValue(env);
        return new TableMapping(){

            public StarTable mapTables(InputTableSpec[] inSpecs) throws IOException, TaskException {
                StarTable in = inSpecs[0].getWrappedTable();
                ColumnIdentifier colIdent = new ColumnIdentifier(in);
                int ncol = colids.length;
                int[] colMap = new int[ncol];
                for (int icol = 0; icol < ncol; ++icol) {
                    colMap[icol] = colIdent.getColumnIndex(colids[icol]);
                }
                return new ColumnPermutedStarTable(in, colMap);
            }
        };
    }

    public WordsParameter getColumnsParameter() {
        return this.colsParam_;
    }
}

