/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plottask;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plottask.StyleParameter;

public class FontParameter
extends StyleParameter {
    private final IntegerParameter sizeParam_;
    private final ChoiceParameter styleParam_;
    private Font fontValue_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FontParameter(String name) {
        super(name, GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        String dflt = "dialog";
        if (Arrays.asList(this.getOptionNames()).contains(dflt)) {
            this.setDefault(dflt);
        } else {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            this.setDefault(this.getOptionNames()[0]);
        }
        this.setPrompt("Font family name");
        this.setUsage("dialog|serif|...");
        this.setDescription(new String[]{"<p>Determines the font that will be used for textual annotation", "of the plot, including axes etc.", "The available names are:", this.getOptionList(), "</p>"});
        this.sizeParam_ = new IntegerParameter(name + "size");
        this.sizeParam_.setPrompt("Font size");
        this.sizeParam_.setDescription(new String[]{"<p>Sets the font size used for plot annotations.", "</p>"});
        this.sizeParam_.setDefault(Integer.toString(12));
        this.sizeParam_.setMinimum(1);
        this.styleParam_ = new ChoiceParameter(name + "style");
        this.styleParam_.addOption((Object)new Integer(0), "plain");
        this.styleParam_.addOption((Object)new Integer(1), "bold");
        this.styleParam_.addOption((Object)new Integer(2), "italic");
        this.styleParam_.addOption((Object)new Integer(3), "bold-italic");
        this.styleParam_.setPrompt("Font modifier");
        this.styleParam_.setDescription(new String[]{"<p>Gives a style in which the font is to be applied for", "plot annotations.", "Options are", "<code>plain</code>,", "<code>bold</code>,", "<code>italic</code> and", "<code>bold-italic</code>.", "</p>"});
        this.styleParam_.setDefault("plain");
    }

    public Parameter[] getAssociatedParameters() {
        return new Parameter[]{this.sizeParam_, this.styleParam_};
    }

    public void setValueFromString(Environment env, String sval) throws TaskException {
        int size = this.sizeParam_.intValue(env);
        int style = (Integer)this.styleParam_.objectValue(env);
        super.setValueFromString(env, sval);
        String family = (String)this.objectValue(env);
        this.fontValue_ = new Font(family, style, size);
    }

    public Font fontValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        return this.fontValue_;
    }

    static {
        $assertionsDisabled = !FontParameter.class.desiredAssertionStatus();
    }
}

