/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.JComponent;
import javax.swing.OverlayLayout;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.PlotSurface;
import uk.ac.starlink.ttools.plot.PtPlotSurface;
import uk.ac.starlink.ttools.plot.TablePlot;

public abstract class SurfacePlot
extends TablePlot
implements Printable {
    private PlotSurface surface_;

    protected SurfacePlot() {
        this.setLayout(new OverlayLayout(this));
    }

    public void setSurface(PlotSurface surface) {
        if (this.surface_ != null) {
            JComponent comp = this.surface_.getComponent();
            this.remove(comp);
        }
        this.surface_ = surface;
        this.surface_.setState(this.getState());
        Font font = this.getFont();
        if (font != null && this.surface_ instanceof PtPlotSurface) {
            ((PtPlotSurface)this.surface_).setFont(font);
        }
        JComponent comp = this.surface_.getComponent();
        this.add(comp);
    }

    public PlotSurface getSurface() {
        return this.surface_;
    }

    public Rectangle getPlotBounds() {
        Rectangle bounds = this.getSurface().getClip().getBounds();
        --bounds.y;
        bounds.height += 2;
        return bounds;
    }

    public void setState(PlotState state) {
        super.setState(state);
        if (this.surface_ != null) {
            this.surface_.setState(state);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.surface_ instanceof PtPlotSurface) {
            ((PtPlotSurface)this.surface_).setFont(font);
        }
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex == 0) {
            double compHeight;
            double yscale;
            int gap = 70;
            double pageWidth = pf.getImageableWidth() - 2.0 * (double)gap;
            double pageHeight = pf.getImageableHeight() - 2.0 * (double)gap;
            double xinset = pf.getImageableX() + (double)gap;
            double yinset = pf.getImageableY() + (double)gap;
            double compWidth = this.getWidth();
            double xscale = pageWidth / compWidth;
            if (xscale < (yscale = pageHeight / (compHeight = (double)this.getHeight()))) {
                yscale = xscale;
            } else {
                xscale = yscale;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.translate(xinset, yinset);
            g2.scale(xscale, yscale);
            this.print(g2);
            g2.scale(1.0 / xscale, 1.0 / yscale);
            g2.translate(-xinset, -yinset);
            return 0;
        }
        return 1;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        PlotState state = this.getState();
        if (state != null && state.getValid()) {
            double[][] bounds = state.getRanges();
            this.surface_.setDataRange(bounds[0][0], bounds[1][0], bounds[0][1], bounds[1][1]);
        }
        if (this.isOpaque()) {
            Color color = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(color);
        }
    }
}

