/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Matrices;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.util.FloatList;

public class Shaders {
    private static final Color DARK_GREEN = new Color(0, 160, 0);
    public static final String LUTFILES_PROPERTY = "lut.files";
    public static final Shader FIX_RED = new FixRGBComponentShader("RGB Red", 0);
    public static final Shader FIX_GREEN = new FixRGBComponentShader("RGB Green", 1);
    public static final Shader FIX_BLUE = new FixRGBComponentShader("RGB Blue", 2);
    public static final Shader SCALE_RED = new ScaleRGBComponentShader("Scale Red", 0);
    public static final Shader SCALE_GREEN = new ScaleRGBComponentShader("Scale Green", 1);
    public static final Shader SCALE_BLUE = new ScaleRGBComponentShader("Scale Blue", 2);
    public static final Shader FIX_Y = new FixYuvShader("YUV Y", 0);
    public static final Shader FIX_U = new FixYuvShader("YUV U", 1);
    public static final Shader FIX_V = new FixYuvShader("YUV V", 2);
    public static final Shader HSV_H = new FixHsvShader("HSV H", 0);
    public static final Shader HSV_S = new FixHsvShader("HSV S", 1);
    public static final Shader HSV_V = new FixHsvShader("HSV V", 2);
    public static final Shader RED_BLUE = Shaders.createInterpolationShader("Red-Blue", Color.RED, Color.BLUE);
    public static final Shader WHITE_BLACK = Shaders.createInterpolationShader("Greyscale", Color.WHITE, Color.BLACK);
    public static final Shader BLACK_WHITE = Shaders.createInterpolationShader("Greyscale", Color.BLACK, Color.WHITE);
    public static final Shader LUT_AIPS0 = new ResourceLutShader("AIPS0", "aips0.lut");
    public static final Shader LUT_BACKGR = new ResourceLutShader("Background", "backgr.lut");
    public static final Shader LUT_COLOR = new ResourceLutShader("Colour", "color.lut");
    public static final Shader LUT_HEAT = new ResourceLutShader("Heat", "heat.lut");
    public static final Shader LUT_IDL2 = new ResourceLutShader("IDL2", "idl2.lut");
    public static final Shader LUT_IDL4 = new ResourceLutShader("IDL4", "idl4.lut");
    public static final Shader LUT_ISOPHOT = new ResourceLutShader("Isophot", "isophot.lut");
    public static final Shader LUT_LIGHT = new ResourceLutShader("Light", "light.lut");
    public static final Shader LUT_MANYCOL = new ResourceLutShader("Manycol", "manycol.lut");
    public static final Shader LUT_PASTEL = new ResourceLutShader("Pastel", "pastel.lut");
    public static final Shader LUT_RAINBOW = new ResourceLutShader("Rainbow", "rainbow1.lut");
    public static final Shader LUT_RAMP = new ResourceLutShader("Ramp", "ramp.lut");
    public static final Shader LUT_RANDOM = new ResourceLutShader("Random", "random.lut");
    public static final Shader LUT_REAL = new ResourceLutShader("Real", "real.lut");
    public static final Shader LUT_SMOOTH = new ResourceLutShader("Smooth", "smooth.lut");
    public static final Shader LUT_STAIRCASE = new ResourceLutShader("Staircase", "staircase.lut");
    public static final Shader LUT_STANDARD = new ResourceLutShader("Standard", "standard.lut");
    public static final Shader[] LUT_SHADERS = new Shader[]{LUT_AIPS0, LUT_BACKGR, LUT_COLOR, LUT_HEAT, LUT_IDL2, LUT_IDL4, LUT_ISOPHOT, LUT_LIGHT, LUT_MANYCOL, LUT_PASTEL, LUT_RAINBOW, LUT_RAMP, LUT_RANDOM, LUT_REAL, LUT_SMOOTH, LUT_STAIRCASE, LUT_STANDARD};
    private static final String LUT_BASE = "/uk/ac/starlink/ttools/colormaps/";
    private static Shader[] customShaders_;
    private static final Logger logger_;
    public static final Shader NULL;
    public static final Shader TRANSPARENCY;
    public static final Shader FIX_INTENSITY;
    public static final Shader SCALE_INTENSITY;
    public static final Shader FIX_HUE;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$plot$Shaders;

    public static Shader createInterpolationShader(String name, Color color0, Color color1) {
        final float[] rgba0 = color0.getRGBComponents(null);
        final float[] rgba1 = color1.getRGBComponents(null);
        return new BasicShader(name){

            public void adjustRgba(float[] rgba, float value) {
                for (int i = 0; i < 3; ++i) {
                    float f0 = rgba0[i];
                    float f1 = rgba1[i];
                    rgba[i] = f0 + (f1 - f0) * value;
                }
            }
        };
    }

    public static Shader createFixedShader(String name, Color color) {
        final float[] fixedRgba = color.getRGBComponents(new float[4]);
        return new BasicShader(name){

            public void adjustRgba(float[] rgba, float value) {
                for (int i = 0; i < 4; ++i) {
                    rgba[i] = fixedRgba[i];
                }
            }
        };
    }

    public static Shader[] getCustomShaders() {
        if (customShaders_ == null) {
            String fileset = System.getProperty(LUTFILES_PROPERTY);
            ArrayList<TextFileLutShader> shaderList = new ArrayList<TextFileLutShader>();
            if (fileset != null && fileset.length() > 0) {
                String[] files = fileset.split("\\Q" + File.pathSeparator + "\\E");
                for (int i = 0; i < files.length; ++i) {
                    String f = files[i];
                    try {
                        shaderList.add(new TextFileLutShader(new File(f), 256));
                        continue;
                    }
                    catch (IOException e) {
                        logger_.warning("Failed to load custom lookup table " + f + " (" + e + ")");
                    }
                }
            }
            customShaders_ = shaderList.toArray(new Shader[0]);
        }
        return customShaders_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static float[] readFloatArray(URL loc) throws IOException {
        DataInputStream in = new DataInputStream(new BufferedInputStream(loc.openStream()));
        FloatList flist = new FloatList();
        try {
            try {
                float value;
                while ((value = in.readFloat()) >= 0.0f && value <= 1.0f) {
                    flist.add(value);
                }
                throw new IOException("RGB values out of range");
            }
            catch (EOFException e) {
                float[] fArray = flist.toFloatArray();
                return fArray;
            }
        }
        finally {
            in.close();
        }
    }

    private static final float enforceBounds(float f) {
        if (f >= 0.0f) {
            if (f <= 1.0f) {
                return f;
            }
            return 1.0f;
        }
        return 0.0f;
    }

    private static float[] interpolateRgb(float[] in, int nsamp) {
        int nin = in.length / 3;
        float[] out = new float[nsamp * 3];
        for (int is = 0; is < nsamp; ++is) {
            for (int ic = 0; ic < 3; ++ic) {
                int ilo = is * (nin - 1) / (nsamp - 1);
                int ihi = Math.min(ilo + 1, nin - 1);
                float frac = (float)(is * (nin - 1)) / (float)(nsamp - 1) - (float)ilo;
                out[is * 3 + ic] = in[ilo * 3 + ic] + frac * (in[ihi * 3 + ic] - in[ilo * 3 + ic]);
            }
        }
        return out;
    }

    public static Shader invert(final Shader shader) {
        return new Shader(){

            public void adjustRgba(float[] rgba, float value) {
                shader.adjustRgba(rgba, 1.0f - value);
            }

            public boolean isAbsolute() {
                return shader.isAbsolute();
            }

            public String getName() {
                return "-" + shader.getName();
            }

            public Icon createIcon(final boolean horizontal, final int width, final int height, int xpad, int ypad) {
                final Icon icon = shader.createIcon(horizontal, width, height, xpad, ypad);
                return new Icon(){

                    public int getIconWidth() {
                        return icon.getIconWidth();
                    }

                    public int getIconHeight() {
                        return icon.getIconHeight();
                    }

                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        Graphics2D g2 = (Graphics2D)g;
                        AffineTransform trans = g2.getTransform();
                        g2.translate(x + width / 2, y + height / 2);
                        g2.scale(horizontal ? -1.0 : 1.0, horizontal ? 1.0 : -1.0);
                        icon.paintIcon(c, g2, -width / 2, -height / 2);
                        g2.setTransform(trans);
                    }
                };
            }
        };
    }

    private static Icon create1dIcon(Shader shader, boolean horizontal, Color baseColor, int width, int height, int xpad, int ypad) {
        return new ShaderIcon1(shader, horizontal, baseColor, width, height, xpad, ypad);
    }

    public static Icon create2dIcon(Shader xShader, Shader yShader, boolean xFirst, Color baseColor, int width, int height, int xpad, int ypad) {
        return new ShaderIcon2(xShader, yShader, xFirst, baseColor, width, height, xpad, ypad);
    }

    public static boolean isTransparent(Shader shader) {
        if (shader == null) {
            return false;
        }
        float[] rgba = new float[]{1.0f, 0.1f, 0.6f, 1.0f};
        shader.adjustRgba(rgba, 0.8f);
        if (rgba[3] != 1.0f) {
            return true;
        }
        shader.adjustRgba(rgba, 0.2f);
        return rgba[3] != 1.0f;
    }

    static {
        logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot");
        NULL = new BasicShader("None", new Color(1, 1, 1, 0)){

            public void adjustRgba(float[] rgba, float value) {
            }
        };
        TRANSPARENCY = new BasicShader("Transparency", Color.BLACK){

            public void adjustRgba(float[] rgba, float value) {
                rgba[3] = rgba[3] * (value * value);
            }
        };
        FIX_INTENSITY = new BasicShader("Intensity", Color.BLUE){

            public void adjustRgba(float[] rgba, float value) {
                float max = Math.max(rgba[0], Math.max(rgba[1], rgba[2]));
                float m1 = 1.0f / max;
                for (int i = 0; i < 3; ++i) {
                    rgba[i] = 1.0f - value * (1.0f - rgba[i] * m1);
                }
            }
        };
        SCALE_INTENSITY = new BasicShader("Scale Intensity", Color.BLUE){

            public void adjustRgba(float[] rgba, float value) {
                for (int i = 0; i < 3; ++i) {
                    rgba[i] = 1.0f - value * (1.0f - rgba[i]);
                }
            }
        };
        FIX_HUE = new BasicShader("Hue"){

            public void adjustRgba(float[] rgba, float value) {
                float b;
                float g;
                float r;
                float h = value * 359.99f;
                float h6 = h / 60.0f;
                int hi = (int)h6;
                float f = h6 - (float)hi;
                float s = 1.0f;
                float v = 1.0f;
                float p = v * (1.0f - s);
                float q = v * (1.0f - f * s);
                float t = v * (1.0f - (1.0f - f) * s);
                switch (hi) {
                    case 0: {
                        r = v;
                        g = t;
                        b = p;
                        break;
                    }
                    case 1: {
                        r = q;
                        g = v;
                        b = p;
                        break;
                    }
                    case 2: {
                        r = p;
                        g = v;
                        b = t;
                        break;
                    }
                    case 3: {
                        r = p;
                        g = q;
                        b = v;
                        break;
                    }
                    case 4: {
                        r = t;
                        g = p;
                        b = v;
                        break;
                    }
                    case 5: {
                        r = v;
                        g = p;
                        b = q;
                        break;
                    }
                    default: {
                        r = 0.0f;
                        g = 0.0f;
                        b = 0.0f;
                    }
                }
                rgba[0] = r;
                rgba[1] = g;
                rgba[2] = b;
            }
        };
    }

    private static class ShaderIcon2
    implements Icon {
        private final Shader xShader_;
        private final Shader yShader_;
        private final boolean xFirst_;
        private final int width_;
        private final int height_;
        private final int xpad_;
        private final int ypad_;
        private final float[] baseRgba_;

        public ShaderIcon2(Shader xShader, Shader yShader, boolean xFirst, Color baseColor, int width, int height, int xpad, int ypad) {
            this.xShader_ = xShader;
            this.yShader_ = yShader;
            this.xFirst_ = xFirst;
            this.width_ = width;
            this.height_ = height;
            this.xpad_ = xpad;
            this.ypad_ = ypad;
            this.baseRgba_ = baseColor.getRGBComponents(null);
        }

        public int getIconWidth() {
            return this.width_;
        }

        public int getIconHeight() {
            return this.height_;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color origColor = g.getColor();
            int nx = this.width_ - 2 * this.xpad_;
            int ny = this.height_ - 2 * this.ypad_;
            float nx1 = 1.0f / (float)(nx - 1);
            float ny1 = 1.0f / (float)(ny - 1);
            for (int ix = 0; ix < nx; ++ix) {
                for (int iy = 0; iy < ny; ++iy) {
                    g.setColor(this.getColor((float)ix * nx1, (float)iy * ny1));
                    g.drawRect(ix + this.xpad_, iy + this.ypad_, 1, 1);
                }
            }
            g.setColor(origColor);
        }

        private Color getColor(float xval, float yval) {
            float[] rgba = (float[])this.baseRgba_.clone();
            if (this.xFirst_) {
                this.xShader_.adjustRgba(rgba, xval);
                this.yShader_.adjustRgba(rgba, yval);
            } else {
                this.yShader_.adjustRgba(rgba, yval);
                this.xShader_.adjustRgba(rgba, xval);
            }
            return new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
        }
    }

    private static class ShaderIcon1
    implements Icon {
        private final Shader shader_;
        private final boolean horizontal_;
        private final int width_;
        private final int height_;
        private final int xpad_;
        private final int ypad_;
        private final float[] baseRgba_;

        public ShaderIcon1(Shader shader, boolean horizontal, Color baseColor, int width, int height, int xpad, int ypad) {
            this.shader_ = shader;
            this.horizontal_ = horizontal;
            this.width_ = width;
            this.height_ = height;
            this.xpad_ = xpad;
            this.ypad_ = ypad;
            this.baseRgba_ = baseColor.getRGBComponents(null);
        }

        public int getIconWidth() {
            return this.width_;
        }

        public int getIconHeight() {
            return this.height_;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color origColor = g.getColor();
            int npix = this.horizontal_ ? this.width_ - 2 * this.xpad_ : this.height_ - 2 * this.ypad_;
            float np1 = 1.0f / (float)(npix - 1);
            int xlo = x + this.xpad_;
            int xhi = x + this.width_ - this.xpad_;
            int ylo = y + this.ypad_;
            int yhi = y + this.height_ - this.ypad_;
            for (int ipix = 0; ipix < npix; ++ipix) {
                g.setColor(this.getColor((float)ipix * np1));
                if (this.horizontal_) {
                    g.fillRect(xlo + ipix - 1, ylo, 1, yhi - ylo);
                    continue;
                }
                g.fillRect(xlo, ylo + ipix - 1, xhi - xlo, 1);
            }
            g.setColor(origColor);
        }

        private Color getColor(float value) {
            float[] rgba = (float[])this.baseRgba_.clone();
            this.shader_.adjustRgba(rgba, value);
            return new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
        }
    }

    private static class TextFileLutShader
    extends LutShader {
        private final float[] lut_;
        private static final Pattern TRIPLE_REGEX;
        static final /* synthetic */ boolean $assertionsDisabled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TextFileLutShader(File file, int minSamples) throws IOException {
            super(file.getName());
            FloatList flist = new FloatList();
            int iline = 0;
            BufferedReader in = new BufferedReader(new FileReader(file));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    ++iline;
                    String tline = line.replaceFirst("#.*", "").trim();
                    if (tline.length() <= 0) continue;
                    Matcher matcher = TRIPLE_REGEX.matcher(tline);
                    if (matcher.matches()) {
                        for (int i = 0; i < 3; ++i) {
                            float val = Float.parseFloat(matcher.group(i + 1));
                            if (!(val >= 0.0f) || !(val <= 1.0f)) {
                                throw new IOException("Not in range 0-1: " + file + " line " + iline);
                            }
                            flist.add(val);
                        }
                        continue;
                    }
                    throw new IOException("Not 3 numbers: " + file + " line " + iline);
                }
            }
            finally {
                in.close();
            }
            float[] lut = flist.toFloatArray();
            float[] fArray = this.lut_ = lut.length < minSamples ? Shaders.interpolateRgb(lut, minSamples) : lut;
            if (!$assertionsDisabled && this.lut_.length % 3 != 0) {
                throw new AssertionError();
            }
        }

        protected float[] getRgbLut() {
            return this.lut_;
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$ttools$plot$Shaders == null ? (class$uk$ac$starlink$ttools$plot$Shaders = Shaders.class$("uk.ac.starlink.ttools.plot.Shaders")) : class$uk$ac$starlink$ttools$plot$Shaders).desiredAssertionStatus();
            TRIPLE_REGEX = Pattern.compile("\\s*([0-9.e]+)\\s+([0-9.e]+)\\s+([0-9.e]+)\\s*");
        }
    }

    private static class ResourceLutShader
    extends LutShader {
        private final String resourceName_;
        private float[] lut_;

        ResourceLutShader(String name, String resourceName) {
            super(name);
            this.resourceName_ = resourceName;
        }

        protected float[] getRgbLut() {
            if (this.lut_ == null) {
                String loc = Shaders.LUT_BASE + this.resourceName_;
                logger_.config("Reading lookup table at " + loc);
                URL url = (class$uk$ac$starlink$ttools$plot$Shaders == null ? (class$uk$ac$starlink$ttools$plot$Shaders = Shaders.class$("uk.ac.starlink.ttools.plot.Shaders")) : class$uk$ac$starlink$ttools$plot$Shaders).getResource(loc);
                try {
                    if (url == null) {
                        throw new FileNotFoundException("No resource " + loc);
                    }
                    this.lut_ = Shaders.readFloatArray(url);
                }
                catch (IOException e) {
                    logger_.warning("No colour map for " + this + ": " + e);
                    this.lut_ = new float[3];
                }
            }
            return this.lut_;
        }
    }

    private static abstract class LutShader
    extends BasicShader {
        LutShader(String name) {
            super(name);
        }

        protected abstract float[] getRgbLut();

        public void adjustRgba(float[] rgba, float value) {
            float[] lut = this.getRgbLut();
            int nsamp = lut.length / 3;
            int is3 = 3 * (int)(value * (float)(nsamp - 1) + 0.5f);
            rgba[0] = lut[is3 + 0];
            rgba[1] = lut[is3 + 1];
            rgba[2] = lut[is3 + 2];
        }
    }

    private static class ScaleRGBComponentShader
    extends BasicShader {
        private final int icomp_;

        ScaleRGBComponentShader(String name, int icomp) {
            super(name, Color.GRAY);
            this.icomp_ = icomp;
        }

        public void adjustRgba(float[] rgba, float value) {
            int n = this.icomp_;
            rgba[n] = rgba[n] * value;
        }
    }

    private static class FixHsvShader
    extends FixColorSpaceComponentShader {
        static final /* synthetic */ boolean $assertionsDisabled;

        FixHsvShader(String name, int icomp) {
            super(name, Color.RED, icomp);
        }

        protected void toSpace(float[] rgb) {
            float sh;
            float h;
            float r = rgb[0];
            float g = rgb[1];
            float b = rgb[2];
            float max = Math.max(r, Math.max(g, b));
            float min = Math.min(r, Math.min(g, b));
            float v = max;
            float s = max > 0.0f ? 1.0f - min / max : 0.0f;
            float diff = max - min;
            if (diff == 0.0f) {
                h = 0.0f;
            } else if (r == max) {
                h = 60.0f * (g - b) / diff + 0.0f;
            } else if (g == max) {
                h = 60.0f * (b - r) / diff + 120.0f;
            } else if (b == max) {
                h = 60.0f * (r - g) / diff + 240.0f;
            } else {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                h = 0.0f;
            }
            if (h < 0.0f) {
                h += 360.0f;
            }
            rgb[0] = sh = h / 360.0f;
            rgb[1] = s;
            rgb[2] = v;
        }

        protected void fromSpace(float[] hsv) {
            float b;
            float g;
            float r;
            float sh = hsv[0];
            float s = hsv[1];
            float v = hsv[2];
            float h6 = sh * 6.0f;
            int ih = (int)h6;
            float f = h6 - (float)ih;
            float p = v * (1.0f - s);
            float q = v * (1.0f - f * s);
            float t = v * (1.0f - (1.0f - f) * s);
            switch (ih) {
                case 0: {
                    r = v;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = v;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = v;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = v;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = v;
                    break;
                }
                case 5: 
                case 6: {
                    r = v;
                    g = p;
                    b = q;
                    break;
                }
                default: {
                    r = 0.0f;
                    g = 0.0f;
                    b = 0.0f;
                    if (!$assertionsDisabled) {
                        throw new AssertionError(ih);
                    }
                    break;
                }
            }
            hsv[0] = r;
            hsv[1] = g;
            hsv[2] = b;
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$ttools$plot$Shaders == null ? (class$uk$ac$starlink$ttools$plot$Shaders = Shaders.class$("uk.ac.starlink.ttools.plot.Shaders")) : class$uk$ac$starlink$ttools$plot$Shaders).desiredAssertionStatus();
        }
    }

    private static class FixYPbPrShader
    extends FixColorSpaceComponentShader {
        private static final float[] T;
        private static final float[] F;

        FixYPbPrShader(String name, int icomp) {
            super(name, DARK_GREEN, icomp);
        }

        protected void toSpace(float[] rgb) {
            float r = rgb[0];
            float g = rgb[1];
            float b = rgb[2];
            float y = r * T[0] + g * T[1] + b * T[2];
            float pb = r * T[3] + g * T[4] + b * T[5];
            float pr = r * T[6] + g * T[7] + b * T[8];
            rgb[0] = Shaders.enforceBounds(y);
            rgb[1] = Shaders.enforceBounds(pb + 0.5f);
            rgb[2] = Shaders.enforceBounds(pr + 0.5f);
        }

        protected void fromSpace(float[] yPbPr) {
            float y = yPbPr[0];
            float pb = yPbPr[1] - 0.5f;
            float pr = yPbPr[2] - 0.5f;
            float r = y * F[0] + pb * F[1] + pr * F[2];
            float g = y * F[3] + pb * F[4] + pr * F[5];
            float b = y * F[6] + pb * F[7] + pr * F[8];
            yPbPr[0] = Shaders.enforceBounds(r);
            yPbPr[1] = Shaders.enforceBounds(g);
            yPbPr[2] = Shaders.enforceBounds(b);
        }

        static {
            double[] toRgb = new double[]{0.299, 0.587, 0.114, -0.168736, -0.331264, 0.5, 0.5, -0.418688, -0.081312};
            double[] fromRgb = Matrices.invert(toRgb);
            T = new float[9];
            F = new float[9];
            for (int i = 0; i < 9; ++i) {
                FixYPbPrShader.T[i] = (float)toRgb[i];
                FixYPbPrShader.F[i] = (float)fromRgb[i];
            }
        }
    }

    private static class FixYuvShader
    extends FixColorSpaceComponentShader {
        FixYuvShader(String name, int icomp) {
            super(name, DARK_GREEN, icomp);
        }

        protected void toSpace(float[] rgb) {
            float r = rgb[0];
            float g = rgb[1];
            float b = rgb[2];
            float y = 0.299f * r + 0.587f * g + 0.114f * b;
            float u = 0.436f * (b - y) / 0.886f;
            float v = 0.615f * (r - y) / 0.701f;
            float su = 0.5f * (u / 0.436f) + 0.5f;
            float sv = 0.5f * (v / 0.615f) + 0.5f;
            rgb[0] = Shaders.enforceBounds(y);
            rgb[1] = Shaders.enforceBounds(su);
            rgb[2] = Shaders.enforceBounds(sv);
        }

        protected void fromSpace(float[] yuv) {
            float y = yuv[0];
            float su = yuv[1];
            float sv = yuv[2];
            float u = (su * 2.0f - 1.0f) * 0.436f;
            float v = (sv * 2.0f - 1.0f) * 0.615f;
            float r = y + 1.13983f * v;
            float g = y - 0.39466f * u - 0.5806f * v;
            float b = y + 2.03211f * u;
            yuv[0] = Shaders.enforceBounds(r);
            yuv[1] = Shaders.enforceBounds(g);
            yuv[2] = Shaders.enforceBounds(b);
        }
    }

    private static class FixRGBComponentShader
    extends BasicShader {
        private final int icomp_;

        FixRGBComponentShader(String name, int icomp) {
            super(name, Color.BLACK);
            this.icomp_ = icomp;
        }

        public void adjustRgba(float[] rgba, float value) {
            rgba[this.icomp_] = value;
        }
    }

    private static abstract class FixColorSpaceComponentShader
    extends BasicShader {
        private final int icomp_;

        FixColorSpaceComponentShader(String name, Color baseColor, int icomp) {
            super(name, baseColor);
            this.icomp_ = icomp;
        }

        protected abstract void toSpace(float[] var1);

        protected abstract void fromSpace(float[] var1);

        public void adjustRgba(float[] rgba, float value) {
            this.toSpace(rgba);
            rgba[this.icomp_] = value;
            this.fromSpace(rgba);
        }
    }

    private static abstract class BasicShader
    implements Shader {
        private final String name_;
        private final Color baseColor_;

        BasicShader(String name) {
            this(name, null);
        }

        BasicShader(String name, Color baseColor) {
            this.name_ = name;
            this.baseColor_ = baseColor;
        }

        public String getName() {
            return this.name_;
        }

        public Icon createIcon(boolean horizontal, int width, int height, int xpad, int ypad) {
            return Shaders.create1dIcon(this, horizontal, this.baseColor_ == null ? Color.BLACK : this.baseColor_, width, height, xpad, ypad);
        }

        public boolean isAbsolute() {
            return this.baseColor_ == null;
        }

        public String toString() {
            return this.name_;
        }
    }
}

