/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.util.Arrays;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.convert.ValueConverter;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.Shader;

public class PlotState {
    private boolean valid_;
    private int mainNdim_;
    private SimpleValueInfo[] axes_;
    private ValueConverter[] converters_;
    private boolean[] logFlags_;
    private boolean[] flipFlags_;
    private boolean grid_;
    private boolean antialias_;
    private PlotData plotData_;
    private double[][] ranges_ = new double[0][];
    private String[] axisLabels_ = new String[0];
    private Shader[] shaders_ = new Shader[0];

    public void setValid(boolean valid) {
        this.valid_ = valid;
    }

    public boolean getValid() {
        return this.valid_;
    }

    public void setMainNdim(int mainNdim) {
        this.mainNdim_ = mainNdim;
    }

    public int getMainNdim() {
        return this.mainNdim_;
    }

    public void setAxes(ValueInfo[] axes) {
        this.axes_ = new SimpleValueInfo[axes.length];
        for (int i = 0; i < axes.length; ++i) {
            this.axes_[i] = new SimpleValueInfo(axes[i]);
        }
    }

    public ValueInfo[] getAxes() {
        return this.axes_;
    }

    public void setLogFlags(boolean[] logFlags) {
        this.logFlags_ = logFlags;
    }

    public boolean[] getLogFlags() {
        return this.logFlags_;
    }

    public void setFlipFlags(boolean[] flipFlags) {
        this.flipFlags_ = flipFlags;
    }

    public boolean[] getFlipFlags() {
        return this.flipFlags_;
    }

    public void setGrid(boolean grid) {
        this.grid_ = grid;
    }

    public boolean getGrid() {
        return this.grid_;
    }

    public void setAntialias(boolean antialias) {
        this.antialias_ = antialias;
    }

    public boolean getAntialias() {
        return this.antialias_;
    }

    public void setRanges(double[][] ranges) {
        this.ranges_ = ranges;
    }

    public double[][] getRanges() {
        return this.ranges_;
    }

    public void setAxisLabels(String[] labels) {
        this.axisLabels_ = labels;
    }

    public String[] getAxisLabels() {
        return this.axisLabels_;
    }

    public void setShaders(Shader[] shaders) {
        this.shaders_ = shaders;
    }

    public Shader[] getShaders() {
        return this.shaders_;
    }

    public void setConverters(ValueConverter[] converters) {
        this.converters_ = converters;
    }

    public ValueConverter[] getConverters() {
        return this.converters_;
    }

    public void setPlotData(PlotData plotData) {
        this.plotData_ = plotData;
    }

    public PlotData getPlotData() {
        return this.plotData_;
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof PlotState)) {
            return false;
        }
        PlotState other = (PlotState)otherObject;
        return this.valid_ == other.valid_ && this.mainNdim_ == other.mainNdim_ && this.grid_ == other.grid_ && this.antialias_ == other.antialias_ && Arrays.equals((Object[])this.axes_, (Object[])other.axes_) && Arrays.equals(this.logFlags_, other.logFlags_) && Arrays.equals(this.flipFlags_, other.flipFlags_) && Arrays.equals(this.axisLabels_, other.axisLabels_) && Arrays.equals(this.shaders_, other.shaders_) && Arrays.equals(this.converters_, other.converters_) && PlotState.equalRanges(this.ranges_, other.ranges_) && (this.plotData_ == null ? other.plotData_ == null : this.plotData_.equals(other.plotData_));
    }

    public String compare(PlotState o) {
        StringBuffer sbuf = new StringBuffer("Mismatches:");
        sbuf.append(this.valid_ == o.valid_ ? "" : " valid");
        sbuf.append(this.mainNdim_ == o.mainNdim_ ? "" : " mainNdim");
        sbuf.append(this.grid_ == o.grid_ ? "" : " grid");
        sbuf.append(this.antialias_ == o.antialias_ ? "" : " antialias");
        sbuf.append(Arrays.equals((Object[])this.axes_, (Object[])o.axes_) ? "" : " axes");
        sbuf.append(Arrays.equals(this.logFlags_, o.logFlags_) ? "" : " log");
        sbuf.append(Arrays.equals(this.flipFlags_, o.flipFlags_) ? "" : " flip ");
        sbuf.append(Arrays.equals(this.axisLabels_, o.axisLabels_) ? "" : " axisLabels");
        sbuf.append(Arrays.equals(this.shaders_, o.shaders_) ? "" : " shaders");
        sbuf.append(Arrays.equals(this.converters_, o.converters_) ? "" : " converters");
        sbuf.append(PlotState.equalRanges(this.ranges_, o.ranges_) ? "" : " ranges");
        sbuf.append((this.plotData_ == null ? o.plotData_ == null : this.plotData_.equals(o.plotData_)) ? "" : " plotData");
        return sbuf.toString();
    }

    public int hashCode() {
        int i;
        int code = 555;
        code = 23 * code + (this.valid_ ? 99 : 999);
        code = 23 * code + this.mainNdim_;
        code = 23 * code + (this.grid_ ? 11 : 17);
        code = 23 * code + (this.antialias_ ? 109 : 901);
        for (i = 0; i < this.axes_.length; ++i) {
            code = 23 * code + this.axes_[i].hashCode();
        }
        for (i = 0; i < this.logFlags_.length; ++i) {
            code = 23 * code + (this.logFlags_[i] ? 1 : 2);
        }
        for (i = 0; i < this.flipFlags_.length; ++i) {
            code = 23 * code + (this.flipFlags_[i] ? 1 : 2);
        }
        for (i = 0; i < this.axisLabels_.length; ++i) {
            code = 23 * code + (this.axisLabels_[i] == null ? 0 : this.axisLabels_[i].hashCode());
        }
        for (i = 0; i < this.shaders_.length; ++i) {
            code = 23 * code + (this.shaders_[i] == null ? 0 : this.shaders_[i].hashCode());
        }
        for (i = 0; i < this.converters_.length; ++i) {
            code = 23 * code + (this.converters_[i] == null ? 0 : this.converters_[i].hashCode());
        }
        for (i = 0; i < this.ranges_.length; ++i) {
            code = 23 * code + Float.floatToIntBits((float)this.ranges_[i][0]);
            code = 23 * code + Float.floatToIntBits((float)this.ranges_[i][1]);
        }
        code = 23 * code + (this.plotData_ == null ? 0 : this.plotData_.hashCode());
        return code;
    }

    static boolean equalRanges(double[][] r1, double[][] r2) {
        if (r1.length == r2.length) {
            for (int i = 0; i < r1.length; ++i) {
                if (r1[i] != null && r2[i] != null) {
                    double a10 = r1[i][0];
                    double a11 = r1[i][1];
                    double a20 = r2[i][0];
                    double a21 = r2[i][1];
                    if ((a10 == a20 || Double.isNaN(a10) && Double.isNaN(a20)) && (a11 == a21 || Double.isNaN(a11) && Double.isNaN(a21))) continue;
                    return false;
                }
                if (!(r1[i] != null ^ r2[i] != null)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected static class SimpleValueInfo
    extends DefaultValueInfo {
        public SimpleValueInfo(ValueInfo baseInfo) {
            super(baseInfo.getName(), baseInfo.getContentClass());
            String units = baseInfo.getUnitString();
            String desc = baseInfo.getDescription();
            this.setUnitString(units == null ? "" : units);
            this.setDescription(desc == null ? "" : desc);
        }

        public boolean equals(Object o) {
            if (o instanceof SimpleValueInfo) {
                SimpleValueInfo other = (SimpleValueInfo)((Object)o);
                return this.getName().equals(other.getName()) && this.getContentClass().equals(other.getContentClass()) && this.getUnitString().equals(other.getUnitString()) && this.getDescription().equals(other.getDescription());
            }
            return false;
        }

        public int hashCode() {
            int code = 5555;
            code = 23 * code + this.getName().hashCode();
            code = 23 * code + this.getContentClass().hashCode();
            code = 23 * code + this.getUnitString().hashCode();
            code = 23 * code + this.getDescription().hashCode();
            return code;
        }
    }
}

