/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import uk.ac.starlink.ttools.plot.BinGrid;
import uk.ac.starlink.ttools.plot.DensityPlotEvent;
import uk.ac.starlink.ttools.plot.DensityPlotState;
import uk.ac.starlink.ttools.plot.DensityStyle;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.PlotDataPointIterator;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.PlotSurface;
import uk.ac.starlink.ttools.plot.PointIterator;
import uk.ac.starlink.ttools.plot.PointPlacer;
import uk.ac.starlink.ttools.plot.PointSequence;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot.SurfacePlot;
import uk.ac.starlink.ttools.plot.TablePlot;

public class DensityPlot
extends SurfacePlot {
    private BinGrid[] grids_;
    private double[] gridLoBounds_;
    private double[] gridHiBounds_;
    private int nPotential_;
    private int nIncluded_;
    private int nVisible_;
    private PlotData lastData_;
    private BufferedImage image_;
    private Rectangle lastPlotZone_;
    private DensityPlotState lastState_;
    private double[] loCuts_;
    private double[] hiCuts_;
    private DensityStyle[] styles_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DensityPlot(PlotSurface surface) {
        this.setPreferredSize(new Dimension(400, 400));
        this.add(new DensityDataPanel());
        surface.getComponent().setOpaque(false);
        this.setSurface(surface);
    }

    public void setState(PlotState state) {
        super.setState(state);
        PlotData data = state.getPlotData();
        if (!data.equals(this.lastData_)) {
            this.grids_ = null;
            this.image_ = null;
            this.lastData_ = data;
        }
    }

    private void drawData(Graphics2D g2) {
        double[] hiCuts;
        double[] loCuts;
        Rectangle plotZone = this.getSurface().getClip().getBounds();
        DensityPlotState state = (DensityPlotState)this.getState();
        Shape clip = g2.getClip();
        Color color = g2.getColor();
        if (state != null && state.getValid()) {
            int psize = state.getPixelSize();
            BufferedImage im = this.getImage(plotZone, state);
            AffineTransformOp scaleOp = new AffineTransformOp(AffineTransform.getScaleInstance(psize, psize), 1);
            g2.setClip(plotZone);
            try {
                g2.drawImage(im, scaleOp, plotZone.x, plotZone.y);
            }
            catch (OutOfMemoryError e) {
                String msg = "Out of memory";
                if (psize > 4) {
                    msg = msg + " (Mac OSX inefficiency?)";
                    msg = msg + " - try smaller pixels";
                }
                g2.drawString(msg, 100, 100);
            }
            loCuts = this.loCuts_;
            hiCuts = this.hiCuts_;
            DensityStyle[] styles = this.styles_;
        } else {
            g2.setColor(Color.BLACK);
            g2.fillRect(plotZone.x, plotZone.y, plotZone.width, plotZone.height);
            loCuts = null;
            hiCuts = null;
            Object styles = null;
        }
        g2.setClip(clip);
        g2.setColor(color);
        this.firePlotChangedLater(new DensityPlotEvent(this, state, this.nPotential_, this.nIncluded_, this.nVisible_, loCuts, hiCuts));
    }

    private BufferedImage getImage(Rectangle plotZone, DensityPlotState state) {
        if (this.image_ == null || !plotZone.equals(this.lastPlotZone_) || !state.equals(this.lastState_)) {
            boolean weighted = state.getWeighted();
            int xsize = plotZone.width;
            int ysize = plotZone.height;
            int psize = state.getPixelSize();
            int xpix = (xsize + psize - 1) / psize;
            int ypix = (ysize + psize - 1) / psize;
            int npix = xpix * ypix;
            BinGrid[] grids = this.getBinnedData(plotZone, psize);
            double loCut = state.getLoCut();
            double hiCut = state.getHiCut();
            PlotData data = state.getPlotData();
            int nset = data.getSetCount();
            Style[] styles = new Style[nset];
            for (int is = 0; is < nset; ++is) {
                styles[is] = data.getSetStyle(is);
            }
            if (grids.length > 1) {
                grids = (BinGrid[])grids.clone();
                styles = (Style[])styles.clone();
                this.foldGrids(grids, styles);
            }
            int[] rgb = new int[npix];
            Arrays.fill(rgb, -16777216);
            ArrayList<double[]> cutList = new ArrayList<double[]>();
            if (styles.length > 0) {
                for (int is = 0; is < grids.length; ++is) {
                    DensityStyle style = (DensityStyle)styles[is];
                    BinGrid grid = grids[is];
                    if (!$assertionsDisabled && grid == null != (style == null)) {
                        throw new AssertionError();
                    }
                    if (grid == null) continue;
                    double lo = grid.getCut(loCut);
                    double hi = grid.getCut(hiCut);
                    if (lo == 1.0 && !weighted) {
                        lo = 0.0;
                    }
                    cutList.add(new double[]{lo, hi});
                    byte[] bdata = grid.getBytes(lo, hi, state.getLogZ());
                    for (int ipix = 0; ipix < npix; ++ipix) {
                        rgb[ipix] = rgb[ipix] | style.levelBits(bdata[ipix]);
                    }
                }
            }
            this.loCuts_ = new double[cutList.size()];
            this.hiCuts_ = new double[cutList.size()];
            this.styles_ = new DensityStyle[cutList.size()];
            for (int i = 0; i < cutList.size(); ++i) {
                double[] cuts = (double[])cutList.get(i);
                this.loCuts_[i] = cuts[0];
                this.hiCuts_[i] = cuts[1];
                this.styles_[i] = (DensityStyle)styles[i];
            }
            BufferedImage image = new BufferedImage(xsize, ysize, 2);
            image.setRGB(0, 0, xpix, ypix, rgb, 0, xpix);
            this.image_ = image;
            this.lastPlotZone_ = plotZone;
            this.lastState_ = state;
        }
        return this.image_;
    }

    private void foldGrids(BinGrid[] grids, Style[] styles) {
        int ngrid = grids.length;
        if (styles.length != ngrid) {
            throw new IllegalArgumentException();
        }
        BinGrid[] rgbGrids = new BinGrid[3];
        DensityStyle[] rgbStyles = new DensityStyle[3];
        ArrayList<DensityStyle> seenStyles = new ArrayList<DensityStyle>();
        for (int is = 0; is < ngrid; ++is) {
            int iseen = seenStyles.indexOf(styles[is]);
            if (iseen < 0) {
                DensityStyle style = (DensityStyle)styles[is];
                iseen = seenStyles.size();
                seenStyles.add(style);
                rgbGrids[iseen] = grids[is];
                rgbStyles[iseen] = style;
                continue;
            }
            double[] c1 = grids[is].getSums();
            double[] c0 = rgbGrids[iseen].getSums();
            int npix = c0.length;
            if (!$assertionsDisabled && npix != c1.length) {
                throw new AssertionError();
            }
            for (int i = 0; i < npix; ++i) {
                int n = i;
                c0[n] = c0[n] + c1[i];
            }
            rgbGrids[iseen].recalculate();
        }
        Arrays.fill(grids, null);
        Arrays.fill(styles, null);
        for (int irgb = 0; irgb < seenStyles.size(); ++irgb) {
            grids[irgb] = rgbGrids[irgb];
            styles[irgb] = rgbStyles[irgb];
        }
    }

    public PointIterator getPlottedPointIterator() {
        return new PlotDataPointIterator(this.getState().getPlotData(), this.getPointPlacer());
    }

    public PointPlacer getPointPlacer() {
        final PlotSurface surface = this.getSurface();
        return new PointPlacer(){

            public Point getXY(double[] coords) {
                return surface.dataToGraphics(coords[0], coords[1], true);
            }
        };
    }

    private BinGrid[] getBinnedData(Rectangle zone, int pixsize) {
        DensityPlotState state = (DensityPlotState)this.getState();
        boolean xflip = state.getFlipFlags()[0];
        boolean yflip = state.getFlipFlags()[1];
        boolean xlog = state.getLogFlags()[0];
        boolean ylog = state.getLogFlags()[1];
        double[] loBounds = this.getSurface().graphicsToData(xflip ? zone.x + zone.width : zone.x, yflip ? zone.y : zone.y + zone.height, false);
        double[] hiBounds = this.getSurface().graphicsToData(xflip ? zone.x : zone.x + zone.width, yflip ? zone.y + zone.height : zone.y, false);
        int xsize = zone.width;
        int ysize = zone.height;
        int xpix = (xsize + pixsize - 1) / pixsize;
        int ypix = (ysize + pixsize - 1) / pixsize;
        if (this.grids_ == null || this.grids_.length == 0 || this.grids_[0].getSizeX() != xpix || this.grids_[0].getSizeY() != ypix || !Arrays.equals(loBounds, this.gridLoBounds_) || !Arrays.equals(hiBounds, this.gridHiBounds_)) {
            BinGrid[] grids;
            boolean sumAll;
            double xBase = loBounds[0];
            double yBase = loBounds[1];
            double xMax = hiBounds[0];
            double yMax = hiBounds[1];
            double xBin = (double)xsize / (xlog ? Math.log(hiBounds[0] / loBounds[0]) : hiBounds[0] - loBounds[0]) / (double)pixsize;
            double yBin = (double)ysize / (ylog ? Math.log(hiBounds[1] / loBounds[1]) : hiBounds[1] - loBounds[1]) / (double)pixsize;
            PlotData data = state.getPlotData();
            int nset = data.getSetCount();
            boolean bl = sumAll = !state.getRgb();
            if (sumAll) {
                grids = new BinGrid[]{new BinGrid(xpix, ypix)};
            } else {
                grids = new BinGrid[nset];
                for (int is = 0; is < nset; ++is) {
                    grids[is] = new BinGrid(xpix, ypix);
                }
            }
            boolean[] setFlags = new boolean[nset];
            int nInclude = 0;
            int nVisible = 0;
            PointSequence pseq = data.getPointSequence();
            int ip = 0;
            while (pseq.next()) {
                double[] coords;
                boolean use = false;
                for (int is = 0; is < nset; ++is) {
                    boolean inc;
                    setFlags[is] = inc = pseq.isIncluded(is);
                    use = use || inc;
                }
                if (!(!use || Double.isNaN((coords = pseq.getPoint())[0]) || Double.isNaN(coords[1]) || Double.isNaN(coords[2]) || Double.isInfinite(coords[0]) || Double.isInfinite(coords[1]) || Double.isInfinite(coords[2]) || xlog && coords[0] <= 0.0 || ylog && coords[1] <= 0.0)) {
                    ++nInclude;
                    int ix = (int)Math.floor(xBin * (xlog ? Math.log(coords[0] / loBounds[0]) : coords[0] - loBounds[0]));
                    int iy = (int)Math.floor(yBin * (ylog ? Math.log(coords[1] / loBounds[1]) : coords[1] - loBounds[1]));
                    if (ix >= 0 && ix < xpix && iy >= 0 && iy < ypix) {
                        ++nVisible;
                        if (xflip) {
                            ix = xpix - 1 - ix;
                        }
                        if (yflip) {
                            iy = ypix - 1 - iy;
                        }
                        for (int is = 0; is < nset; ++is) {
                            if (!setFlags[is]) continue;
                            grids[sumAll ? 0 : is].submitDatum(ix, iy, coords[2]);
                        }
                    }
                }
                ++ip;
            }
            pseq.close();
            this.grids_ = grids;
            this.gridLoBounds_ = loBounds;
            this.gridHiBounds_ = hiBounds;
            this.nPotential_ = ip;
            this.nIncluded_ = nInclude;
            this.nVisible_ = nVisible;
        }
        return this.grids_;
    }

    public BinGrid[] getBinnedData() {
        return this.grids_;
    }

    static {
        $assertionsDisabled = !DensityPlot.class.desiredAssertionStatus();
    }

    private class DensityDataPanel
    extends JComponent {
        DensityDataPanel() {
            this.setOpaque(false);
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            DensityPlot.this.drawData((Graphics2D)g);
        }

        protected void printComponent(Graphics g) {
            if (TablePlot.isVectorContext(g)) {
                Rectangle clip = DensityPlot.this.getSurface().getClip().getBounds();
                int cx = clip.x - 2;
                int cy = clip.y - 2;
                int cw = clip.width + 4;
                int ch = clip.height + 4;
                g.clearRect(cx, cy, cw, ch);
            }
            super.printComponent(g);
        }
    }
}

