/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.Tables;

public abstract class ColStats {
    private final String name_;

    protected ColStats(ColumnInfo colInfo) {
        this.name_ = colInfo.getName();
    }

    public String getColumn() {
        return this.name_;
    }

    public String getMean() {
        return ColStats.formatDouble(this.getMeanValue());
    }

    public String getVariance() {
        return ColStats.formatDouble(this.getVarianceValue());
    }

    public String getStdDev() {
        double var = this.getVarianceValue();
        return ColStats.formatDouble(var >= 0.0 ? Math.sqrt(var) : Double.NaN);
    }

    public String getMin() {
        return ColStats.formatObject(this.getMinimumValue());
    }

    public String getMax() {
        return ColStats.formatObject(this.getMaximumValue());
    }

    public String getGood() {
        long ngood = this.getGoodCountValue();
        return ngood < 0L ? null : ColStats.formatLong(this.getGoodCountValue());
    }

    private static String formatDouble(double val) {
        return Double.isNaN(val) ? null : Float.toString((float)val);
    }

    private static String formatObject(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Double) {
            return Float.toString(((Double)val).floatValue());
        }
        return val.toString();
    }

    private static String formatLong(long val) {
        return Long.toString(val);
    }

    protected abstract void acceptDatum(Object var1);

    protected abstract double getMeanValue();

    protected abstract double getVarianceValue();

    protected abstract Object getMinimumValue();

    protected abstract Object getMaximumValue();

    protected abstract long getGoodCountValue();

    public static ColStats makeColStats(ColumnInfo info) {
        Class clazz;
        if (Number.class.isAssignableFrom(clazz = info.getContentClass())) {
            return new NumberColStats(info);
        }
        if (clazz == Boolean.class) {
            return new BooleanColStats(info);
        }
        return new BasicColStats(info);
    }

    private static class NumberColStats
    extends ColStats {
        private long ngood_;
        private double sum_;
        private double sum2_;
        private double dmin_ = Double.MAX_VALUE;
        private double dmax_ = -1.7976931348623157E308;
        private Object min_;
        private Object max_;

        public NumberColStats(ColumnInfo colInfo) {
            super(colInfo);
        }

        protected void acceptDatum(Object obj) {
            double dval;
            if (obj instanceof Number && !Double.isNaN(dval = ((Number)obj).doubleValue())) {
                ++this.ngood_;
                this.sum_ += dval;
                this.sum2_ += dval * dval;
                if (dval < this.dmin_) {
                    this.dmin_ = dval;
                    this.min_ = obj;
                }
                if (dval > this.dmax_) {
                    this.dmax_ = dval;
                    this.max_ = obj;
                }
            }
        }

        protected double getMeanValue() {
            return this.ngood_ > 0L ? this.sum_ / (double)this.ngood_ : Double.NaN;
        }

        protected double getVarianceValue() {
            return this.ngood_ > 0L ? (this.sum2_ - this.sum_ * this.sum_ / (double)this.ngood_) / (double)this.ngood_ : Double.NaN;
        }

        protected Object getMinimumValue() {
            return this.min_;
        }

        protected Object getMaximumValue() {
            return this.max_;
        }

        protected long getGoodCountValue() {
            return this.ngood_;
        }
    }

    private static class BooleanColStats
    extends BasicColStats {
        private long ntrue_;
        private long ngood_;

        public BooleanColStats(ColumnInfo colInfo) {
            super(colInfo);
        }

        protected void acceptDatum(Object obj) {
            if (obj instanceof Boolean) {
                ++this.ngood_;
                if (((Boolean)obj).booleanValue()) {
                    ++this.ntrue_;
                }
            }
        }

        protected double getMeanValue() {
            return (double)this.ntrue_ / (double)this.ngood_;
        }

        protected long getGoodCountValue() {
            return this.ngood_;
        }
    }

    private static class BasicColStats
    extends ColStats {
        private long ngood_;

        public BasicColStats(ColumnInfo colInfo) {
            super(colInfo);
        }

        protected void acceptDatum(Object obj) {
            if (!Tables.isBlank((Object)obj)) {
                ++this.ngood_;
            }
        }

        protected double getMeanValue() {
            return Double.NaN;
        }

        protected double getVarianceValue() {
            return Double.NaN;
        }

        protected Object getMinimumValue() {
            return null;
        }

        protected Object getMaximumValue() {
            return null;
        }

        protected long getGoodCountValue() {
            return this.ngood_;
        }
    }
}

