/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.lint;

import java.util.ArrayList;
import java.util.List;
import uk.ac.starlink.ttools.lint.AttributeChecker;
import uk.ac.starlink.ttools.lint.ElementHandler;
import uk.ac.starlink.ttools.lint.FieldHandler;

public class TableHandler
extends ElementHandler {
    private long nrowsSpecified_ = -1L;
    private long nrowsSeen_ = 0L;
    private List fields_ = new ArrayList();

    public void endElement() {
        if (this.nrowsSpecified_ >= 0L && this.nrowsSeen_ != this.nrowsSpecified_) {
            this.error("Row count (" + this.nrowsSeen_ + ") not equal to " + "nrows attribute (" + this.nrowsSpecified_ + ")");
        }
    }

    public void foundRow() {
        ++this.nrowsSeen_;
    }

    public void registerField(FieldHandler field) {
        this.fields_.add(field);
    }

    public List getFields() {
        return this.fields_;
    }

    public static class NrowsChecker
    implements AttributeChecker {
        public void check(String value, ElementHandler handler) {
            TableHandler thandler = (TableHandler)handler;
            try {
                long nr = Long.parseLong(value);
                if (nr < 0L) {
                    handler.error("Negative value for nrows: " + value);
                } else {
                    thandler.nrowsSpecified_ = nr;
                }
            }
            catch (IllegalArgumentException e) {
                handler.error("Bad number format for nrows: " + value);
            }
        }
    }
}

