/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.lint;

import java.io.IOException;
import java.net.URL;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.ext.LexicalHandler;
import uk.ac.starlink.ttools.lint.LintContext;

public class LintEntityResolver
implements EntityResolver,
LexicalHandler {
    private final LintContext context_;
    private String dtdSystemId_;
    private String dtdPublicId_;

    public LintEntityResolver(LintContext context) {
        this.context_ = context;
    }

    public void startDTD(String name, String publicId, String systemId) {
        this.dtdPublicId_ = publicId;
        this.dtdSystemId_ = systemId;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        InputSource saxsrc;
        if ((publicId != null && publicId.trim().length() > 0 && publicId.equals(this.dtdPublicId_) || systemId != null && systemId.trim().length() > 0 && systemId.equals(this.dtdSystemId_)) && (saxsrc = this.getVOTableDTD(this.context_.getVersion())) != null) {
            return saxsrc;
        }
        return null;
    }

    private InputSource getVOTableDTD(String version) {
        String filename;
        if ("1.0".equals(version)) {
            filename = "votable-1.0.dtd";
        } else {
            if (null == version) {
                if (this.context_.isValidating()) {
                    this.context_.info("Unspecified VOTable version - validating for V1.1");
                }
            } else if (!"1.1".equals(version) && this.context_.isValidating()) {
                this.context_.info("Unknown VOTable version " + version + " - validating for V1.1");
            }
            filename = "votable-1.1.dtd";
        }
        URL url = this.getClass().getResource(filename);
        try {
            if (url != null) {
                InputSource saxsrc = new InputSource(url.openStream());
                saxsrc.setSystemId(url.toString());
                return saxsrc;
            }
        }
        catch (IOException e) {
            this.context_.warning("Trouble opening DTD - validation may not be done");
        }
        return null;
    }

    public void endDTD() {
    }

    public void startCDATA() {
    }

    public void endCDATA() {
    }

    public void startEntity(String name) {
    }

    public void endEntity(String name) {
    }

    public void comment(char[] ch, int start, int length) {
    }
}

