/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.lint;

import uk.ac.starlink.ttools.lint.BinaryHandler;
import uk.ac.starlink.ttools.lint.DataHandler;
import uk.ac.starlink.ttools.lint.ElementHandler;
import uk.ac.starlink.ttools.lint.FieldHandler;
import uk.ac.starlink.ttools.lint.FitsHandler;
import uk.ac.starlink.ttools.lint.LintContext;
import uk.ac.starlink.ttools.lint.ParamHandler;
import uk.ac.starlink.ttools.lint.StreamHandler;
import uk.ac.starlink.ttools.lint.TableHandler;
import uk.ac.starlink.ttools.lint.TdHandler;
import uk.ac.starlink.ttools.lint.TrHandler;

public class HandlerFactory {
    private final LintContext context_;

    public HandlerFactory(LintContext context) {
        this.context_ = context;
    }

    public ElementHandler createHandler(String name) {
        String version;
        if (("GROUP".equals(name) || "FIELDref".equals(name) || "PARAMref".equals(name)) && "1.0".equals(version = this.context_.getVersion())) {
            this.context_.error("Element " + name + " not known at " + "VOTable " + version);
        }
        if (name == null) {
            throw new NullPointerException();
        }
        ElementHandler handler = "TABLE".equals(name) ? new TableHandler() : ("PARAM".equals(name) ? new ParamHandler() : ("FIELD".equals(name) ? new FieldHandler() : ("DATA".equals(name) ? new DataHandler() : ("TR".equals(name) ? new TrHandler() : ("TD".equals(name) ? new TdHandler() : ("STREAM".equals(name) ? new StreamHandler() : ("BINARY".equals(name) ? new BinaryHandler() : ("FITS".equals(name) ? new FitsHandler() : new ElementHandler()))))))));
        handler.configure(name, this.context_);
        return handler;
    }

    private void checkVersion(String version, String elName) {
        if (!version.equals(this.context_.getVersion())) {
            this.context_.error("Element " + elName + " not known at VOTable " + version);
        }
    }
}

