/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.jel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.jel.JELRowReader;
import uk.ac.starlink.ttools.jel.StarTableJELRowReader;

public class ColumnIdentifier {
    private final StarTable table_;
    private final int ncol_;
    private final String[] colNames_;
    private final String[] colUcds_;
    private final String[] colUtypes_;
    private boolean caseSensitive_;

    public ColumnIdentifier(StarTable table) {
        this.table_ = table;
        this.ncol_ = this.table_.getColumnCount();
        this.colNames_ = new String[this.ncol_];
        this.colUcds_ = new String[this.ncol_];
        this.colUtypes_ = new String[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            String utype;
            String ucd;
            ColumnInfo info = this.table_.getColumnInfo(icol);
            String name = info.getName();
            if (name != null) {
                this.colNames_[icol] = name.trim();
            }
            if ((ucd = info.getUCD()) != null) {
                this.colUcds_[icol] = ucd.trim();
            }
            if ((utype = Tables.getUtype((ValueInfo)info)) == null) continue;
            this.colUtypes_[icol] = utype;
        }
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive_ = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive_;
    }

    public int getColumnIndex(String colid) throws IOException {
        int ix = this.getScalarColumnIndex(colid);
        if (ix < 0) {
            throw new IOException("No such column " + colid);
        }
        return ix;
    }

    public int[] getColumnIndices(String colidList) throws IOException {
        String[] colIds = colidList.trim().split("\\s+");
        ArrayList<Integer> icolList = new ArrayList<Integer>();
        for (int i = 0; i < colIds.length; ++i) {
            int[] jcols;
            String colId = colIds[i];
            int icol = this.getScalarColumnIndex(colId);
            if (icol >= 0) {
                icolList.add(new Integer(icol));
                continue;
            }
            try {
                jcols = this.findMatchingColumns(colId);
            }
            catch (IllegalArgumentException e) {
                String ucdSpec = JELRowReader.stripPrefix(colId, "ucd$");
                String utypeSpec = JELRowReader.stripPrefix(colId, "utype$");
                String msg = ucdSpec != null ? "No column with UCD matching " + ucdSpec : (utypeSpec != null ? "No column with Utype matching " + utypeSpec : "Not a column ID or wildcard: " + colId);
                throw new IOException(msg);
            }
            for (int j = 0; j < jcols.length; ++j) {
                icolList.add(new Integer(jcols[j]));
            }
        }
        int ncol = icolList.size();
        int[] icols = new int[ncol];
        for (int i = 0; i < ncol; ++i) {
            icols[i] = (Integer)icolList.get(i);
        }
        return icols;
    }

    public boolean[] getColumnFlags(String colIdList) throws IOException {
        boolean[] colFlags = new boolean[this.ncol_];
        int[] icols = this.getColumnIndices(colIdList);
        for (int i = 0; i < icols.length; ++i) {
            colFlags[icols[i]] = true;
        }
        return colFlags;
    }

    private int getScalarColumnIndex(String colid) throws IOException {
        if ((colid = colid.trim()).length() == 0) {
            throw new IOException("Blank column ID not allowed");
        }
        if (colid.charAt(0) == '-') {
            throw new IOException("Found " + colid + " while looking for column ID");
        }
        if (colid.matches("\\Q$\\E?[0-9]+")) {
            int ix1;
            if (colid.charAt(0) == '$') {
                colid = colid.substring(1);
            }
            if ((ix1 = Integer.parseInt(colid)) < 1 || ix1 > this.ncol_) {
                throw new IOException("Column index " + ix1 + " out of range " + "1.." + this.ncol_);
            }
            return ix1 - 1;
        }
        if (JELRowReader.stripPrefix(colid, "ucd$") != null) {
            Pattern ucdRegex = StarTableJELRowReader.getUcdRegex(JELRowReader.stripPrefix(colid, "ucd$"));
            for (int icol = 0; icol < this.ncol_; ++icol) {
                String ucd = this.colUcds_[icol];
                if (ucd == null || !ucdRegex.matcher(ucd).matches()) continue;
                return icol;
            }
            return -1;
        }
        if (JELRowReader.stripPrefix(colid, "utype$") != null) {
            Pattern utypeRegex = StarTableJELRowReader.getUtypeRegex(JELRowReader.stripPrefix(colid, "utype$"));
            for (int icol = 0; icol < this.ncol_; ++icol) {
                String utype = this.colUtypes_[icol];
                if (utype == null || !utypeRegex.matcher(utype).matches()) continue;
                return icol;
            }
            return -1;
        }
        for (int icol = 0; icol < this.ncol_; ++icol) {
            String name = this.colNames_[icol];
            if (!(this.isCaseSensitive() ? colid.equals(name) : colid.equalsIgnoreCase(name))) continue;
            return icol;
        }
        return -1;
    }

    private int[] findMatchingColumns(String glob) {
        Pattern regex = ColumnIdentifier.globToRegex(glob, this.isCaseSensitive());
        if (regex == null) {
            throw new IllegalArgumentException("Not a wildcard expression: " + glob);
        }
        int ncol = this.table_.getColumnCount();
        ArrayList<Integer> icolList = new ArrayList<Integer>();
        for (int icol = 0; icol < ncol; ++icol) {
            String colName = this.table_.getColumnInfo(icol).getName();
            if (colName == null || !regex.matcher(colName.trim()).matches()) continue;
            icolList.add(new Integer(icol));
        }
        int nfound = icolList.size();
        int[] icols = new int[nfound];
        for (int i = 0; i < nfound; ++i) {
            icols[i] = (Integer)icolList.get(i);
        }
        return icols;
    }

    public static Pattern globToRegex(String glob, boolean caseSensitive) {
        if (glob.indexOf(42) < 0) {
            return null;
        }
        if (glob.indexOf("**") >= 0) {
            throw new IllegalArgumentException("Bad pattern (adjacent wildcards): " + glob);
        }
        StringBuffer sbuf = new StringBuffer();
        boolean quoted = false;
        for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            if (c == '*') {
                if (quoted) {
                    sbuf.append("\\E");
                    quoted = false;
                }
                sbuf.append(".*");
                continue;
            }
            if (!quoted) {
                sbuf.append("\\Q");
                quoted = true;
            }
            sbuf.append(c);
        }
        String regex = sbuf.toString();
        int flags = caseSensitive ? 0 : 2;
        return Pattern.compile(regex, flags);
    }
}

