/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Formats {
    private static final ThreadLocal kitHolder_ = new ThreadLocal(){

        protected Object initialValue() {
            return new FormatKit();
        }
    };

    private Formats() {
    }

    public static String formatDecimal(double value, int dp) {
        return Formats.getDpFormat(dp, false).format(value);
    }

    public static String formatDecimalLocal(double value, int dp) {
        return Formats.getDpFormat(dp, true).format(value);
    }

    public static String formatDecimal(double value, String format) {
        return Formats.getFormat(format, false).format(value);
    }

    public static String formatDecimalLocal(double value, String format) {
        return Formats.getFormat(format, true).format(value);
    }

    private static DecimalFormat getFormat(String format, boolean local) {
        Map fmap;
        Map map = fmap = local ? Formats.getKit().localFormatMap_ : Formats.getKit().englishFormatMap_;
        if (!fmap.containsKey(format)) {
            DecimalFormat dfmt;
            Locale locale = local ? Locale.getDefault() : Locale.ENGLISH;
            NumberFormat nfmt = NumberFormat.getInstance(locale);
            if (nfmt instanceof DecimalFormat) {
                dfmt = (DecimalFormat)nfmt;
                dfmt.applyPattern(format);
            } else {
                dfmt = new DecimalFormat(format);
            }
            fmap.put(format, dfmt);
        }
        return (DecimalFormat)fmap.get(format);
    }

    private static DecimalFormat getDpFormat(int dp, boolean local) {
        DecimalFormat[] dpFormats = Formats.getKit().dpFormats_;
        if (dp >= dpFormats.length) {
            Formats.getKit().dpFormats_ = dpFormats = new DecimalFormat[dp + 1];
            for (int i = 0; i < dp + 1; ++i) {
                String format = ".";
                for (int j = 0; j < i; ++j) {
                    format = format + "0";
                }
                dpFormats[i] = Formats.getFormat(format, local);
            }
        }
        return dpFormats[dp];
    }

    private static FormatKit getKit() {
        return (FormatKit)kitHolder_.get();
    }

    static void reset() {
        kitHolder_.set(new FormatKit());
    }

    private static class FormatKit {
        final Map localFormatMap_ = new HashMap();
        final Map englishFormatMap_ = new HashMap();
        DecimalFormat[] dpFormats_ = new DecimalFormat[0];

        private FormatKit() {
        }
    }
}

