/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

public class Conversions {
    private Conversions() {
    }

    public static String toString(double value) {
        return value == (double)((long)value) ? Long.toString((long)value) : Double.toString(value);
    }

    public static byte parseByte(String str) {
        return Byte.parseByte(str);
    }

    public static short parseShort(String str) {
        return Short.parseShort(str);
    }

    public static int parseInt(String str) {
        return Integer.parseInt(str);
    }

    public static long parseLong(String str) {
        return Long.parseLong(str);
    }

    public static float parseFloat(String str) {
        return Float.parseFloat(str);
    }

    public static double parseDouble(String str) {
        return Double.parseDouble(str);
    }

    public static byte toByte(double value) {
        if (value < -128.0 || value > 127.0 || Double.isNaN(value)) {
            throw new NumberFormatException();
        }
        return (byte)value;
    }

    public static short toShort(double value) {
        if (value < -32768.0 || value > 32767.0 || Double.isNaN(value)) {
            throw new NumberFormatException();
        }
        return (short)value;
    }

    public static int toInteger(double value) {
        if (value < -2.147483648E9 || value > 2.147483647E9 || Double.isNaN(value)) {
            throw new NumberFormatException();
        }
        return (int)value;
    }

    public static long toLong(double value) {
        if (value < -9.223372036854776E18 || value > 9.223372036854776E18 || Double.isNaN(value)) {
            throw new NumberFormatException();
        }
        return (long)value;
    }

    public static float toFloat(double value) {
        if (value < -3.4028234663852886E38 || value > 3.4028234663852886E38) {
            return Float.NaN;
        }
        return (float)value;
    }

    public static double toDouble(double value) {
        return value;
    }

    public static String toHex(long value) {
        return Long.toHexString(value);
    }

    public static int fromHex(String hexVal) {
        return Integer.parseInt(hexVal, 16);
    }
}

