/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

public class Arithmetic {
    private Arithmetic() {
    }

    public static int roundUp(double x) {
        return (int)Math.ceil(x);
    }

    public static int roundDown(double x) {
        return (int)Math.floor(x);
    }

    public static int round(double x) {
        return (int)Math.rint(x);
    }

    public static float roundDecimal(double x, int dp) {
        double factor = Math.pow(10.0, dp);
        return (float)(Math.rint(x * factor) / factor);
    }

    public static int abs(int x) {
        if (x == Integer.MIN_VALUE) {
            throw new NullPointerException();
        }
        return Math.abs(x);
    }

    public static double abs(double x) {
        return Math.abs(x);
    }

    public static int max(int a, int b) {
        return Math.max(a, b);
    }

    public static double max(double a, double b) {
        return Math.max(a, b);
    }

    public static double maxReal(double a, double b) {
        if (Double.isNaN(a)) {
            return b;
        }
        if (Double.isNaN(b)) {
            return a;
        }
        return Math.max(a, b);
    }

    public static int min(int a, int b) {
        return Math.min(a, b);
    }

    public static double min(double a, double b) {
        return Math.min(a, b);
    }

    public static double minReal(double a, double b) {
        if (Double.isNaN(a)) {
            return b;
        }
        if (Double.isNaN(b)) {
            return a;
        }
        return Math.min(a, b);
    }
}

