/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import uk.ac.starlink.table.Tables;

public abstract class UnivariateStats {
    public abstract void acceptDatum(Object var1);

    public abstract long getCount();

    public abstract double getSum();

    public abstract double getSum2();

    public abstract double getSum3();

    public abstract double getSum4();

    public abstract Number getMinimum();

    public abstract Number getMaximum();

    public abstract long getMinPos();

    public abstract long getMaxPos();

    public static UnivariateStats createStats(Class clazz) {
        if (Number.class.isAssignableFrom(clazz)) {
            return new NumberStats();
        }
        if (clazz == Boolean.class) {
            return new BooleanStats();
        }
        return new ObjectStats();
    }

    private static class NumberStats
    extends UnivariateStats {
        private long iDatum_;
        private long nGood_;
        private double sum1_;
        private double sum2_;
        private double sum3_;
        private double sum4_;
        private double dmin_ = Double.NaN;
        private double dmax_ = Double.NaN;
        private Number min_;
        private Number max_;
        private long minPos_ = -1L;
        private long maxPos_ = -1L;

        private NumberStats() {
        }

        public void acceptDatum(Object obj) {
            Number val;
            double dval;
            if (obj instanceof Number && !Double.isNaN(dval = (val = (Number)obj).doubleValue())) {
                ++this.nGood_;
                double s1 = dval;
                double s2 = dval * s1;
                double s3 = dval * s2;
                double s4 = dval * s3;
                this.sum1_ += s1;
                this.sum2_ += s2;
                this.sum3_ += s3;
                this.sum4_ += s4;
                if (!(dval >= this.dmin_)) {
                    this.dmin_ = dval;
                    this.min_ = val;
                    this.minPos_ = this.iDatum_;
                }
                if (!(dval <= this.dmax_)) {
                    this.dmax_ = dval;
                    this.max_ = val;
                    this.maxPos_ = this.iDatum_;
                }
            }
            ++this.iDatum_;
        }

        public long getCount() {
            return this.nGood_;
        }

        public double getSum() {
            return this.sum1_;
        }

        public double getSum2() {
            return this.sum2_;
        }

        public double getSum3() {
            return this.sum3_;
        }

        public double getSum4() {
            return this.sum4_;
        }

        public Number getMinimum() {
            return this.min_;
        }

        public Number getMaximum() {
            return this.max_;
        }

        public long getMinPos() {
            return this.minPos_;
        }

        public long getMaxPos() {
            return this.maxPos_;
        }
    }

    private static class BooleanStats
    extends UnivariateStats {
        private long nGood_;
        private long nTrue_;

        private BooleanStats() {
        }

        public void acceptDatum(Object obj) {
            if (obj instanceof Boolean) {
                ++this.nGood_;
                if (((Boolean)obj).booleanValue()) {
                    ++this.nTrue_;
                }
            }
        }

        public long getCount() {
            return this.nGood_;
        }

        public double getSum() {
            return this.nTrue_;
        }

        public double getSum2() {
            return Double.NaN;
        }

        public double getSum3() {
            return Double.NaN;
        }

        public double getSum4() {
            return Double.NaN;
        }

        public Number getMinimum() {
            return null;
        }

        public Number getMaximum() {
            return null;
        }

        public long getMinPos() {
            return -1L;
        }

        public long getMaxPos() {
            return -1L;
        }
    }

    private static class ObjectStats
    extends UnivariateStats {
        private long nGood_;

        private ObjectStats() {
        }

        public void acceptDatum(Object obj) {
            if (!Tables.isBlank((Object)obj)) {
                ++this.nGood_;
            }
        }

        public long getCount() {
            return this.nGood_;
        }

        public double getSum() {
            return Double.NaN;
        }

        public double getSum2() {
            return Double.NaN;
        }

        public double getSum3() {
            return Double.NaN;
        }

        public double getSum4() {
            return Double.NaN;
        }

        public Number getMinimum() {
            return null;
        }

        public Number getMaximum() {
            return null;
        }

        public long getMinPos() {
            return -1L;
        }

        public long getMaxPos() {
            return -1L;
        }
    }
}

