/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.Formatter;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.MetadataFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.filter.QuantCalc;
import uk.ac.starlink.ttools.filter.UnivariateStats;
import uk.ac.starlink.ttools.filter.ValueInfoMapGroupTable;
import uk.ac.starlink.util.MapGroup;

public class StatsFilter
extends BasicFilter {
    private static final int MAX_CARDINALITY = 100;
    private static final ValueInfo NGOOD_INFO;
    private static final ValueInfo NBAD_INFO;
    private static final ValueInfo MEAN_INFO;
    private static final ValueInfo POPSD_INFO;
    private static final ValueInfo POPVAR_INFO;
    private static final ValueInfo SAMPSD_INFO;
    private static final ValueInfo SAMPVAR_INFO;
    private static final ValueInfo SKEW_INFO;
    private static final ValueInfo KURT_INFO;
    private static final ValueInfo MIN_INFO;
    private static final ValueInfo MAX_INFO;
    private static final ValueInfo SUM_INFO;
    private static final ValueInfo MINPOS_INFO;
    private static final ValueInfo MAXPOS_INFO;
    private static final ValueInfo CARDINALITY_INFO;
    private static final ValueInfo MEDIAN_INFO;
    private static final ValueInfo Q1_INFO;
    private static final ValueInfo Q2_INFO;
    private static final ValueInfo Q3_INFO;
    private static final ValueInfo[] KNOWN_INFOS;
    private static final ValueInfo[] QEX_INFOS;
    private static final ValueInfo[] ALL_KNOWN_INFOS;
    private static final ValueInfo[] DEFAULT_INFOS;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StatsFilter() {
        super("stats", "[<item> ...]");
    }

    protected String[] getDescriptionLines() {
        ArrayList<ValueInfo> extras = new ArrayList<ValueInfo>(Arrays.asList(KNOWN_INFOS));
        extras.removeAll(Arrays.asList(DEFAULT_INFOS));
        ValueInfo[] extraKnownInfos = extras.toArray(new ValueInfo[0]);
        return new String[]{"<p>Calculates statistics on the data in the table.", "This filter turns the table sideways, so that each row", "of the output corresponds to a column of the input.", "The columns of the output table contain statistical items", "such as mean, standard deviation etc corresponding to each", "column of the input table.", "</p><p>By default the output table contains columns for the", "following items:", DocUtils.listInfos(DEFAULT_INFOS), "</p>", "<p>However, the output may be customised by supplying one or more", "<code>&lt;item&gt;</code> headings.  These may be selected", "from the above as well as the following:", DocUtils.listInfos(extraKnownInfos), "Additionally, the form \"Q.<em>nn</em>\" may be used to", "represent the quantile corresponding to the proportion", "0.<em>nn</em>, e.g.:", DocUtils.listInfos(QEX_INFOS), "</p>", "<p>Any parameters of the input table are propagated", "to the output one.", "</p>", "<p>Note that quantile calculations (including median and", "quartiles) can be expensive on memory.  If you want to calculate", "quantiles for large tables, it may be wise to reduce the", "number of columns to only those you need the quantiles for", "earlier in the pipeline.", "No interpolation is performed when calculating quantiles.", "</p>"};
    }

    public ProcessingStep createStep(Iterator argIt) throws ArgException {
        ValueInfo[] colInfos;
        if (argIt.hasNext()) {
            HashMap<String, ValueInfo> infoMap = new HashMap<String, ValueInfo>();
            for (int i = 0; i < ALL_KNOWN_INFOS.length; ++i) {
                ValueInfo info = ALL_KNOWN_INFOS[i];
                infoMap.put(info.getName().toLowerCase(), info);
            }
            ArrayList<Object> infoList = new ArrayList<Object>();
            while (argIt.hasNext()) {
                StringBuffer msg;
                block9: {
                    String name = (String)argIt.next();
                    argIt.remove();
                    String lname = name.toLowerCase();
                    if (infoMap.containsKey(lname)) {
                        infoList.add((ValueInfo)infoMap.get(lname));
                        continue;
                    }
                    if (name.matches("^[qQ]\\.[0-9]+$")) {
                        double quant = Double.parseDouble(name.substring(1));
                        if (!($assertionsDisabled || quant >= 0.0 && quant <= 1.0)) {
                            throw new AssertionError();
                        }
                        infoList.add((Object)new QuantileInfo(quant));
                        continue;
                    }
                    msg = new StringBuffer().append("Unknown quantity ").append(name);
                    try {
                        String opts = new Formatter().formatXML(DocUtils.listInfos(ALL_KNOWN_INFOS), 6);
                        msg.append(" must be one of: ").append(opts).append("or Q.nn");
                    }
                    catch (SAXException e) {
                        if ($assertionsDisabled) break block9;
                        throw new AssertionError();
                    }
                }
                throw new ArgException(msg.toString());
            }
            colInfos = infoList.toArray(new ValueInfo[0]);
        } else {
            colInfos = DEFAULT_INFOS;
        }
        return new ProcessingStep(){

            public StarTable wrap(StarTable base) throws IOException {
                MapGroup group = StatsFilter.statsMapGroup(base, colInfos);
                group.setKnownKeys(Arrays.asList(colInfos));
                ValueInfoMapGroupTable table = new ValueInfoMapGroupTable(group);
                table.setParameters(base.getParameters());
                return table;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MapGroup statsMapGroup(StarTable table, ValueInfo[] infos) throws IOException {
        boolean doCard = Arrays.asList(infos).contains(CARDINALITY_INFO);
        ArrayList<ValueInfo> quantInfoList = new ArrayList<ValueInfo>();
        for (int i = 0; i < infos.length; ++i) {
            if (!(infos[i] instanceof QuantileInfo)) continue;
            quantInfoList.add(infos[i]);
        }
        boolean doQuant = !quantInfoList.isEmpty();
        QuantileInfo[] quantInfos = doQuant ? quantInfoList.toArray(new QuantileInfo[0]) : null;
        long nrow = table.getRowCount();
        int ncol = table.getColumnCount();
        UnivariateStats[] colStats = new UnivariateStats[ncol];
        CardinalityChecker[] cardCheckers = doCard ? new CardinalityChecker[ncol] : null;
        QuantCalc[] quantCalcs = new QuantCalc[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            Class clazz = table.getColumnInfo(icol).getContentClass();
            colStats[icol] = UnivariateStats.createStats(clazz);
            if (doCard) {
                cardCheckers[icol] = new CardinalityChecker(100);
            }
            if (!doQuant || !(class$java$lang$Number == null ? StatsFilter.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(clazz)) continue;
            quantCalcs[icol] = QuantCalc.createInstance(clazz, nrow);
        }
        RowSequence rseq = table.getRowSequence();
        long irow = 0L;
        try {
            int icol;
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                for (icol = 0; icol < ncol; ++icol) {
                    Object datum = row[icol];
                    colStats[icol].acceptDatum(datum);
                    if (doCard) {
                        cardCheckers[icol].acceptDatum(datum);
                    }
                    if (quantCalcs[icol] == null) continue;
                    quantCalcs[icol].acceptDatum(datum);
                }
                ++irow;
            }
            MapGroup group = MetadataFilter.metadataMapGroup(table);
            for (icol = 0; icol < ncol; ++icol) {
                int ncard;
                double dcount;
                UnivariateStats stats = colStats[icol];
                long count = stats.getCount();
                double sum0 = dcount = (double)count;
                double sum1 = stats.getSum();
                double sum2 = stats.getSum2();
                double sum3 = stats.getSum3();
                double sum4 = stats.getSum4();
                double mean = sum1 / dcount;
                double nvar = sum2 - sum1 * sum1 / dcount;
                double popvar = nvar / dcount;
                double sampvar = nvar / (dcount - 1.0);
                double skew = Math.sqrt(dcount) / Math.pow(nvar, 1.5) * (1.0 * sum3 - 3.0 * mean * sum2 + 3.0 * mean * mean * sum1 - 1.0 * mean * mean * mean * sum0);
                double kurtosis = dcount / (nvar * nvar) * (1.0 * sum4 - 4.0 * mean * sum3 + 6.0 * mean * mean * sum2 - 4.0 * mean * mean * mean * sum1 + 1.0 * mean * mean * mean * mean * sum0) - 3.0;
                Number min = stats.getMinimum();
                Number max = stats.getMaximum();
                Map map = (Map)group.getMaps().get(icol);
                map.put(NGOOD_INFO, new Long(count));
                map.put(NBAD_INFO, new Long(irow - count));
                map.put(SUM_INFO, new Double(sum1));
                if (StatsFilter.isFinite(mean)) {
                    map.put(MEAN_INFO, new Float((float)mean));
                }
                if (StatsFilter.isFinite(popvar)) {
                    map.put(POPSD_INFO, new Float((float)Math.sqrt(popvar)));
                    map.put(POPVAR_INFO, new Float((float)popvar));
                }
                if (StatsFilter.isFinite(sampvar)) {
                    map.put(SAMPSD_INFO, new Float((float)Math.sqrt(sampvar)));
                    map.put(SAMPVAR_INFO, new Float((float)sampvar));
                }
                if (StatsFilter.isFinite(skew)) {
                    map.put(SKEW_INFO, new Float((float)skew));
                }
                if (StatsFilter.isFinite(kurtosis)) {
                    map.put(KURT_INFO, new Float((float)kurtosis));
                }
                if (min instanceof Number && StatsFilter.isFinite(min.doubleValue())) {
                    map.put(MIN_INFO, min);
                    map.put(MINPOS_INFO, new Long(stats.getMinPos() + 1L));
                }
                if (max instanceof Number && StatsFilter.isFinite(max.doubleValue())) {
                    map.put(MAX_INFO, max);
                    map.put(MAXPOS_INFO, new Long(stats.getMaxPos() + 1L));
                }
                if (doCard && (ncard = cardCheckers[icol].getCardinality()) > 0) {
                    map.put(CARDINALITY_INFO, new Integer(ncard));
                }
                if (quantCalcs[icol] == null) continue;
                quantCalcs[icol].ready();
                for (int iq = 0; iq < quantInfos.length; ++iq) {
                    QuantileInfo quantInfo = quantInfos[iq];
                    Number quantile = quantCalcs[icol].getQuantile(quantInfo.getQuant());
                    map.put(quantInfo, quantile);
                }
            }
            MapGroup mapGroup = group;
            return mapGroup;
        }
        finally {
            rseq.close();
        }
    }

    private static final boolean isFinite(double val) {
        return val > -1.7976931348623157E308 && val < Double.MAX_VALUE;
    }

    static {
        $assertionsDisabled = !StatsFilter.class.desiredAssertionStatus();
        NGOOD_INFO = new DefaultValueInfo("NGood", Number.class, "Number of non-blank cells");
        KNOWN_INFOS = new ValueInfo[]{NGOOD_INFO, NBAD_INFO = new DefaultValueInfo("NBad", Number.class, "Number of blank cells"), MEAN_INFO = new DefaultValueInfo("Mean", Float.class, "Average"), POPSD_INFO = new DefaultValueInfo("StDev", Float.class, "Population Standard deviation"), POPVAR_INFO = new DefaultValueInfo("Variance", Float.class, "Population Variance"), SAMPSD_INFO = new DefaultValueInfo("SampStDev", Float.class, "Sample Standard Deviation"), SAMPVAR_INFO = new DefaultValueInfo("SampVariance", Float.class, "Sample Variance"), SKEW_INFO = new DefaultValueInfo("Skew", Float.class, "Gamma 1 skewness measure"), KURT_INFO = new DefaultValueInfo("Kurtosis", Float.class, "Gamma 2 peakedness measure"), MIN_INFO = new DefaultValueInfo("Minimum", Number.class, "Numeric minimum"), MAX_INFO = new DefaultValueInfo("Maximum", Number.class, "Numeric maximum"), SUM_INFO = new DefaultValueInfo("Sum", Double.class, "Sum of values"), MINPOS_INFO = new DefaultValueInfo("MinPos", Long.class, "Row index of numeric minimum"), MAXPOS_INFO = new DefaultValueInfo("MaxPos", Long.class, "Row index of numeric maximum"), CARDINALITY_INFO = new DefaultValueInfo("Cardinality", Integer.class, "Number of distinct values in column; values >100 ignored"), MEDIAN_INFO = new QuantileInfo(0.5, "Median", "Middle value in sequence"), Q1_INFO = new QuantileInfo(0.25, "Quartile1", "First quartile"), Q2_INFO = new QuantileInfo(0.5, "Quartile2", "Second quartile"), Q3_INFO = new QuantileInfo(0.75, "Quartile3", "Third quartile")};
        QEX_INFOS = new ValueInfo[]{new DefaultValueInfo("Q.25", Number.class, "First quartile"), new DefaultValueInfo("Q.625", Number.class, "Fifth octile")};
        ArrayList<ValueInfo> known = new ArrayList<ValueInfo>();
        known.addAll(Arrays.asList(MetadataFilter.KNOWN_INFOS));
        known.addAll(Arrays.asList(KNOWN_INFOS));
        ALL_KNOWN_INFOS = known.toArray(new ValueInfo[0]);
        DEFAULT_INFOS = new ValueInfo[]{MetadataFilter.NAME_INFO, MEAN_INFO, POPSD_INFO, MIN_INFO, MAX_INFO, NGOOD_INFO};
    }

    private static class CardinalityChecker {
        final int maxCard_;
        Set items_ = new HashSet();

        CardinalityChecker(int maxCard) {
            this.maxCard_ = maxCard;
        }

        void acceptDatum(Object obj) {
            if (!Tables.isBlank((Object)obj) && this.items_ != null) {
                if (this.items_.size() < this.maxCard_) {
                    this.items_.add(obj);
                } else {
                    this.items_ = null;
                }
            }
        }

        int getCardinality() {
            return this.items_ == null ? -1 : this.items_.size();
        }
    }

    private static class QuantileInfo
    extends DefaultValueInfo {
        private final double quant_;

        QuantileInfo(double quant) {
            super("Q_" + quant, class$java$lang$Number == null ? (class$java$lang$Number = StatsFilter.class$("java.lang.Number")) : class$java$lang$Number);
            if (quant < 0.0 || quant > 1.0) {
                throw new IllegalArgumentException(quant + " not in range 0-1");
            }
            this.quant_ = quant;
            String qv = Float.toString((float)quant);
            Matcher matcher = Pattern.compile("^0?.([0-9]+)$").matcher(qv);
            if (matcher.matches()) {
                qv = matcher.group(1);
                while (qv.length() < 2) {
                    qv = qv + '0';
                }
            }
            this.setName("Q_" + qv);
            if (qv.length() == 2) {
                this.setDescription("Percentile " + qv);
            } else {
                this.setDescription("Quantile corresponding to " + quant);
            }
        }

        QuantileInfo(double quant, String name, String description) {
            this(quant);
            this.setName(name);
            this.setDescription(description);
        }

        public double getQuant() {
            return this.quant_;
        }
    }
}

