/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Library;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import uk.ac.starlink.table.RowListStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.Tokenizer;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.SequentialJELRowReader;
import uk.ac.starlink.ttools.jel.StarTableJELRowReader;

public class SortHeadFilter
extends BasicFilter {
    static /* synthetic */ Class class$uk$ac$starlink$ttools$filter$SortHeadFilter;

    public SortHeadFilter() {
        super("sorthead", "[-tail] [-down] [-nullsfirst] <nrows> <key-list>");
    }

    protected String[] getDescriptionLines() {
        return new String[]{"<p>Performs a sort on the table according to the value of", "one or more algebraic expressions, retaining only", "<code>&lt;nrows&gt;</code> rows at the head", "of the resulting sorted table.", "The sort key expressions appear,", "as separate (space-separated) words,", "in <code>&lt;key-list&gt;</code>; sorting is done on the", "first expression first, but if that results in a tie then", "the second one is used, and so on.", "Each expression must evaluate to a type that", "it makes sense to sort, for instance numeric.", "</p>", "<p>If the <code>-tail</code> flag is used, then the", "last <code>&lt;nrows&gt;</code> rows rather than the first", "ones are retained.", "</p>", "<p>If the <code>-down</code> flag is used the sort order is", "descending rather than ascending.", "</p>", "<p>Blank entries are by default considered to come at the end", "of the collation sequence, but if the <code>-nullsfirst</code>", "flag is given then they are considered to come at the start", "instead.", "</p>", "<p>This filter is functionally equivalent to using", "<code>sort</code> followed by <code>head</code>,", "but it can be done in one pass and is usually cheaper", "on memory and faster, as long as <code>&lt;nrows&gt;</code>", "is significantly lower than the size of the table.", "</p>", SortHeadFilter.explainSyntax(new String[]{"key-list"})};
    }

    public ProcessingStep createStep(Iterator argIt) throws ArgException {
        String[] keys;
        boolean up = true;
        boolean nullsLast = true;
        boolean keepHead = true;
        int nrows = -1;
        String exprs = null;
        while (argIt.hasNext() || nrows < 0 || exprs == null) {
            String arg = (String)argIt.next();
            if (arg.equals("-tail")) {
                argIt.remove();
                keepHead = false;
                continue;
            }
            if (arg.equals("-down")) {
                argIt.remove();
                up = false;
                continue;
            }
            if (arg.equals("-nullsfirst")) {
                argIt.remove();
                nullsLast = false;
                continue;
            }
            if (nrows < 0) {
                argIt.remove();
                try {
                    nrows = Integer.parseInt(arg);
                }
                catch (NumberFormatException e) {
                    throw new ArgException("<nrows> not numeric: " + arg);
                }
                if (nrows > 0) continue;
                throw new ArgException("Non-positive <nrows>: " + nrows);
            }
            if (exprs != null) continue;
            argIt.remove();
            exprs = arg;
        }
        if (exprs == null) {
            throw new ArgException("No sort keys given");
        }
        try {
            keys = Tokenizer.tokenizeWords(exprs);
            if (keys.length == 0) {
                throw new ArgException("No sort keys given");
            }
        }
        catch (TaskException e) {
            throw new ArgException("Bad <key-list>: " + exprs, e);
        }
        return new SortHeadStep(keys, up, nullsLast, nrows, keepHead);
    }

    private static class SortHeadStep
    implements ProcessingStep {
        final String[] keys_;
        final boolean up_;
        final boolean nullsLast_;
        final int nrows_;
        final boolean keepHead_;
        static final /* synthetic */ boolean $assertionsDisabled;

        SortHeadStep(String[] keys, boolean up, boolean nullsLast, int nrows, boolean keepHead) {
            this.keys_ = keys;
            this.up_ = up;
            this.nullsLast_ = nullsLast;
            this.nrows_ = nrows;
            this.keepHead_ = keepHead;
        }

        public StarTable wrap(StarTable baseTable) throws IOException {
            SequentialJELRowReader rseq = new SequentialJELRowReader(baseTable);
            Library lib = JELUtils.getLibrary(rseq);
            int nkey = this.keys_.length;
            CompiledExpression[] compExs = new CompiledExpression[nkey];
            try {
                for (int i = 0; i < nkey; ++i) {
                    compExs[i] = JELUtils.compile(lib, baseTable, this.keys_[i]);
                }
            }
            catch (CompilationException e) {
                throw (IOException)new IOException("Bad sort key(s)").initCause(e);
            }
            TreeMap<SortKey, Object[]> headMap = new TreeMap<SortKey, Object[]>();
            while (rseq.next()) {
                SortKey sortKey = new SortKey(rseq, compExs);
                if (headMap.size() < this.nrows_) {
                    headMap.put(sortKey, rseq.getRow());
                    continue;
                }
                SortKey marginal = (SortKey)(this.keepHead_ ? headMap.lastKey() : headMap.firstKey());
                if (marginal.compareTo(sortKey) * (this.keepHead_ ? 1 : -1) <= 0) continue;
                if (!$assertionsDisabled && headMap.size() != this.nrows_) {
                    throw new AssertionError();
                }
                headMap.remove(marginal);
                headMap.put(sortKey, rseq.getRow());
                if (!$assertionsDisabled && headMap.size() != this.nrows_) {
                    throw new AssertionError();
                }
            }
            RowListStarTable outTable = new RowListStarTable(baseTable);
            Iterator it = headMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                outTable.addRow((Object[])entry.getValue());
                it.remove();
            }
            return outTable;
        }

        private int compareValues(Comparable o1, Comparable o2) {
            boolean null1 = Tables.isBlank((Object)o1);
            boolean null2 = Tables.isBlank((Object)o2);
            if (null1 && null2) {
                return 0;
            }
            if (null1) {
                return this.nullsLast_ ? 1 : -1;
            }
            if (null2) {
                return this.nullsLast_ ? -1 : 1;
            }
            return o1.compareTo(o2);
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$ttools$filter$SortHeadFilter == null ? (class$uk$ac$starlink$ttools$filter$SortHeadFilter = SortHeadFilter.class$("uk.ac.starlink.ttools.filter.SortHeadFilter")) : class$uk$ac$starlink$ttools$filter$SortHeadFilter).desiredAssertionStatus();
        }

        private class SortKey
        implements Comparable {
            final int nkey1_;
            final Object[] keyVals_;

            SortKey(StarTableJELRowReader jelly, CompiledExpression[] compExs) throws IOException {
                this.nkey1_ = compExs.length + 1;
                this.keyVals_ = new Object[this.nkey1_];
                for (int i = 0; i < this.nkey1_ - 1; ++i) {
                    try {
                        this.keyVals_[i] = jelly.evaluate(compExs[i]);
                        continue;
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw (IOException)new IOException(e.getMessage()).initCause(e);
                    }
                }
                this.keyVals_[this.nkey1_ - 1] = new Long(jelly.getCurrentRow());
            }

            public int compareTo(Object other) {
                SortKey o = (SortKey)other;
                int c = 0;
                for (int i = 0; i < this.nkey1_ && c == 0; ++i) {
                    c = SortHeadStep.this.compareValues((Comparable)this.keyVals_[i], (Comparable)o.keyVals_[i]);
                }
                return SortHeadStep.this.up_ ? c : -c;
            }
        }
    }
}

