/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Library;
import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.AssertException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.jel.DummyJELRowReader;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.RandomJELRowReader;
import uk.ac.starlink.ttools.jel.SequentialJELRowReader;

public class AssertFilter
extends BasicFilter {
    public AssertFilter() {
        super("assert", "<expr>");
    }

    protected String[] getDescriptionLines() {
        return new String[]{"<p>Check that a boolean expression is true for each row.", "If the expression <code>&lt;expr&gt;</code> does not", "evaluate true for any row of the table, execution terminates", "with an error.", "As long as no error occurs, the output table is identical", "to the input one.", "</p>", "<p>The exception generated by an assertion violation is of class", "<code>" + AssertException.class.getName() + "</code>", "although that is not usually obvious if you are running from", "the shell in the usual way.", "</p>", AssertFilter.explainSyntax(new String[]{"expr"})};
    }

    public ProcessingStep createStep(Iterator argIt) throws ArgException {
        if (!argIt.hasNext()) {
            throw new ArgException("Missing expression");
        }
        final String expr = (String)argIt.next();
        argIt.remove();
        return new ProcessingStep(){

            public StarTable wrap(StarTable base) throws IOException {
                try {
                    return new JELAssertionTable(base, expr);
                }
                catch (CompilationException e) {
                    String msg = "Bad expression \"" + expr + "\" (" + e.getMessage() + ")";
                    throw (IOException)new IOException(msg).initCause(e);
                }
            }
        };
    }

    private static class JELAssertionTable
    extends WrapperStarTable {
        private final String expr_;
        private final StarTable baseTable_;
        private final RandomJELRowReader randomReader_;
        private final CompiledExpression compEx_;

        public JELAssertionTable(StarTable baseTable, String expr) throws CompilationException {
            super(baseTable);
            this.baseTable_ = baseTable;
            this.expr_ = expr;
            this.randomReader_ = new RandomJELRowReader(baseTable);
            Library lib = JELUtils.getLibrary(new DummyJELRowReader(baseTable));
            this.compEx_ = JELUtils.compile(lib, baseTable, expr);
            JELUtils.checkExpressionType(lib, baseTable, expr, Boolean.TYPE);
        }

        public Object getCell(long irow, int icol) throws IOException {
            Object cell = super.getCell(irow, icol);
            this.assertAtRow(irow);
            return cell;
        }

        public Object[] getRow(long irow) throws IOException {
            Object[] row = super.getRow(irow);
            this.assertAtRow(irow);
            return row;
        }

        private void assertAtRow(long irow) throws IOException {
            Object result;
            try {
                result = this.randomReader_.evaluateAtRow(this.compEx_, irow);
            }
            catch (IOException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
            this.check(result, irow);
        }

        public RowSequence getRowSequence() throws IOException {
            CompiledExpression compEx;
            final SequentialJELRowReader seqReader = new SequentialJELRowReader(this.baseTable_);
            Library lib = JELUtils.getLibrary(seqReader);
            try {
                compEx = JELUtils.compile(lib, this.baseTable_, this.expr_);
            }
            catch (CompilationException e) {
                throw (IOException)new IOException("Bad expression: " + this.expr_).initCause(e);
            }
            return new WrapperRowSequence(seqReader){
                long lrow_;

                public boolean next() throws IOException {
                    boolean next = super.next();
                    if (next) {
                        Object result;
                        try {
                            result = seqReader.evaluate(compEx);
                        }
                        catch (IOException e) {
                            throw e;
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Error e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            throw (IOException)new IOException(e.getMessage()).initCause(e);
                        }
                        JELAssertionTable.this.check(result, this.lrow_++);
                    }
                    return next;
                }
            };
        }

        private void check(Object result, long irow) throws AssertException {
            if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) {
                throw new AssertException("Assertion \"" + this.expr_ + "\" " + "violated at row " + (irow + 1L));
            }
        }
    }
}

