/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import gov.fnal.eag.healpix.PixTools;
import java.util.ArrayList;
import java.util.Iterator;
import javax.vecmath.Vector3d;
import uk.ac.starlink.ttools.cone.SkyTiling;

public class HealpixTiling
implements SkyTiling {
    private final long nside_;
    private final boolean nest_;
    private final PixTools pixTools_;
    private final double resolution_;

    public HealpixTiling(int k, boolean nest) {
        if (k > 63) {
            throw new IllegalArgumentException("k " + k + " too large");
        }
        this.nside_ = 1L << k;
        this.nest_ = nest;
        this.pixTools_ = new PixTools();
        this.resolution_ = this.pixTools_.PixRes(this.nside_) / 3600.0;
    }

    public long getPositionTile(double ra, double dec) {
        Vector3d vec = this.toVector(ra, dec);
        return this.nest_ ? this.pixTools_.vect2pix_nest(this.nside_, vec) : this.pixTools_.vect2pix_ring(this.nside_, vec);
    }

    public long[] getTileRange(double ra, double dec, double radius) {
        long[] lArray;
        if (radius > this.resolution_ * 50.0) {
            return null;
        }
        ArrayList tileList = this.pixTools_.query_disc(this.nside_, this.toVector(ra, dec), Math.toRadians(radius), 0, 1);
        if (this.nest_) {
            int ntile = tileList.size();
            for (int itile = 0; itile < ntile; ++itile) {
                long ringIndex = ((Number)tileList.get(itile)).longValue();
                long nestIndex = this.pixTools_.ring2nest(this.nside_, ringIndex);
                tileList.set(itile, new Long(nestIndex));
            }
        }
        long lo = Long.MAX_VALUE;
        long hi = Long.MIN_VALUE;
        Iterator it = tileList.iterator();
        while (it.hasNext()) {
            long tile = ((Number)it.next()).longValue();
            if (!this.discIntersectsTile(ra, dec, radius, tile)) continue;
            lo = Math.min(lo, tile);
            hi = Math.max(hi, tile);
        }
        if (lo <= hi) {
            long[] lArray2 = new long[2];
            lArray2[0] = lo;
            lArray = lArray2;
            lArray2[1] = hi;
        } else {
            lArray = null;
        }
        return lArray;
    }

    private Vector3d toVector(double ra, double dec) {
        double theta = 1.5707963267948966 - Math.toRadians(dec);
        return this.pixTools_.Ang2Vec(theta, Math.toRadians(ra));
    }

    private boolean discIntersectsTile(double ra, double dec, double radius, long tile) {
        return true;
    }
}

