/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cea;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.xml.sax.SAXException;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.cea.CeaConfig;
import uk.ac.starlink.ttools.cea.CeaMetadata;
import uk.ac.starlink.ttools.cea.CeaTask;
import uk.ac.starlink.ttools.cea.CeaWriter;
import uk.ac.starlink.ttools.cea.ElementDeclaration;

public class ImplementationCeaWriter
extends CeaWriter {
    private static final String AG_SCHEMA_BASE = "http://www.astrogrid.org/schema/";
    private static final String CEAI_NS = "http://www.astrogrid.org/schema/CEAImplementation/v1";
    private static final String CEAB_NS = "http://www.astrogrid.org/schema/CommonExecutionArchitectureBase/v1";
    private static final String AGPD_NS = "http://www.astrogrid.org/schema/AGParameterDefinition/v1";
    public static final String SCHEMA_LOCATION = "http://software.astrogrid.org/schema/cea/CEAImplementation/v1.0/CEAImplementation.xsd";
    public static final String APPLICATION_ID = "ivo://uk.ac.starlink/stilts";
    private String appPath_;
    private final CeaMetadata meta_;

    public ImplementationCeaWriter(PrintStream out, CeaTask[] tasks, CeaMetadata meta, boolean redirects, String cmdline) {
        super(out, ImplementationCeaWriter.createImplementationConfig(), tasks, redirects, cmdline);
        this.meta_ = meta;
    }

    public String getSchemaLocation() {
        return SCHEMA_LOCATION;
    }

    public static String getUsage() {
        return " -path <app-path>";
    }

    public int configure(String[] args) {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (!"-path".equals(arg) || !it.hasNext() || this.appPath_ != null) continue;
            it.remove();
            this.appPath_ = (String)it.next();
            it.remove();
        }
        if (!argList.isEmpty() || this.appPath_ == null) {
            return 1;
        }
        return 0;
    }

    protected void writeContent() throws SAXException {
        this.startElement("CommandLineExecutionControllerConfig", ImplementationCeaWriter.formatAttribute((String)"xmlns", (String)CEAI_NS) + ImplementationCeaWriter.formatAttribute((String)"xmlns:ceai", (String)CEAI_NS) + ImplementationCeaWriter.formatAttribute((String)"xmlns:ceab", (String)CEAB_NS) + ImplementationCeaWriter.formatAttribute((String)"xmlns:agpd", (String)AGPD_NS) + ImplementationCeaWriter.formatAttribute((String)"xmlns:xsi", (String)"http://www.w3.org/2001/XMLSchema-instance") + ImplementationCeaWriter.formatAttribute((String)"xsi:schemaLocation", (String)"http://www.astrogrid.org/schema/CEAImplementation/v1 http://software.astrogrid.org/schema/cea/CEAImplementation/v1.0/CEAImplementation.xsd"));
        this.println(this.getIndent(this.getLevel()) + "<!-- Application name set from " + ((Object)((Object)this)).getClass().getName() + " command-line flag. -->");
        this.startElement("Application", ImplementationCeaWriter.formatAttribute((String)"name", (String)this.meta_.getIvorn()) + ImplementationCeaWriter.formatAttribute((String)"version", (String)Stilts.getVersion()));
        this.writeParameters();
        this.writeInterfaces();
        this.println(this.getIndent(this.getLevel()) + "<!-- ExecutionPath set from " + ((Object)((Object)this)).getClass().getName() + " command-line flag. -->");
        this.addElement("ExecutionPath", "", this.appPath_.toString());
        this.addElement("LongName", "", this.meta_.getLongName());
        this.addElement("Version", "", Stilts.getVersion());
        this.startElement("Description");
        this.print(this.meta_.getDescription());
        this.endElement("Description");
        this.addElement("ReferenceURL", "", this.meta_.getRefUrl());
        this.endElement("Application");
        this.endElement("CommandLineExecutionControllerConfig");
    }

    private static CeaConfig createImplementationConfig() {
        ElementDeclaration ifsDecl = ElementDeclaration.createNamespaceElement("Interfaces", CEAB_NS);
        ElementDeclaration paramsDecl = new ElementDeclaration("ceab:Parameters");
        ElementDeclaration paramDecl = ElementDeclaration.createNamespaceElement("ceai:CmdLineParameterDefn", AGPD_NS);
        paramDecl.setAttributeNames(new String[]{"fileRef", "switchType", "commandSwitch", "commandPosition"});
        return new CeaConfig(ifsDecl, paramsDecl, paramDecl);
    }
}

