/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cea;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.xml.sax.SAXException;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.ttools.Formatter;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.cea.CeaConfig;
import uk.ac.starlink.ttools.cea.CeaMetadata;
import uk.ac.starlink.ttools.cea.CeaParameter;
import uk.ac.starlink.ttools.cea.CeaTask;
import uk.ac.starlink.ttools.cea.ElementDeclaration;
import uk.ac.starlink.ttools.cea.ImplementationCeaWriter;
import uk.ac.starlink.ttools.cea.ServiceCeaWriter;
import uk.ac.starlink.ttools.task.VariableMapperTask;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.ObjectFactory;
import uk.ac.starlink.util.XmlWriter;

public abstract class CeaWriter
extends XmlWriter {
    private final CeaConfig config_;
    private final CeaTask[] tasks_;
    private final Formatter formatter_;
    private final FlagDef[] flagDefs_;
    private final String cmdline_;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected CeaWriter(PrintStream out, CeaConfig config, CeaTask[] tasks, boolean redirects, String cmdline) {
        super(out);
        FlagDef[] flagDefArray;
        this.config_ = config;
        this.tasks_ = tasks;
        this.cmdline_ = cmdline;
        this.formatter_ = new Formatter();
        this.formatter_.setManualName("the manual");
        if (redirects) {
            FlagDef[] flagDefArray2 = new FlagDef[2];
            flagDefArray2[0] = new RedirectFlagDef("stdout", "File for output from task", "stilts.out");
            flagDefArray = flagDefArray2;
            flagDefArray2[1] = new RedirectFlagDef("stderr", "File for errors from task", "stilts.err");
        } else {
            flagDefArray = new FlagDef[]{};
        }
        this.flagDefs_ = flagDefArray;
    }

    public abstract int configure(String[] var1);

    public void writeDocument() throws SAXException {
        this.writeDeclaration();
        this.println("<!-- Automatically generated by \n !      " + this.cmdline_ + "\n !   STILTS version " + Stilts.getVersion() + "\n !   " + new Date() + "\n !-->");
        int startLevel = this.getLevel();
        this.writeContent();
        if (!$assertionsDisabled && this.getLevel() != startLevel) {
            throw new AssertionError((Object)"Mismatched levels");
        }
    }

    protected abstract void writeContent() throws SAXException;

    public abstract String getSchemaLocation();

    protected void writeParameters() throws SAXException {
        int i;
        this.startElement(this.config_.getParametersElement());
        for (i = 0; i < this.flagDefs_.length; ++i) {
            this.flagDefs_[i].writeParameter();
        }
        for (i = 0; i < this.tasks_.length; ++i) {
            this.writeParameters(this.tasks_[i]);
        }
        this.endElement(this.config_.getParametersElement());
    }

    protected void writeInterfaces() throws SAXException {
        this.startElement(this.config_.getInterfacesElement());
        for (int i = 0; i < this.tasks_.length; ++i) {
            this.writeInterface(this.tasks_[i]);
        }
        this.endElement(this.config_.getInterfacesElement());
    }

    private void writeParameters(CeaTask task) throws SAXException {
        CeaParameter[] params = task.getParameters();
        ElementDeclaration paramDecl = this.config_.getParameterElement();
        boolean hasFileRef = paramDecl.hasAttribute("fileRef");
        boolean hasSwitchType = paramDecl.hasAttribute("switchType");
        boolean hasCommandSwitch = paramDecl.hasAttribute("commandSwitch");
        boolean hasCommandPosition = paramDecl.hasAttribute("commandPosition");
        StringBuffer aBuf = new StringBuffer().append(CeaWriter.formatAttribute((String)"name", (String)CeaWriter.getParamRef(task, null))).append(CeaWriter.formatAttribute((String)"type", (String)"text"));
        if (hasFileRef) {
            aBuf.append(CeaWriter.formatAttribute((String)"fileRef", (String)"false"));
        }
        if (hasCommandPosition) {
            aBuf.append(CeaWriter.formatAttribute((String)"commandPosition", (String)Integer.toString(this.flagDefs_.length + 1)));
        }
        this.startElement(paramDecl, aBuf.toString());
        this.addElement("UI_Name", "", "task");
        this.addElement("UI_Description", "", this.xmlToCdata(task.getName() + ": " + task.getPurpose()));
        this.addElement("DefaultValue", "", this.xmlToCdata(task.getName()));
        this.startElement("OptionList");
        this.addElement("OptionVal", "", this.xmlToCdata(task.getName()));
        this.endElement("OptionList");
        this.endElement(paramDecl);
        for (int iParam = 0; iParam < params.length; ++iParam) {
            String[] options;
            CeaParameter param = params[iParam];
            StringBuffer attBuf = new StringBuffer().append(CeaWriter.formatAttribute((String)"name", (String)CeaWriter.getParamRef(task, param))).append(CeaWriter.formatAttribute((String)"type", (String)param.getType()));
            if (hasFileRef) {
                attBuf.append(CeaWriter.formatAttribute((String)"fileRef", (String)(param.isRef() ? "true" : "false")));
            }
            if (hasSwitchType) {
                attBuf.append(CeaWriter.formatAttribute((String)"switchType", (String)"keyword"));
            }
            if (hasCommandSwitch) {
                attBuf.append(CeaWriter.formatAttribute((String)"commandSwitch", (String)param.getName()));
            }
            this.startElement(paramDecl, attBuf.toString());
            this.addElement("UI_Name", "", this.xmlToCdata(param.getName() + " - " + param.getSummary()));
            this.addElement("UI_Description", "", this.xmlToCdata(param.getDescription()));
            String dflt = param.getDefault();
            if (dflt != null && dflt.trim().length() > 0) {
                this.addElement("DefaultValue", "", dflt);
            }
            if ((options = param.getOptions()) != null && options.length > 0) {
                this.startElement("OptionList");
                for (int iOpt = 0; iOpt < options.length; ++iOpt) {
                    this.addElement("OptionVal", "", options[iOpt]);
                }
                this.endElement("OptionList");
            }
            this.endElement(paramDecl);
        }
    }

    private void writeInterface(CeaTask task) {
        String atts;
        CeaParameter param;
        int iParam;
        CeaParameter[] params = task.getParameters();
        this.startElement("Interface", CeaWriter.formatAttribute((String)"name", (String)task.getName()));
        this.startElement("input");
        for (int iFlag = 0; iFlag < this.flagDefs_.length; ++iFlag) {
            this.addElement("pref", CeaWriter.formatAttribute((String)"ref", (String)this.flagDefs_[iFlag].getName()), "");
        }
        this.addElement("pref", CeaWriter.formatAttribute((String)"ref", (String)CeaWriter.getParamRef(task, null)), "");
        for (iParam = 0; iParam < params.length; ++iParam) {
            param = params[iParam];
            if (param.isOutput()) continue;
            atts = CeaWriter.formatAttribute((String)"ref", (String)CeaWriter.getParamRef(task, param));
            if (param.isMulti()) {
                atts = atts + CeaWriter.formatAttribute((String)"minoccurs", (String)"0") + CeaWriter.formatAttribute((String)"maxoccurs", (String)"0");
            } else if (param.isNullPermitted()) {
                atts = atts + CeaWriter.formatAttribute((String)"minoccurs", (String)"0");
            }
            this.addElement("pref", atts, "");
        }
        this.endElement("input");
        this.startElement("output");
        for (iParam = 0; iParam < params.length; ++iParam) {
            param = params[iParam];
            if (!param.isOutput()) continue;
            atts = CeaWriter.formatAttribute((String)"ref", (String)CeaWriter.getParamRef(task, param));
            this.addElement("pref", atts, "");
        }
        this.endElement("output");
        this.endElement("Interface");
    }

    protected void startElement(ElementDeclaration el) {
        this.startElement(el.getElementName(), el.getElementAttributes());
    }

    protected void startElement(ElementDeclaration el, String moreAtts) {
        this.startElement(el.getElementName(), el.getElementAttributes() + moreAtts);
    }

    protected void endElement(ElementDeclaration el) {
        this.endElement(el.getElementName());
    }

    private String xmlToCdata(String xmlText) throws SAXException {
        return CeaWriter.formatText((String)this.formatter_.formatXML(xmlText, 0));
    }

    private static String getParamRef(CeaTask task, CeaParameter param) {
        return param == null ? "TASK-" + task.getName() : task.getName() + "_" + param.getName();
    }

    static CeaTask[] createTaskList() throws LoadException {
        ObjectFactory taskFactory = Stilts.getTaskFactory();
        String[] taskNames = taskFactory.getNickNames();
        HashMap<String, CeaTask> appMap = new HashMap<String, CeaTask>();
        for (int i = 0; i < taskNames.length; ++i) {
            String name = taskNames[i];
            Task task = (Task)taskFactory.createObject(name);
            if (task instanceof VariableMapperTask) continue;
            appMap.put(name, new CeaTask(task, name));
        }
        String[] removals = new String[]{"funcs", "sqlclient", "sqlupdate", "sqlskymatch"};
        for (int i = 0; i < removals.length; ++i) {
            String rname = removals[i];
            if (!appMap.containsKey(rname)) {
                throw new RuntimeException("Configuration error: no such task " + rname);
            }
            appMap.remove(rname);
        }
        CeaTask tpipe = (CeaTask)appMap.get("tpipe");
        tpipe.removeParameter("istream");
        CeaTask votcopy = (CeaTask)appMap.get("votcopy");
        votcopy.getParameter("in").setRef(true);
        votcopy.getParameter("out").setOutput(true);
        CeaTask votlint = (CeaTask)appMap.get("votlint");
        votlint.getParameter("out").setOutput(true);
        Object[] appNames = new ArrayList(appMap.keySet()).toArray(new String[0]);
        Arrays.sort(appNames);
        CeaTask[] tasks = new CeaTask[appNames.length];
        for (int i = 0; i < appNames.length; ++i) {
            tasks[i] = (CeaTask)appMap.get(appNames[i]);
        }
        return tasks;
    }

    private static int runMain(String[] args) throws LoadException, SAXException {
        CeaMetadata meta;
        CeaTask[] tasks;
        String cmdname = CeaWriter.class.getName().replaceFirst("^.*\\.", "");
        String commonUsage = " [-task <task>] [-redirects]";
        String usage = "\n   Usage:" + "\n      " + cmdname + " -help" + "\n      " + cmdname + " -impl" + ImplementationCeaWriter.getUsage() + commonUsage + "\n      " + cmdname + " -service" + ServiceCeaWriter.getUsage() + commonUsage + "\n";
        StringBuffer cmdBuf = new StringBuffer(CeaWriter.class.getName());
        for (int i = 0; i < args.length; ++i) {
            cmdBuf.append(' ').append(args[i]);
        }
        String cmdline = cmdBuf.toString();
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        CeaTask task1 = null;
        PrintStream out = System.out;
        Boolean isImpl = null;
        boolean redirects = false;
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if ("-h".equals(arg) || "-help".equals(arg)) {
                System.out.println(usage);
                return 0;
            }
            if (arg.startsWith("-impl")) {
                it.remove();
                if (isImpl != null) {
                    System.err.println(usage);
                    return 1;
                }
                isImpl = Boolean.TRUE;
                continue;
            }
            if (arg.startsWith("-serv")) {
                it.remove();
                if (isImpl != null) {
                    System.err.println(usage);
                    return 1;
                }
                isImpl = Boolean.FALSE;
                continue;
            }
            if (arg.equals("-task") && it.hasNext()) {
                it.remove();
                String taskName = (String)it.next();
                it.remove();
                if (task1 != null) {
                    System.err.println(usage);
                    return 1;
                }
                task1 = new CeaTask((Task)Stilts.getTaskFactory().createObject(taskName), taskName);
                continue;
            }
            if (!arg.equals("-redirects")) continue;
            it.remove();
            redirects = true;
        }
        if (isImpl == null) {
            System.err.println(usage);
            return 1;
        }
        if (task1 == null) {
            tasks = CeaWriter.createTaskList();
            meta = CeaMetadata.createStiltsMetadata(tasks);
        } else {
            tasks = new CeaTask[]{task1};
            meta = CeaMetadata.createTaskMetadata(task1);
        }
        CeaWriter writer = isImpl != false ? new ImplementationCeaWriter(out, tasks, meta, redirects, cmdline) : new ServiceCeaWriter(out, tasks, meta, redirects, cmdline);
        int configStat = writer.configure(argList.toArray(new String[0]));
        if (configStat != 0) {
            System.err.println(usage);
            return configStat;
        }
        writer.writeDocument();
        return 0;
    }

    public static void main(String[] args) throws LoadException, SAXException {
        int status = CeaWriter.runMain(args);
        if (status != 0) {
            System.exit(1);
        }
    }

    static {
        $assertionsDisabled = !CeaWriter.class.desiredAssertionStatus();
    }

    private class RedirectFlagDef
    extends FlagDef {
        private final String name_;
        private final String description_;
        private final String defaultValue_;

        RedirectFlagDef(String name, String description, String defaultValue) {
            this.name_ = name;
            this.description_ = description;
            this.defaultValue_ = defaultValue;
        }

        public String getName() {
            return this.name_;
        }

        public void writeParameter() {
            ElementDeclaration paramDecl = CeaWriter.this.config_.getParameterElement();
            StringBuffer attBuf = new StringBuffer().append(XmlWriter.formatAttribute((String)"name", (String)this.name_)).append(XmlWriter.formatAttribute((String)"type", (String)"text"));
            if (paramDecl.hasAttribute("fileRef")) {
                attBuf.append(XmlWriter.formatAttribute((String)"fileRef", (String)"true"));
            }
            if (paramDecl.hasAttribute("switchType")) {
                attBuf.append(XmlWriter.formatAttribute((String)"switchType", (String)"normal"));
            }
            CeaWriter.this.startElement(paramDecl, attBuf.toString());
            CeaWriter.this.addElement("UI_Name", "", this.name_);
            CeaWriter.this.addElement("UI_Description", "", this.description_);
            if (this.defaultValue_ != null) {
                CeaWriter.this.addElement("DefaultValue", "", this.defaultValue_);
            }
            CeaWriter.this.endElement(paramDecl);
        }
    }

    private abstract class FlagDef {
        private FlagDef() {
        }

        public abstract String getName();

        public abstract void writeParameter();
    }
}

