/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cea;

import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.cea.CeaTask;

public class CeaMetadata {
    private final String ivorn_;
    private final String shortName_;
    private final String longName_;
    private final String refUrl_;
    private final String description_;
    private static final String BASE_IVORN = "ivo://uk.ac.starlink/stilts";
    private static final String MANUAL_URL = "http://www.starlink.ac.uk/stilts/sun256/";

    public CeaMetadata(String ivorn, String shortName, String longName, String refUrl, String description) {
        this.ivorn_ = ivorn;
        this.shortName_ = shortName;
        this.longName_ = longName;
        this.refUrl_ = refUrl;
        this.description_ = description;
    }

    public String getIvorn() {
        return this.ivorn_;
    }

    public String getShortName() {
        return this.shortName_;
    }

    public String getLongName() {
        return this.longName_;
    }

    public String getRefUrl() {
        return this.refUrl_;
    }

    public String getDescription() {
        return this.description_;
    }

    public static CeaMetadata createStiltsMetadata(CeaTask[] tasks) {
        String ivorn = BASE_IVORN;
        String shortName = "STILTS";
        String longName = "STILTS - Starlink Tables Infrastructure Library Tool Set v" + Stilts.getVersion();
        String refUrl = MANUAL_URL;
        StringBuffer dbuf = new StringBuffer();
        dbuf.append("STILTS is a package which provides a number of ").append("table manipulation functions.\n").append("The following tasks (profiles) are provided:\n");
        for (int i = 0; i < tasks.length; ++i) {
            CeaTask task = tasks[i];
            dbuf.append("   ").append(task.getName()).append(": ").append("      ").append(task.getPurpose()).append('\n');
        }
        String desc = dbuf.toString();
        return new CeaMetadata(ivorn, shortName, longName, refUrl, desc);
    }

    public static CeaMetadata createTaskMetadata(CeaTask task) {
        String ivorn = "ivo://uk.ac.starlink/stilts/" + task.getName();
        String shortName = task.getName();
        String longName = task.getName() + " from STILTS" + " v" + Stilts.getVersion();
        String refUrl = MANUAL_URL + task.getName() + ".html";
        String desc = task.getPurpose();
        return new CeaMetadata(ivorn, shortName, longName, refUrl, desc);
    }
}

