/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Formatter {
    private final DocumentBuilder db_;
    private String manualName_ = "SUN/256";

    public Formatter() {
        try {
            this.db_ = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String formatXML(String xml, int indent) throws SAXException {
        return this.formatDOM(this.readDOM(xml), indent);
    }

    public void setManualName(String name) {
        this.manualName_ = name;
    }

    public String getManualName() {
        return this.manualName_;
    }

    private String formatDOM(Document doc, int indent) {
        Result result = new Result(indent);
        this.appendChildren(result, doc);
        return result.getText();
    }

    private void appendChildren(Result result, Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof Element) {
                Element el = (Element)child;
                String tag = el.getTagName();
                if (tag.equals("p")) {
                    this.appendChildren(result, el);
                    result.newLine();
                    result.newLine();
                    continue;
                }
                if (tag.equals("ul")) {
                    result.newLine();
                    this.appendChildren(result, el);
                    result.newLine();
                    result.newLine();
                    continue;
                }
                if (tag.equals("li")) {
                    result.newLine();
                    result.appendText(" * ");
                    result.incLevel();
                    result.incLevel();
                    this.appendChildren(result, el);
                    result.decLevel();
                    result.decLevel();
                    continue;
                }
                if (tag.equals("ref")) {
                    if (el.getFirstChild() != null) {
                        this.appendChildren(result, el);
                        continue;
                    }
                    result.appendWords(this.getManualName());
                    continue;
                }
                this.appendChildren(result, child);
                continue;
            }
            if (child instanceof Text) {
                result.appendWords(((Text)child).getData());
                continue;
            }
            throw new IllegalArgumentException("Can't serialize node " + child.getClass());
        }
    }

    private Document readDOM(String xml) throws SAXException {
        String dxml = "<DOC>" + xml + "</DOC>";
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(dxml.getBytes());
            Document doc = this.db_.parse(in);
            return doc;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static class Result {
        StringBuffer sbuf_ = new StringBuffer();
        StringBuffer line_;
        int leng_ = 75;
        int level_;
        int indent_;
        String pad1_ = "   ";

        Result(int indent) {
            this.indent_ = indent;
            this.newLine();
        }

        void appendWords(String words) {
            if (words.length() == 0) {
                return;
            }
            boolean spaceStart = this.isWhitespace(words.charAt(0));
            boolean spaceEnd = this.isWhitespace(words.charAt(words.length() - 1));
            StringTokenizer st = new StringTokenizer(words);
            while (st.hasMoreTokens()) {
                String word = st.nextToken();
                if (this.line_.length() + word.length() > this.leng_) {
                    this.newLine();
                } else if (this.line_.length() > 0 && spaceStart && !this.isWhitespace(this.line_.charAt(this.line_.length() - 1))) {
                    this.line_.append(' ');
                }
                this.line_.append(word);
                if (!st.hasMoreTokens() && spaceEnd && !this.isWhitespace(this.line_.charAt(this.line_.length() - 1))) {
                    this.line_.append(' ');
                }
                spaceStart = true;
            }
        }

        void appendText(String text) {
            this.line_.append(text);
        }

        void incLevel() {
            ++this.level_;
        }

        void decLevel() {
            --this.level_;
        }

        void newLine() {
            int i;
            if (this.line_ != null) {
                if (this.line_.toString().trim().length() > 0) {
                    this.sbuf_.append(this.line_);
                }
                this.sbuf_.append('\n');
            }
            this.line_ = new StringBuffer();
            for (i = 0; i < this.indent_; ++i) {
                this.line_.append(' ');
            }
            for (i = 0; i < this.level_; ++i) {
                this.line_.append(this.pad1_);
            }
        }

        String getText() {
            if (this.line_ != null && this.line_.toString().trim().length() > 0) {
                this.sbuf_.append(this.line_);
            }
            while (this.sbuf_.length() > 0 && this.isWhitespace(this.sbuf_.charAt(this.sbuf_.length() - 1))) {
                this.sbuf_.setLength(this.sbuf_.length() - 1);
            }
            return this.sbuf_.toString().replaceAll(" *\n", "\n").replaceAll("\n{3,}", "\n\n");
        }

        boolean isWhitespace(char c) {
            switch (c) {
                case '\t': 
                case '\n': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }
    }
}

