/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.wrappers;

import alma.archive.exceptions.identifier.GlobalRangeExceededException;
import alma.archive.exceptions.identifier.LocalRangeExceededException;
import alma.archive.exceptions.identifier.UIDSyntaxException;
import java.net.URI;
import java.net.URISyntaxException;

public final class UniqueIdentifier
implements Cloneable {
    private long globalIdentifier = 0L;
    private long localIdentifier = 0L;
    private final String protocol = "uid";
    private final String seperator = "://";
    private final int globalIdentifierLength = 16;
    private final int localIdentifierLength = 8;
    private final long localIdentifierMAX = (long)Math.pow(16.0, 8.0);

    public UniqueIdentifier() {
    }

    public UniqueIdentifier(long globalIdentifier, long localIdentifier) {
        this.globalIdentifier = globalIdentifier;
        this.localIdentifier = localIdentifier;
    }

    public UniqueIdentifier(String id) throws UIDSyntaxException {
        if (!this.parse(id, false)) {
            throw new UIDSyntaxException("Invalid UID: " + id);
        }
    }

    public UniqueIdentifier(URI uri) throws UIDSyntaxException {
        String id = uri.toASCIIString();
        if (!this.parse(id, false)) {
            throw new UIDSyntaxException("Invalid UID: " + id);
        }
    }

    public void incrementGlobal() throws GlobalRangeExceededException {
        ++this.globalIdentifier;
        if (this.globalIdentifier >= Long.MAX_VALUE) {
            throw new GlobalRangeExceededException("The maximum value for a local identifier is 2^64-1 Long.MAX_VALUE");
        }
    }

    public void incrementLocal() throws LocalRangeExceededException {
        ++this.localIdentifier;
        if (this.localIdentifier >= this.localIdentifierMAX) {
            throw new LocalRangeExceededException("The maximum value for a local identifier is 16^8-1");
        }
    }

    public boolean parse(String id, boolean plain) {
        int firstX;
        String idstring = id;
        if (!plain) {
            int divider = id.indexOf("://");
            if (divider == -1) {
                return false;
            }
            if (id.indexOf("uid") == -1) {
                return false;
            }
            idstring = id.substring(divider + "://".length(), id.length());
            if (idstring.indexOf("/") == -1) {
                return false;
            }
        }
        if ((firstX = id.indexOf("X")) == -1) {
            return false;
        }
        int secondX = id.indexOf("X", firstX + 1);
        if (secondX == -1) {
            return false;
        }
        String global = id.substring(firstX + 1, firstX + 1 + 16);
        String local = id.substring(secondX + 1, id.length());
        this.globalIdentifier = Long.parseLong(global, 16);
        this.localIdentifier = Long.parseLong(local, 16);
        return true;
    }

    public String toXML() {
        return "<uid>" + this.toString() + "</uid>";
    }

    public void fromXML(String xmlid) throws UIDSyntaxException {
        if (!this.parse(this.extractXML("uid", xmlid), false)) {
            throw new UIDSyntaxException("Invalid UID: " + xmlid);
        }
    }

    private String extractXML(String tag, String xmlid) throws UIDSyntaxException {
        String starttag = "<" + tag + ">";
        String endtag = "</" + tag + ">";
        String id = "";
        int start = xmlid.indexOf(starttag);
        int end = xmlid.indexOf(endtag);
        if (start != -1 && end != -1) {
            return xmlid.substring(start + starttag.length(), end);
        }
        throw new UIDSyntaxException("Invalid UID: " + id);
    }

    public String toStringPlain() {
        String globalString = this.padString(Long.toString(this.globalIdentifier, 16), 16);
        String localString = this.padString(Long.toString(this.localIdentifier, 16), 8);
        String plain = "X" + globalString + "X" + localString;
        return plain;
    }

    public String toString() {
        String globalString = this.padString(Long.toString(this.globalIdentifier, 16), 16);
        String localString = this.padString(Long.toString(this.localIdentifier, 16), 8);
        String uid = "uid://X" + globalString + "/X" + localString;
        return uid;
    }

    public URI toURI() {
        try {
            return new URI(this.toString());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private String padString(String input, int length) {
        Object local = input;
        for (int x = input.length(); x < length; ++x) {
            local = "0" + (String)local;
        }
        return local;
    }

    public long getGlobalIdentifier() {
        return this.globalIdentifier;
    }

    public long getLocalIdentifier() {
        return this.localIdentifier;
    }

    public String getScheme() {
        return "uid";
    }

    public Object clone() {
        UniqueIdentifier uiClone;
        try {
            uiClone = (UniqueIdentifier)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        uiClone.globalIdentifier = this.globalIdentifier;
        uiClone.localIdentifier = this.localIdentifier;
        return uiClone;
    }

    public int hashCode() {
        return (Long.toString(this.localIdentifier) + "_" + Long.toString(this.globalIdentifier)).hashCode();
    }

    public boolean equals(Object uid) {
        boolean equals = false;
        if (uid instanceof UniqueIdentifier) {
            UniqueIdentifier uidOther = (UniqueIdentifier)uid;
            equals = this.globalIdentifier == uidOther.globalIdentifier && this.localIdentifier == uidOther.localIdentifier;
        }
        return equals;
    }
}

