/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.oracle;

import alma.ArchiveIdentifierError.wrappers.AcsJIdentifierUnexpectedEx;
import alma.ArchiveIdentifierError.wrappers.AcsJRangeExhaustedEx;
import alma.acs.container.archive.Range;
import alma.archive.database.helpers.BuildString;
import alma.archive.database.helpers.DBConfiguration;
import alma.archive.database.helpers.DatabaseHelper;
import alma.archive.database.helpers.SQLCache;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.database.oracle.DBConfig;
import alma.archive.database.oracle.DatabaseCache;
import alma.archive.database.oracle.DatabaseConnectionPool;
import alma.archive.database.oracle.DatabaseReader;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ArchiveGeneralException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.access.PermissionDeniedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.EntityAlreadyDeletedException;
import alma.archive.exceptions.general.EntityDoesNotExistException;
import alma.archive.exceptions.general.EntityExistsException;
import alma.archive.exceptions.general.EntityUndeletedException;
import alma.archive.exceptions.general.NamespaceDefinedException;
import alma.archive.exceptions.user.RoleAlreadyExistsException;
import alma.archive.exceptions.user.RoleDoesNotExistException;
import alma.archive.exceptions.user.RoleNotAssignedException;
import alma.archive.exceptions.user.UserAlreadyExistsException;
import alma.archive.exceptions.user.UserDoesNotExistException;
import alma.archive.wrappers.ArchiveTimeStamp;
import alma.archive.wrappers.Permissions;
import com.cosylab.logging.engine.log.LogTypeHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.CLOB;
import oracle.xdb.XMLType;

public class DatabaseWriter {
    private static final String tableName_schemas = "xml_schema_entities";
    private static final String schemaTable_schema = "xml_schema_entities".replace("xml_", "").replace("_entities", "").toLowerCase();
    private static final String viewName_uidLookup = "uid_lookup";
    private static final String tableName_metaInf = "xml_metaInfo";
    private static final String tableName_users = "xml_users";
    private static final String tableName_roles = "xml_roles";
    private static final String tableName_userRoles = "xml_userRoles";
    private static final String tableName_schemaNamespaces = "xml_schemaNamespaces";
    private static final String tableName_namespaces = "xml_namespaces";
    private static final String colName_schemaName = "schemaName";
    private static final String colName_version = "version";
    private static final String colName_schemaContents = "xml";
    private static final String colName_timestamp = "timestamp";
    private static final String colName_xml = "xml";
    private static final String colName_schemaUid = "schemaUID";
    private static final String colName_readPermissions = "readPermissions";
    private static final String colName_paramName = "name";
    private static final String colName_paramValue = "value";
    private static final String colName_roleName = "roleName";
    private static final String colName_userName = "userName";
    private static final String colName_prefix = "prefix";
    private static final String colName_namespace = "namespace";
    private static final String colName_virtual = "virtual";
    private final DatabaseCache dbCache;
    private final DatabaseReader dbReader;
    private final DatabaseConnectionPool ocpds;
    private final Logger logger;
    private PreparedStatement logStmt = null;
    private Connection logConn = null;
    private final SQLCache putSQL;
    private final SQLCache putUpSQL;
    private ArrayDescriptor logArrayDesc;

    public DatabaseWriter(Logger logger, DatabaseConnectionPool ocpds, DatabaseReader dbReader, DatabaseCache dbCache) throws DatabaseException, ModuleCriticalException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("-> con1");
        }
        this.logger = logger;
        this.ocpds = ocpds;
        this.dbReader = dbReader;
        this.dbCache = dbCache;
        this.putSQL = new SQLCache(BuildString.buildString("INSERT INTO %s (", "archive_uid", ", ", colName_timestamp, ", ", "xml", ", ", colName_schemaUid, ", ", "owner", ", ", "deleted", ", ", colName_readPermissions, ", ", "writePermissions", ", ", "hidden", ", ", "dirty", ", ", colName_virtual, ") ", "VALUES (?, ?, xmltype(?), ?, ?, ?, ?, ?, ?, ?, ?)"), 200);
        this.putUpSQL = new SQLCache(BuildString.buildString("UPDATE %s SET ", colName_timestamp, "= ?, ", "xml", "=?, ", "dirty", "= ? WHERE ", "archive_uid", "=?"), 200);
        this.reinit();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("<- con1");
        }
    }

    public synchronized void reinit() throws DatabaseException, ModuleCriticalException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("-> reinit");
        }
        this.closeLogConnection();
        this.initLogConnection();
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- reinit");
        }
    }

    public void closeLogConnection() {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("-> closeLogConnection");
        }
        try {
            if (this.logStmt != null) {
                this.logStmt.close();
            }
        }
        catch (Exception e) {
            this.logger.fine("Ignoring SQL exception during reinit: " + String.valueOf(e));
        }
        try {
            if (this.logConn != null) {
                this.logConn.close();
            }
        }
        catch (Exception e) {
            this.logger.fine("Ignoring SQL exception during reinit: " + String.valueOf(e));
        }
        this.logStmt = null;
        this.logConn = null;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- closeLogConnection");
        }
    }

    public void close() {
        this.closeLogConnection();
    }

    public void updateXML(URI uid, String schema, String newChild) throws EntityDoesNotExistException, DatabaseException {
        String sql = BuildString.buildString("UPDATE ", DBConfig.schemaTabName(schema), " SET ", "xml", " =  appendChildXML(xml, '/*', XMLType('", newChild, "')) WHERE ", "archive_uid", "='", uid == null ? null : uid.toString(), "'");
        this.logger.finest("Executing SQL: " + sql);
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            stmt = conn.createStatement();
            int count = stmt.executeUpdate(sql);
            if (count == 0) {
                throw new EntityDoesNotExistException(uid.toString());
            }
            if (count > 1) {
                throw new SQLException("Wrong update count, expected 1, got: " + count);
            }
            conn.commit();
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new DatabaseException("Could not update document " + String.valueOf(uid) + ": " + e.toString());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (this.ocpds != null) {
                    this.ocpds.close(conn);
                }
            }
            catch (SQLException e) {
                this.logger.fine("Ignoring SQL Exception when closing resources: " + e.toString());
            }
        }
    }

    public void storeLog(String message, int level, String timeStamp, String file, String line, String routine, String sourceObject, String host, String process, String context, String thread, String logId, String priority, String uri, String audience, String array, String antenna, String[] dataStrings, String xml, boolean commit, String steEnv) throws DatabaseException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("-> storeLog");
        }
        if (timeStamp == null) {
            throw new DatabaseException("Could not store this log, no timestamp provided: " + xml);
        }
        if (this.logStmt == null) {
            throw new DatabaseException("Could not store this log, PreparedStatement for logs is null:" + xml);
        }
        try {
            this.logStmt.setInt(1, level);
            this.logStmt.setTimestamp(2, new ArchiveTimeStamp(timeStamp).getTimestamp());
            if (file != null) {
                this.logStmt.setString(3, file);
            } else {
                this.logStmt.setNull(3, 12);
            }
            if (line != null) {
                this.logStmt.setInt(4, Integer.parseInt(line));
            } else {
                this.logStmt.setNull(4, 4);
            }
            if (routine != null) {
                this.logStmt.setString(5, routine);
            } else {
                this.logStmt.setNull(5, 12);
            }
            if (sourceObject != null) {
                this.logStmt.setString(6, sourceObject);
            } else {
                this.logStmt.setNull(6, 12);
            }
            if (host != null) {
                this.logStmt.setString(7, host);
            } else {
                this.logStmt.setNull(7, 12);
            }
            if (process != null) {
                this.logStmt.setString(8, process);
            } else {
                this.logStmt.setNull(8, 12);
            }
            if (context != null) {
                this.logStmt.setString(9, context);
            } else {
                this.logStmt.setNull(9, 12);
            }
            if (thread != null) {
                this.logStmt.setString(10, thread);
            } else {
                this.logStmt.setNull(10, 12);
            }
            if (logId != null) {
                this.logStmt.setString(11, logId);
            } else {
                this.logStmt.setNull(11, 12);
            }
            if (priority != null) {
                this.logStmt.setString(12, priority);
            } else {
                this.logStmt.setNull(12, 12);
            }
            if (uri != null) {
                this.logStmt.setString(13, uri);
            } else {
                this.logStmt.setNull(13, 12);
            }
            if (audience != null) {
                this.logStmt.setString(14, audience);
            } else {
                this.logStmt.setNull(14, 12);
            }
            if (array != null) {
                this.logStmt.setString(15, array);
            } else {
                this.logStmt.setNull(15, 12);
            }
            if (antenna != null) {
                this.logStmt.setString(16, antenna);
            } else {
                this.logStmt.setNull(16, 12);
            }
            ARRAY dataArray = new ARRAY(this.logArrayDesc, this.logConn, (Object)dataStrings);
            ((OraclePreparedStatement)this.logStmt).setArray(17, (Array)dataArray);
            if (message != null) {
                this.logStmt.setString(18, message);
            } else {
                this.logStmt.setNull(18, 12);
            }
            if (xml != null) {
                this.logStmt.setString(19, xml);
            } else {
                this.logStmt.setNull(19, 12);
            }
            if (steEnv != null) {
                this.logStmt.setString(20, steEnv);
            } else {
                this.logStmt.setNull(20, 12);
            }
            this.logStmt.execute();
            if (commit || level >= LogTypeHelper.CRITICAL.acsCoreLevel.value) {
                this.logConn.commit();
            }
        }
        catch (SQLException e) {
            throw new DatabaseException("Could not store log. " + e.toString());
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- storeLog");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(URI uid, ArchiveTimeStamp stamp, String xml, URI schema, String schemaName, String owner, Permissions permissions, String user, boolean newEntity, boolean emitLogs) throws ArchiveException {
        OracleConnection conn = null;
        try {
            conn = (OracleConnection)this.ocpds.getConnection();
            try {
                conn.setAutoCommit(false);
                this.put(uid, stamp, xml, schema, schemaName, owner, permissions, user, newEntity, emitLogs, conn);
                try {
                    conn.commit();
                }
                catch (SQLException e1) {
                    block15: {
                        try {
                            if (emitLogs) {
                                this.logger.info("Could not commit last statements, trying rollback...");
                            }
                            conn.rollback();
                        }
                        catch (SQLException e) {
                            if (!emitLogs) break block15;
                            this.logger.warning("Could not rollback transaction. CHECK UID " + String.valueOf(uid));
                        }
                    }
                    throw new DatabaseException("put failed, could not commit.", e1);
                }
            }
            finally {
                block16: {
                    try {
                        this.ocpds.close((Connection)conn, emitLogs);
                    }
                    catch (SQLException e) {
                        if (!emitLogs) break block16;
                        this.logger.warning("Could not close connection... " + e.getMessage());
                    }
                }
            }
        }
        catch (SQLException e) {
            this.logger.severe("Could not create DB connection.");
            throw new DatabaseException("Could not create DB connection.", e);
        }
    }

    public OracleConnection openConnection() throws DatabaseException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("-> openConnection");
        }
        try {
            OracleConnection myConn = (OracleConnection)this.ocpds.getConnection();
            myConn.setAutoCommit(false);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("<- openConnection");
            }
            return myConn;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public void put(URI uid, String xml, String schemaName, String owner, Permissions permissions, String user, boolean newEntity, OracleConnection conn) throws ArchiveException {
        this.put(uid, new ArchiveTimeStamp(), xml, this.dbCache.getURI(schemaName), schemaName, owner, permissions, user, newEntity, true, conn);
    }

    public void put(URI uid, ArchiveTimeStamp stamp, String xml, URI schema, String schemaName, String owner, Permissions permissions, String user, boolean newEntity, boolean emitLogs, OracleConnection conn) throws ArchiveException {
        block43: {
            this.logger.fine("Storing " + String.valueOf(uid) + ".");
            if (!DatabaseHelper.checkArchiveIdStoragePermission(uid, InternalIFFactory.getIdentifierManager(this.logger))) {
                throw new DatabaseException("Cannot store document with UID " + uid.toString() + ": does not match with ArchiveId: " + InternalIFFactory.getIdentifierManager(this.logger).getArchiveId());
            }
            boolean alreadyExists = true;
            try {
                alreadyExists = this.dbReader.exists((Connection)conn, uid);
            }
            catch (EntityDoesNotExistException e) {
                alreadyExists = false;
            }
            if (newEntity && alreadyExists) {
                throw new EntityExistsException(uid.toString());
            }
            if (!newEntity && !alreadyExists) {
                throw new EntityDoesNotExistException(uid.toString());
            }
            try {
                if (newEntity) {
                    String sql = this.putSQL.get(DBConfig.schemaTabName(schemaName));
                    CLOB tempClob = null;
                    try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                        tempClob = CLOB.createTemporary((Connection)conn, (boolean)true, (int)10);
                        tempClob.open(1);
                        try (Writer writer = tempClob.setCharacterStream(0L);){
                            int size = xml.indexOf(60);
                            if (size > -1) {
                                size = xml.indexOf(60, size + 1);
                            }
                            if (size > -1) {
                                size = xml.indexOf(60, size + 1);
                            }
                            this.logger.info("XXX size: " + size);
                            if (size > -1) {
                                String header = xml.substring(0, size);
                                this.logger.info("XXX header: " + header);
                                header = header.replaceFirst("xsi:((noNamespaceS)|s)chemaLocation=[\"'].*?[\"']", "");
                                this.logger.info("XXX header: " + header);
                                writer.write(header);
                                writer.write(xml, size, xml.length() - size);
                            } else {
                                writer.write(xml);
                            }
                        }
                        tempClob.close();
                        xml = null;
                        pstmt.setString(1, uid.toString());
                        pstmt.setTimestamp(2, stamp.getTimestamp());
                        pstmt.setObject(3, tempClob);
                        pstmt.setString(4, schema.toString());
                        pstmt.setString(5, owner);
                        pstmt.setInt(6, 0);
                        pstmt.setString(7, permissions.getRead());
                        pstmt.setString(8, permissions.getWrite());
                        pstmt.setInt(9, 0);
                        pstmt.setInt(10, 0);
                        pstmt.setInt(11, 0);
                        if (emitLogs) {
                            this.logger.finest("Executing SQL: " + sql);
                        }
                        pstmt.executeUpdate();
                        break block43;
                    }
                    catch (IOException e) {
                        throw new DatabaseException("Could not write XML into temporary CLOB", e);
                    }
                    finally {
                        if (tempClob != null) {
                            tempClob.freeTemporary();
                        }
                    }
                }
                String tableName = DBConfig.schemaTabName(schemaName);
                String sql = this.putUpSQL.get(tableName);
                try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                    pstmt.setTimestamp(1, stamp.getTimestamp());
                    XMLType xmlInsert = XMLType.createXML((Connection)conn, (String)xml);
                    xml = null;
                    pstmt.setObject(2, xmlInsert);
                    pstmt.setInt(3, tableName.trim().toLowerCase().contains("obsproject") ? 1 : 0);
                    pstmt.setString(4, uid.toString());
                    if (emitLogs) {
                        this.logger.finer("Executing SQL: " + sql);
                    }
                    pstmt.executeUpdate();
                }
            }
            catch (SQLException e) {
                block44: {
                    if (emitLogs) {
                        this.logger.warning("Oracle error: " + String.valueOf(e));
                    }
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        if (!emitLogs) break block44;
                        this.logger.warning("Could not rollback transaction. CHECK UID " + String.valueOf(uid));
                    }
                }
                if (e.getErrorCode() == 1653) {
                    throw new ModuleCriticalException(e, 1653, "Tablespace cannot be extended.");
                }
                throw new DatabaseException(e);
            }
        }
    }

    public void commit(OracleConnection conn) throws DatabaseException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("-> commit");
        }
        try {
            conn.commit();
        }
        catch (Throwable e) {
            this.logger.warning("Could not commit on connection object!");
            throw new DatabaseException(e);
        }
        finally {
            try {
                conn.close();
            }
            catch (Throwable e) {
                this.logger.info("Problems when returning connection object to pool. Ignoring.");
            }
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- commit");
        }
    }

    public void putAll(URI[] uid, String[] xml, String[] schemaName, String[] owner, Permissions[] permissions, String user, boolean[] newEntity) throws EntityDoesNotExistException, EntityExistsException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        int length = uid.length;
        if (xml.length != length || schemaName.length != length || owner.length != length || permissions.length != length) {
            throw new DatabaseException("Number of elements in parameter arrays of putAll must be equal! No document stored!");
        }
        OracleConnection myConn = null;
        try {
            myConn = (OracleConnection)this.ocpds.getConnection();
            for (int i = 0; i < length; ++i) {
                this.put(uid[i], xml[i], schemaName[i], owner[i], permissions[i], user, newEntity[i], myConn);
            }
            this.ocpds.close((Connection)myConn);
        }
        catch (Throwable e) {
            this.logger.warning("Could not store document. Rolling back transaction. Exception caught:\n" + e.toString());
            try {
                myConn.rollback();
            }
            catch (Throwable e1) {
                Object uidString = uid[0].toString();
                for (int i = 1; i < length; ++i) {
                    uidString = (String)uidString + " " + String.valueOf(uid[i]);
                }
                this.logger.warning("Could not rollback transaction. Check consistency of UIDs: " + (String)uidString);
            }
        }
    }

    public synchronized void un_delete(URI uid, String schemaName, String user, boolean newDelete) throws ArchiveGeneralException {
        Connection conn = null;
        String newDel = newDelete ? "1" : "0";
        try {
            boolean docDeleted;
            String schemaTableName;
            block34: {
                conn = this.ocpds.getConnection();
                schemaTableName = DBConfig.schemaTabName(schemaName);
                String selectSql = String.format("SELECT owner, deleted, dirty, hidden, writePermissions FROM %s WHERE archive_uid = ?", schemaTableName);
                this.logger.finest("Executing SQL: " + selectSql + ", " + String.valueOf(uid));
                try (PreparedStatement ps = conn.prepareStatement(selectSql);){
                    ps.setString(1, uid == null ? null : uid.toString());
                    try (ResultSet rs = ps.executeQuery();){
                        if (rs.next()) {
                            docDeleted = rs.getBoolean("deleted");
                            break block34;
                        }
                        String message = String.format("Entity inconsistency: %s does not exist in table %s, but in history table", uid, schemaTableName);
                        this.logger.warning(message);
                        throw new ArchiveGeneralException(message);
                    }
                }
            }
            if (docDeleted == newDelete) {
                if (newDelete) {
                    throw new EntityAlreadyDeletedException(uid.toString());
                }
                throw new EntityUndeletedException(uid.toString());
            }
            String updateSql = String.format("UPDATE %s SET deleted = ? where archive_uid = ?", schemaTableName);
            try (PreparedStatement ps = conn.prepareStatement(updateSql);){
                ps.setString(1, newDel);
                ps.setString(2, uid == null ? null : uid.toString());
                ps.executeUpdate();
            }
            conn.commit();
        }
        catch (SQLException e) {
            this.logger.log(Level.WARNING, "SQL raised exceptio", e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException e1) {
                this.logger.warning("Could not rollback transaction. CHECK UID " + String.valueOf(uid));
            }
            throw new DatabaseException(e);
        }
        finally {
            try {
                if (conn != null) {
                    this.ocpds.close(conn);
                }
            }
            catch (SQLException e1) {
                this.logger.warning("Exception raised while closing SQL resources.");
            }
        }
    }

    public synchronized void setFlag(URI uid, String schemaName, String flagName, boolean flagValue, String user) throws ArchiveException {
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            this.setFlag(uid, schemaName, flagName, flagValue, user, conn);
            conn.commit();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            if (conn != null) {
                try {
                    this.ocpds.close(conn);
                }
                catch (SQLException e) {
                    this.logger.info("Ignoring SQL exception while removing Oracle resources: " + e.toString());
                }
            }
        }
    }

    public synchronized void setFlag(URI uid, String schemaName, String flagName, boolean flagValue, String user, Connection conn) throws ArchiveException {
        Statement stmt = null;
        String sql = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            sql = BuildString.buildString("SELECT ", "deleted", ", ", "hidden", ", ", "dirty", ", ", "owner", ", ", "writePermissions", " FROM ", DBConfig.schemaTabName(schemaName), " WHERE ", "archive_uid", "='", uid == null ? null : uid.toString(), "'");
            this.logger.finest("Executing SQL: " + sql);
            rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                throw new EntityDoesNotExistException("Did not find UID: " + String.valueOf(uid));
            }
            sql = BuildString.buildString("UPDATE ", DBConfig.schemaTabName(schemaName), " SET ", flagName, "=", flagValue ? "1" : "0", " WHERE ", "archive_uid", "='", uid == null ? null : uid.toString(), "'");
            this.logger.finest("Executing SQL: " + sql);
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.logger.warning("SQL raised exception: " + sql);
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                this.logger.warning("Could not rollback transaction. CHECK UID " + String.valueOf(uid));
            }
            throw new DatabaseException(e);
        }
        finally {
            try {
                rs.close();
                stmt.close();
            }
            catch (SQLException e1) {
                this.logger.info("Ignoring SQL exception while removing Oracle resources: " + e1.toString());
            }
        }
    }

    public synchronized void remove(URI uid, String schemaName, String user) throws ArchiveException {
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            stmt = conn.createStatement();
            String sql = BuildString.buildString("DELETE FROM ", DBConfig.schemaTabName(schemaName), " WHERE ", "archive_uid", "='", uid == null ? null : uid.toString(), "'");
            this.logger.finest("Executing SQL: " + sql);
            stmt.executeUpdate(sql);
            conn.commit();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            try {
                stmt.close();
                this.ocpds.close(conn);
            }
            catch (SQLException e1) {
                this.logger.info("Ignoring SQL excpetion while closing Oracle resources: " + e1.toString());
            }
        }
    }

    public synchronized void setPermission(URI uid, String schemaName, Permissions permissions, String user) throws EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        Statement stmt = null;
        String sql = null;
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            stmt = conn.createStatement();
            sql = BuildString.buildString("UPDATE ", DBConfig.schemaTabName(schemaName), " SET ", colName_readPermissions, "='", permissions.getRead(), "', ", "writePermissions", "= '", permissions.getWrite(), "'  WHERE ", "archive_uid", "='", uid == null ? null : uid.toString(), "'");
            this.logger.finest("Executing SQL: " + sql);
            stmt.execute(sql);
            conn.commit();
        }
        catch (SQLException e) {
            this.logger.warning("SQL raised exception: " + sql);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException e1) {
                this.logger.warning("Could not rollback transaction. CHECK UID " + String.valueOf(uid));
            }
            throw new DatabaseException(e);
        }
        finally {
            try {
                if (conn != null) {
                    stmt.close();
                    this.ocpds.close(conn);
                }
            }
            catch (SQLException e1) {
                this.logger.info("Ignoring SQL exception while closing DB resources.");
            }
        }
    }

    public void setVirtual(URI uid, String schemaName, String user, boolean virtual) throws EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            stmt = conn.createStatement();
            String sql = "UPDATE " + DBConfig.schemaTabName(schemaName) + " SET virtual = " + (virtual ? "1" : "0");
            this.logger.finer("Executing SQL: " + sql);
            stmt.executeUpdate(sql);
            conn.commit();
        }
        catch (SQLException e) {
            this.logger.warning("SQL exception: " + e.toString());
            throw new DatabaseException(e);
        }
        finally {
            try {
                stmt.close();
                this.ocpds.close(conn);
            }
            catch (SQLException e1) {
                this.logger.warning("Ignoring SQL exception while closing DB resources: " + e1.toString());
            }
        }
    }

    public void addElement(URI uid, String schemaName, String xPath, String xmlElement, String user) throws EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("-> addElement");
        }
        Statement stmt = null;
        Connection conn = null;
        int endName = xmlElement.indexOf(32) < xmlElement.indexOf(62) ? xmlElement.indexOf(32) : xmlElement.indexOf(62);
        String elName = xmlElement.substring(xmlElement.indexOf(60) + 1, endName);
        ArchiveTimeStamp timestamp = new ArchiveTimeStamp();
        try {
            conn = this.ocpds.getConnection();
            String sql = BuildString.buildString("UPDATE ", DBConfig.schemaTabName(schemaName), " SET ", "xml", "= INSERTCHILDXML(", "xml", ", '", xPath, "', '", elName, "', XMLTYPE('", xmlElement, "'), '", this.dbReader.constructNamespaceString(this.dbReader.getSchemaNamespaces(this.dbCache.getURI(schemaName))), "'), ", colName_timestamp, "=? WHERE ", "archive_uid", "='", uid == null ? null : uid.toString(), "'");
            stmt = conn.prepareStatement(sql);
            stmt.setTimestamp(1, timestamp.getTimestamp());
            this.logger.finest("Executing SQL: " + sql);
            stmt.executeUpdate();
            conn.commit();
        }
        catch (Exception e) {
            this.logger.warning("UpdateXML for " + String.valueOf(uid) + " failed.");
            this.logger.info("SQL command raised exception: " + e.toString());
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                this.logger.warning("Could not rollback transaction. CHECK UID " + String.valueOf(uid));
            }
            throw new DatabaseException(e);
        }
        finally {
            try {
                if (conn != null) {
                    stmt.close();
                    this.ocpds.close(conn);
                }
            }
            catch (SQLException e) {
                this.logger.fine("Ignoring SQL Exception when closing resources: " + e.toString());
            }
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- addElement");
        }
    }

    public void updateElement(URI uid, String schemaName, String xPath, String xmlElement, String user) throws EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        Statement stmt = null;
        Connection conn = null;
        ArchiveTimeStamp timestamp = new ArchiveTimeStamp();
        try {
            conn = this.ocpds.getConnection();
            String sql = BuildString.buildString("UPDATE ", DBConfig.schemaTabName(schemaName), " SET ", "xml", "= UPDATEXML(", "xml", ", '", xPath, "', XMLTYPE('", xmlElement, "'), '", this.dbReader.constructNamespaceString(this.dbReader.getSchemaNamespaces(this.dbCache.getURI(schemaName))), "'), ", colName_timestamp, "=? WHERE ", "archive_uid", "='", uid == null ? null : uid.toString(), "'");
            stmt = conn.prepareStatement(sql);
            stmt.setTimestamp(1, timestamp.getTimestamp());
            this.logger.finest("Executing SQL: " + sql);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            this.logger.warning("UpdateXML for " + String.valueOf(uid) + " failed.");
            this.logger.info("SQL command raised exception: " + e.toString());
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException e1) {
                this.logger.warning("Could not rollback transaction. CHECK UID " + String.valueOf(uid));
            }
            throw new DatabaseException(e);
        }
        finally {
            try {
                if (conn != null) {
                    stmt.close();
                    this.ocpds.close(conn);
                }
            }
            catch (SQLException e) {
                this.logger.fine("Ignoring SQL Exception when closing resources: " + e.toString());
            }
        }
    }

    public void deleteElement(URI uid, String schemaName, String xPath, String user) throws EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        Statement stmt = null;
        Connection conn = null;
        ArchiveTimeStamp timestamp = new ArchiveTimeStamp();
        try {
            conn = this.ocpds.getConnection();
            String sql = BuildString.buildString("UPDATE ", DBConfig.schemaTabName(schemaName), " SET ", "xml", "= DELETEXML(", "xml", ", '", xPath, "', '", this.dbReader.constructNamespaceString(this.dbReader.getSchemaNamespaces(this.dbCache.getURI(schemaName))), "'), ", colName_timestamp, "=? WHERE ", "archive_uid", "='", uid == null ? null : uid.toString(), "'");
            stmt = conn.prepareStatement(sql);
            stmt.setTimestamp(1, timestamp.getTimestamp());
            this.logger.finest("Executing SQL: " + sql);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            this.logger.warning("UpdateXML for " + String.valueOf(uid) + " failed.");
            this.logger.info("SQL command raised exception: " + e.toString());
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException e1) {
                this.logger.warning("Could not rollback transaction. CHECK UID " + String.valueOf(uid));
            }
            throw new DatabaseException(e);
        }
        finally {
            try {
                stmt.close();
                this.ocpds.close(conn);
            }
            catch (SQLException e) {
                this.logger.fine("Ignoring SQL Exception when closing resources: " + e.toString());
            }
        }
    }

    protected synchronized void addSchemaAndTables(URI schemaURI, String schemaName, String schemaContents, String dadFile) throws DatabaseException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("-> addSchemaAndTable");
        }
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
        }
        catch (SQLException e1) {
            this.logger.warning("Could not fetch connection from connenction pool");
            throw new DatabaseException("Could not fetch connection from database connection pool.");
        }
        try {
            this.createTablesForSchema(schemaName, dadFile, conn);
            this.addSchema(schemaURI, schemaName, 1, schemaContents, dadFile, conn);
        }
        catch (DatabaseException e) {
            try {
                this.ocpds.close(conn);
            }
            catch (SQLException e2) {
                this.logger.warning("Could not close connection..." + e2.toString());
            }
            throw e;
        }
        try {
            conn.commit();
        }
        catch (SQLException e) {
            this.logger.warning("Could not commit schema changes for schema " + String.valueOf(schemaURI) + "! Check it!");
        }
        try {
            this.ocpds.close(conn);
        }
        catch (SQLException e1) {
            this.logger.warning("Could not close connection..." + e1.getMessage());
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- addSchemaAndTable");
        }
    }

    protected void createTablesForSchema(String schemaName, String dadFile, Connection conn) throws DatabaseException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            Object sql = "SELECT tname FROM system.tab WHERE tname='" + DBConfig.schemaTabName(schemaName).toUpperCase() + "'";
            this.logger.finest("Executing SQL: " + (String)sql);
            rs = stmt.executeQuery((String)sql);
            if (!rs.next()) {
                String schemaTabName = DBConfig.schemaTabName(schemaName);
                this.logger.info("Creating table " + schemaTabName);
                sql = BuildString.buildString("CREATE TABLE ", schemaTabName, " ( ", "archive_uid", " VARCHAR(33) NOT NULL, ", colName_timestamp, " TIMESTAMP NOT NULL, ", "xml", " xmlTYPE, ", colName_schemaUid, " VARCHAR(33) NOT NULL, ", "owner", " VARCHAR(32), ", "deleted", " NUMBER(1), ", colName_readPermissions, " VARCHAR(8), ", "writePermissions", " VARCHAR(8), ", "hidden", " NUMBER(1), ", "dirty", " NUMBER(1), ", colName_virtual, " NUMBER(1), CONSTRAINT ", schemaTabName.substring(0, schemaTabName.length() - 9), "_uid_pk PRIMARY KEY (", "archive_uid", "))");
                this.logger.fine("Executing: " + (String)sql);
                stmt.executeUpdate((String)sql);
                this.updateUidLookup(stmt, new String[0]);
            }
        }
        catch (SQLException e) {
            this.logger.severe("Oracle error: " + e.getMessage());
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                this.logger.severe("Could not rollback transaction. CHECK SCHEMA " + schemaName);
            }
            throw new DatabaseException(e);
        }
        finally {
            try {
                rs.close();
                stmt.close();
            }
            catch (SQLException e) {
                this.logger.info("Ignoring SQL exception while closing Oracle resources: " + e.toString());
            }
        }
    }

    protected synchronized void addSchema(URI schemaURI, String schemaName, int schemaVersion, String schemaContents, String dadFile, Connection conn) throws DatabaseException {
        OraclePreparedStatement pstmt = null;
        Statement stmt = null;
        this.logger.info("Inserting schema " + schemaName + " into table xml_schema_entities with UID " + String.valueOf(schemaURI));
        try {
            String sql = BuildString.buildString("INSERT INTO ", tableName_schemas, "(", "archive_uid", ",", colName_schemaName, ",", colName_version, ",", colName_timestamp, ",", "xml", ",", "deleted", ",", "hidden", ",", "dirty", ", ", colName_schemaUid, ") VALUES ('", schemaURI == null ? null : schemaURI.toString(), "','", schemaName, "', ", Integer.toString(schemaVersion), ", ?, ?, 0,0,0, '", "http://www.w3.org/XML/Schema", "')");
            this.logger.fine("Executing: " + sql);
            pstmt = (OraclePreparedStatement)conn.prepareStatement(sql);
            pstmt.setTimestamp(1, new ArchiveTimeStamp().getTimestamp());
            pstmt.setStringForClob(2, schemaContents);
            pstmt.executeUpdate();
            this.dbCache.remove(schemaName);
            this.dbCache.put(schemaURI, schemaName);
            stmt = conn.createStatement();
            this.updateUidLookup(stmt, new String[0]);
        }
        catch (SQLException e) {
            this.logger.severe("SQL raised exception: " + e.toString());
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                this.logger.severe("Could not rollback transaction. CHECK SCHEMA " + String.valueOf(schemaURI));
            }
            throw new DatabaseException("Could not insert schema " + String.valueOf(schemaURI), e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e1) {
                this.logger.info("Ignoring SQL exception while closing Oracle resources: " + e1.toString());
            }
        }
    }

    public void addSchema(URI schemaURInew, String schemaName, int schemaVersion, String schemaContents, String dadFile) throws DatabaseException {
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            this.addSchema(schemaURInew, schemaName, schemaVersion, schemaContents, dadFile, conn);
            conn.commit();
        }
        catch (SQLException e) {
            this.logger.warning("Addition of schema failed" + e.getMessage());
            throw new DatabaseException(e);
        }
        finally {
            try {
                this.ocpds.close(conn);
            }
            catch (SQLException e) {
                this.logger.warning("Could not close connection...");
            }
        }
    }

    public synchronized void removeSchema(String schemaName) throws DatabaseException {
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            Statement stmt = conn.createStatement();
            URI u = this.dbCache.getURI(schemaName);
            if (u == null) {
                throw new DatabaseException("No such schema: " + schemaName);
            }
            String uid = u.toString();
            Object sql = BuildString.buildString("DELETE FROM ", tableName_schemaNamespaces, " WHERE ", colName_schemaUid, "='", uid, "'");
            this.logger.finest("Executing SQL: " + (String)sql);
            stmt.executeUpdate((String)sql);
            sql = BuildString.buildString("DELETE FROM ", tableName_schemas, " WHERE ", colName_schemaName, "='", schemaName, "'");
            this.logger.finest("Executing SQL: " + (String)sql);
            stmt.executeUpdate((String)sql);
            this.updateUidLookup(stmt, DBConfig.schemaTabName(schemaName));
            sql = "DROP TABLE " + DBConfig.schemaTabName(schemaName) + " CASCADE CONSTRAINTS PURGE";
            this.logger.finest("Executing SQL: " + (String)sql);
            stmt.executeUpdate((String)sql);
            conn.commit();
            this.dbCache.remove(schemaName);
        }
        catch (SQLException e) {
            this.logger.warning("SQL raised exception: " + e.toString());
            throw new DatabaseException(e);
        }
        finally {
            try {
                this.ocpds.close(conn);
            }
            catch (SQLException e1) {
                this.logger.warning("Could not close connection...");
            }
        }
    }

    public void registerNamespace(String prefix, URI namespace) throws NamespaceDefinedException, DatabaseException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("->registerNamespace");
        }
        Statement stmt = null;
        String sql = null;
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            stmt = conn.createStatement();
            sql = BuildString.buildString("INSERT INTO ", tableName_namespaces, " (", colName_prefix, ", ", colName_namespace, ") VALUES ('", prefix, "', '", namespace.toString(), "')");
            this.logger.finest("Executing SQL: " + sql);
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1) {
                throw new NamespaceDefinedException(prefix + ": " + String.valueOf(namespace), e);
            }
            this.logger.warning("Could not insert namespace and prefix: " + String.valueOf(namespace) + ", " + prefix);
            throw new DatabaseException(e);
        }
        finally {
            try {
                if (conn != null) {
                    stmt.close();
                    this.ocpds.close(conn);
                }
            }
            catch (SQLException e1) {
                this.logger.warning("Ignoring SQL exception while closing DB resources: " + e1.toString());
            }
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- registerNamespace");
        }
    }

    public void removeNamespace(String prefix) throws DatabaseException {
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            stmt = conn.createStatement();
            String sql = BuildString.buildString("DELETE FROM ", tableName_namespaces, " WHERE ", colName_prefix, "='", prefix, "'");
            this.logger.finest("Executing SQL: " + sql);
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.logger.warning("Could not remove namespace prefix: " + prefix);
            throw new DatabaseException(e);
        }
        finally {
            try {
                stmt.close();
                this.ocpds.close(conn);
            }
            catch (SQLException e1) {
                this.logger.warning("Ignoring SQL exception while closing DB resources: " + e1.toString());
            }
        }
    }

    public void removeNamespaces() throws DatabaseException {
        String sql;
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            stmt = conn.createStatement();
            sql = "DELETE FROM xml_namespaces";
            this.logger.finest("Executing SQL: " + sql);
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.logger.warning("Could not remove namespaces.");
            throw new DatabaseException(e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException e1) {
                this.logger.warning("Ignoring SQL exception while closing DB resources: " + e1.toString());
            }
        }
        try {
            stmt = conn.createStatement();
            sql = "DELETE FROM xml_schemaNamespaces";
            this.logger.finest("Executing SQL: " + sql);
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.logger.warning("Could not remove namespaces.");
            throw new DatabaseException(e);
        }
        finally {
            try {
                stmt.close();
                this.ocpds.close(conn);
            }
            catch (SQLException e1) {
                this.logger.warning("Ignoring SQL exception while closing DB resources: " + e1.toString());
            }
        }
    }

    public void assignNamespace(String prefix, URI schemaUri) throws DatabaseException {
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            stmt = conn.createStatement();
            String sql = BuildString.buildString("INSERT INTO ", tableName_schemaNamespaces, " ( ", colName_schemaUid, ",", colName_prefix, ") VALUES ('", schemaUri == null ? null : schemaUri.toString(), "', '", prefix, "')");
            this.logger.finest("Executing SQL: " + sql);
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.logger.warning("Could not assign namespace prefix " + prefix + " to schema " + String.valueOf(schemaUri));
            throw new DatabaseException(e);
        }
        finally {
            try {
                stmt.close();
                this.ocpds.close(conn);
            }
            catch (SQLException e1) {
                this.logger.warning("Ignoring SQL exception while closing DB resources: " + e1.toString());
            }
        }
    }

    public void withdrawNamespace(String prefix, URI schemaUri) throws DatabaseException {
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            stmt = conn.createStatement();
            String sql = BuildString.buildString("DELETE FROM ", tableName_schemaNamespaces, " WHERE ", colName_schemaUid, "='", schemaUri == null ? null : schemaUri.toString(), "' AND ", colName_prefix, "='", prefix, "'");
            this.logger.finest("Executing SQL: " + sql);
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.logger.warning("Could not remove namespace prefix: " + prefix + " from schema " + String.valueOf(schemaUri));
            throw new DatabaseException(e);
        }
        finally {
            try {
                stmt.close();
                this.ocpds.close(conn);
            }
            catch (SQLException e1) {
                this.logger.warning("Ignoring SQL exception while closing DB resources: " + e1.toString());
            }
        }
    }

    public void addUser(String user) throws DatabaseException, ArchiveException, UserAlreadyExistsException {
        String sql = null;
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            stmt = conn.createStatement();
            sql = BuildString.buildString("INSERT INTO ", tableName_users, " (", colName_userName, ") VALUES ('", user, "')");
            this.logger.finest("Executing SQL: " + sql);
            stmt.executeUpdate(sql);
            conn.commit();
        }
        catch (SQLException e) {
            this.logger.info("SQL raised exception: " + e.toString());
            throw new DatabaseException(e);
        }
        finally {
            try {
                stmt.close();
                this.ocpds.close(conn);
            }
            catch (SQLException e1) {
                this.logger.info("Ignoring SQL exception while closing Oracle resources: " + e1.toString());
            }
        }
    }

    public void deleteUser(String user) throws DatabaseException, ArchiveException, UserDoesNotExistException {
        String sql = null;
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            stmt = conn.createStatement();
            sql = BuildString.buildString("DELETE FROM ", tableName_users, " WHERE ", colName_userName, "='", user, "'");
            this.logger.finest("Executing SQL: " + sql);
            stmt.executeUpdate(sql);
            conn.commit();
        }
        catch (SQLException e) {
            this.logger.info("SQL raised exception: " + e.toString());
            throw new DatabaseException(e);
        }
        finally {
            try {
                this.ocpds.close(conn);
                stmt.close();
            }
            catch (SQLException e1) {
                this.logger.info("Ignoring SQL exception while closing Oracle resources: " + e1.toString());
            }
        }
    }

    public void addRole(String role) throws DatabaseException, ArchiveException, RoleAlreadyExistsException {
        String sql = null;
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            stmt = conn.createStatement();
            sql = BuildString.buildString("INSERT INTO ", tableName_roles, " (", colName_roleName, ") VALUES ('", role, "')");
            this.logger.finest("Executing SQL: " + sql);
            stmt.executeUpdate(sql);
            conn.commit();
        }
        catch (SQLException e) {
            this.logger.info("SQL raised exception: " + e.toString());
            throw new DatabaseException(e);
        }
        finally {
            try {
                this.ocpds.close(conn);
                stmt.close();
            }
            catch (SQLException e1) {
                this.logger.info("Ignoring SQL exception while closing Oracle resources: " + e1.toString());
            }
        }
    }

    public void deleteRole(String role) throws DatabaseException, ArchiveException, RoleDoesNotExistException {
        String sql = null;
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            stmt = conn.createStatement();
            sql = BuildString.buildString("DELETE FROM ", tableName_roles, " WHERE ", colName_roleName, "='", role, "'");
            this.logger.finest("Executing SQL: " + sql);
            stmt.executeUpdate(sql);
            conn.commit();
        }
        catch (SQLException e) {
            this.logger.info("SQL raised exception: " + e.toString());
            throw new DatabaseException(e);
        }
        finally {
            try {
                if (conn != null) {
                    this.ocpds.close(conn);
                    stmt.close();
                }
            }
            catch (SQLException e1) {
                this.logger.info("Ignoring SQL exception while closing Oracle resources: " + e1.toString());
            }
        }
    }

    public void assignRole(String user, String role) throws DatabaseException, ArchiveException, RoleDoesNotExistException, UserDoesNotExistException {
        String sql = null;
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            stmt = conn.createStatement();
            sql = BuildString.buildString("INSERT INTO ", tableName_userRoles, " (", colName_userName, ", ", colName_roleName, ") VALUES ('", user, "', '", role, "')");
            this.logger.finest("Executing SQL: " + sql);
            stmt.executeUpdate(sql);
            conn.commit();
        }
        catch (SQLException e) {
            this.logger.info("SQL raised exception: " + e.toString());
            throw new DatabaseException(e);
        }
        finally {
            try {
                this.ocpds.close(conn);
                stmt.close();
            }
            catch (SQLException e1) {
                this.logger.info("Ignoring SQL exception while closing Oracle resources: " + e1.toString());
            }
        }
    }

    public void withdrawRole(String user, String role) throws DatabaseException, ArchiveException, RoleDoesNotExistException, UserDoesNotExistException, RoleNotAssignedException {
        String sql = null;
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            stmt = conn.createStatement();
            sql = BuildString.buildString("DELETE FROM ", tableName_userRoles, " WHERE ", colName_userName, "='", user, "' AND ", colName_roleName, "= '", role, "'");
            this.logger.finest("Executing SQL: " + sql);
            stmt.executeUpdate(sql);
            conn.commit();
        }
        catch (SQLException e) {
            this.logger.info("SQL raised exception: " + e.toString());
            throw new DatabaseException(e);
        }
        finally {
            try {
                this.ocpds.close(conn);
                stmt.close();
            }
            catch (SQLException e1) {
                this.logger.info("Ignoring SQL exception while closing Oracle resources: " + e1.toString());
            }
        }
    }

    public void changeOwner(URI uid, String schemaName, String newOwner, String user) throws EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        Statement stmt = null;
        String sql = null;
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            stmt = conn.createStatement();
            sql = BuildString.buildString("UPDATE ", DBConfig.schemaTabName(schemaName), " SET ", "owner", "= '", newOwner, "'  WHERE ", "archive_uid", "='", uid == null ? null : uid.toString(), "'");
            this.logger.finest("Executing SQL: " + sql);
            stmt.execute(sql);
            conn.commit();
        }
        catch (SQLException e) {
            this.logger.warning("SQL raised exception: " + sql);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException e1) {
                this.logger.warning("Could not rollback transaction. CHECK UID " + String.valueOf(uid));
            }
            throw new DatabaseException(e);
        }
        finally {
            try {
                if (conn != null) {
                    stmt.close();
                    this.ocpds.close(conn);
                }
            }
            catch (SQLException e1) {
                this.logger.info("Ignoring SQL exception while closing DB resources.");
            }
        }
    }

    protected void cleanTestArea() throws ArchiveException {
        InputStream SQLscript;
        URL propsFile;
        DBConfiguration config = DBConfiguration.instance(this.logger);
        if (!"test".equals(config.get("archive.db.mode")) || !"almatest".equals(config.get("archive.oracle.user")) && !"alma_ut".contentEquals(config.get("archive.oracle.user"))) {
            throw new DatabaseException("Must use test connection to test database for cleaning. Check file dbConfig.properties!");
        }
        this.logger.info("Removing all entries from test area.");
        String archiveID = null;
        try {
            archiveID = this.dbReader.getMetaParamValue("archiveID");
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "test setup failed", e);
        }
        this.logger.info("ARCHIVE ID " + archiveID);
        if (archiveID == null || archiveID.equals("null")) {
            archiveID = "X00";
        }
        if ((propsFile = this.getClass().getResource("/scripts/AlmaTestDbCreateTables.sql")) == null) {
            throw new DatabaseException("Could not find SQL script for cleaning test DB. Assumed location: AlmaTestDbCreateTables.sql in archive_database.jar");
        }
        this.logger.info("-------- Loading " + String.valueOf(propsFile));
        try {
            SQLscript = propsFile.openStream();
        }
        catch (IOException e1) {
            throw new DatabaseException("Problems when opening SQL script for cleaning test DB. Location: AlmaTestDbCreateTables.sql in archive_database.jar");
        }
        try {
            this.executeSQLscript(SQLscript);
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
        this.checkSchemaConsistency(true);
        this.setMetaParamValue("archiveID", archiveID);
        this.loadIdentifierRangeSchema();
    }

    protected void loadIdentifierRangeSchema() throws ArchiveException {
        URI idRangeURI;
        BufferedReader UIDschemaReader;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- loadIdentifierRangeSchema");
        }
        ClassLoader loader = DBConfiguration.class.getClassLoader();
        StringBuffer UIDschema = new StringBuffer();
        URL UIDschemaFile = loader.getResource("IdentifierRange.xsd");
        if (UIDschemaFile == null) {
            this.logger.severe("Could not find IdentifierRange.xsd. Assumed location: IdentifierRange.xsd in archive_xmlstore_if.jar");
            throw new DatabaseException("Could not find IdentifierRange.xsd. Assumed location: IdentifierRange.xsd in archive_xmlstore_if.jar");
        }
        this.logger.info("-------- Loading " + String.valueOf(UIDschemaFile));
        try {
            UIDschemaReader = new BufferedReader(new InputStreamReader(UIDschemaFile.openStream()));
        }
        catch (IOException e1) {
            this.logger.severe("Problems when opening schema file for UID range. Location: IndentifierRange.xsd in archive_xmlstore_if.jar");
            throw new DatabaseException("Problems when opening schema file for UID range. Location: IndentifierRange.xsd in archive_xmlstore_if.jar");
        }
        try {
            while (UIDschemaReader.ready()) {
                UIDschema.append(UIDschemaReader.readLine());
            }
        }
        catch (IOException e) {
            this.logger.severe("Problems when opening schema file for UID range. Location: IndentifierRange.xsd in archive_xmlstore_if.jar");
            throw new DatabaseException("Problems when opening schema file for UID range. Location: IndentifierRange.xsd in archive_xmlstore_if.jar");
        }
        try {
            idRangeURI = new Range(InternalIFFactory.getIdentifierManager(this.logger).getNewRange()).next();
        }
        catch (AcsJIdentifierUnexpectedEx | AcsJRangeExhaustedEx | ArchiveException e) {
            throw new DatabaseException(e);
        }
        this.logger.info("Storing IdentifierRange.xsd under UID: " + String.valueOf(idRangeURI));
        this.addSchemaAndTables(idRangeURI, "IdentifierRange", UIDschema.toString(), "");
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- loadIdentifierRangeSchema");
        }
    }

    protected void setMetaParamValue(String paramName, String paramValue) throws DatabaseException {
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            String sql = BuildString.buildString("DELETE FROM ", tableName_metaInf, " WHERE ", colName_paramName, "='", paramName, "'");
            this.logger.finest("Executing SQL: " + sql);
            stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            sql = BuildString.buildString("INSERT INTO ", tableName_metaInf, " ( ", colName_paramName, ",", colName_paramValue, ") VALUES ('", paramName, "', '", paramValue, "')");
            this.logger.finest("Executing SQL: " + sql);
            stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            conn.commit();
        }
        catch (SQLException e) {
            this.logger.warning("Oracle error during storage of meta parameter: " + e.toString());
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                this.logger.warning("Could not rollback transaction! CHECK parameter " + paramName + " in table xml_metaInfo! " + e1.toString());
            }
            throw new DatabaseException(e);
        }
        finally {
            try {
                if (conn != null) {
                    this.ocpds.close(conn);
                    stmt.close();
                }
            }
            catch (SQLException e) {
                this.logger.info(e.toString());
            }
        }
    }

    protected void updateMetaParamValue(String paramName, String paramValue) throws DatabaseException {
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.ocpds.getConnection();
            String sql = BuildString.buildString("UPDATE ", tableName_metaInf, " SET ", colName_paramValue, "='", paramValue, "' WHERE ", colName_paramName, "='", paramName, "'");
            this.logger.finest("Executing SQL: " + sql);
            stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            conn.commit();
        }
        catch (SQLException e) {
            this.logger.warning("Oracle error during storage of meta parameter: " + e.toString());
            throw new DatabaseException(e);
        }
        finally {
            try {
                this.ocpds.close(conn);
                stmt.close();
            }
            catch (SQLException e) {
                this.logger.info(e.toString());
            }
        }
    }

    public void cleanSchema(String schemaName) throws DatabaseException, ModuleCriticalException {
        throw new RuntimeException("removed due to being a really, really bad idea in operational code");
    }

    protected boolean checkNamespaces(boolean replace) throws DatabaseException, ModuleCriticalException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("-> checkNamespaces");
        }
        boolean inconsistencyFound = false;
        Statement stmt = null;
        Statement stmt2 = null;
        Connection conn = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        this.logger.info("Checking namespace consistency in Oracle.");
        if (replace) {
            this.logger.info("Replacing incosistent references to schemas (older schemas) with correct ones (newer schema versions).");
        }
        this.dbReader.initSchemaMaps();
        try {
            String sql = "SELECT schemaUID FROM xml_schemaNamespaces";
            this.logger.finest("Executing SQL: " + sql);
            URI schema = null;
            conn = this.ocpds.getConnection();
            stmt = conn.createStatement();
            stmt2 = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                try {
                    schema = new URI(rs.getString(colName_schemaUid));
                    if (this.dbCache.getSchema(schema) != null) continue;
                    inconsistencyFound = true;
                    this.logger.info("Schema " + String.valueOf(schema) + " is not the newest version. Queries will fail!");
                    if (!replace) continue;
                    this.logger.info("Replacing outdated schema reference " + String.valueOf(schema) + " in xml_schemaNamespaces");
                    sql = BuildString.buildString("SELECT ", colName_schemaName, " FROM ", tableName_schemas, " WHERE ", "archive_uid", "='", schema == null ? null : schema.toString(), "'");
                    this.logger.finest("Executing SQL: " + sql);
                    rs2 = stmt2.executeQuery(sql);
                    if (rs2.next()) {
                        String schemaName = rs2.getString(colName_schemaName);
                        URI u = this.dbCache.getURI(schemaName);
                        sql = BuildString.buildString("UPDATE ", tableName_schemaNamespaces, " SET ", colName_schemaUid, "='", u == null ? null : u.toString(), "' WHERE ", colName_schemaUid, "='", schema == null ? null : schema.toString(), "'");
                        this.logger.finest("Executing SQL: " + sql);
                        stmt2.executeUpdate(sql);
                    } else {
                        sql = BuildString.buildString("DELETE FROM ", tableName_schemaNamespaces, " WHERE ", "schemaUID='", schema == null ? null : schema.toString(), "'");
                        this.logger.finest("Executing SQL: " + sql);
                        this.logger.info("Removing reference to schema " + String.valueOf(schema) + " from xml_schemaNamespaces since this schema does not exist!");
                        stmt2.executeUpdate(sql);
                    }
                    rs2.close();
                }
                catch (URISyntaxException e) {
                    this.logger.severe("Found incorrect UID in Database: " + String.valueOf(schema));
                }
            }
            sql = "SELECT prefix FROM xml_namespaces";
            this.logger.finest("Executing SQL: " + sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String prefix = rs.getString(colName_prefix);
                sql = BuildString.buildString("SELECT * FROM ", tableName_schemaNamespaces, " WHERE ", colName_prefix, "='", prefix, "'");
                this.logger.finest("Executing SQL: " + sql);
                rs2 = stmt2.executeQuery(sql);
                if (!rs2.next()) {
                    inconsistencyFound = true;
                    this.logger.info("Prefix " + prefix + " is not associated with a schema");
                    if (replace) {
                        this.logger.info("Removing namespace prefix " + prefix + " from xml_namespaces");
                        sql = BuildString.buildString("DELETE FROM ", tableName_namespaces, " WHERE ", colName_prefix, "='", prefix, "'");
                        this.logger.finest("Executing SQL: " + sql);
                        rs2 = stmt2.executeQuery(sql);
                    }
                }
                rs2.close();
            }
        }
        catch (SQLException e) {
            throw new DatabaseException("Caught SQL Exception: " + e.toString());
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {
                this.logger.info("Ignoring SQL exception while closing resources: " + e.toString());
            }
            try {
                stmt.close();
            }
            catch (Exception e) {
                this.logger.info("Ignoring SQL exception while closing resources: " + e.toString());
            }
            try {
                stmt2.close();
            }
            catch (Exception e) {
                this.logger.info("Ignoring SQL exception while closing resources: " + e.toString());
            }
            try {
                this.ocpds.close(conn);
            }
            catch (Exception e) {
                this.logger.info("Ignoring SQL exception while closing resources: " + e.toString());
            }
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- checkNamespaces");
        }
        return !inconsistencyFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkSchemaConsistency(boolean delete) throws DatabaseException, ModuleCriticalException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("-> checkSchemaConsistency");
        }
        boolean foundInconsitency = false;
        this.logger.info("Searching for inconsistent XML schema tables....");
        if (delete) {
            this.logger.info("Removing inconsistent tables and schema entries.");
        }
        Statement stmt = null;
        Connection conn = null;
        HashMap<String, String> schemaEntries = new HashMap<String, String>();
        try {
            this.dbReader.initSchemaMaps();
            for (String schemaEntry : this.dbCache.getSchemas()) {
                schemaEntries.put(schemaEntry.length() < 17 ? schemaEntry.toLowerCase() : schemaEntry.toLowerCase().substring(0, 17), schemaEntry);
            }
            conn = this.ocpds.getConnection();
            stmt = conn.createStatement();
            HashSet<String> tableNames = new HashSet<String>(this.getAllEntitiesTables(stmt, tableName_schemas.toUpperCase()));
            foundInconsitency = this.checkTables(delete, stmt, tableNames, schemaEntries.keySet());
            foundInconsitency = foundInconsitency || this.checkSchemas(delete, stmt, tableNames, schemaEntries);
            conn.commit();
        }
        catch (Exception e) {
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                this.logger.info("Ignoring exception during DB rollback: " + String.valueOf(e));
            }
            this.logger.fine("Ignoring exception during DB cleanup: " + String.valueOf(e));
        }
        finally {
            try {
                stmt.close();
                this.ocpds.close(conn);
            }
            catch (Exception e1) {
                this.logger.fine("Ignoring DB exception while closing DB ressources");
            }
        }
        if (foundInconsitency && delete) {
            this.checkNamespaces(true);
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- checkSchemaConsistency");
        }
        return !foundInconsitency;
    }

    private boolean checkSchemas(boolean delete, Statement stmt, Set<String> tableNames, HashMap<String, String> schemaEntries) throws SQLException, DatabaseException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("-> checkSchemas");
        }
        boolean foundInconsitency = false;
        for (String schemaName : schemaEntries.keySet()) {
            String tName = "xml_".toUpperCase() + schemaName.toUpperCase() + "_entities".toUpperCase();
            if (tableNames.contains(tName)) continue;
            this.logger.info("Inconsistent entry " + schemaEntries.get(schemaName));
            foundInconsitency = true;
            if (!delete) continue;
            String sql = BuildString.buildString("DELETE FROM ", tableName_schemas, " WHERE ", colName_schemaName, "='", schemaEntries.get(schemaName), "'");
            this.logger.info("Removing entry " + schemaName + " from table xml_schema_entities");
            this.logger.fine("Executing SQL: " + sql);
            stmt.executeUpdate(sql);
            this.dbCache.remove(schemaEntries.get(schemaName));
            this.updateUidLookup(stmt, tName);
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- checkSchemas");
        }
        return foundInconsitency;
    }

    private boolean checkTables(boolean delete, Statement stmt, Set<String> tableNames, Set<String> schemaEntries) {
        boolean foundInconsitency = false;
        for (String tName : tableNames) {
            String schemaName = tName.replaceFirst("_entities".toUpperCase(), "").replaceFirst("xml_".toUpperCase(), "").toLowerCase();
            if (schemaEntries.contains(schemaName)) continue;
            this.logger.warning("Inconsistent table " + tName + "exists in the DB, but there is no entry in XML_SCHEMAS");
            foundInconsitency = true;
            if (!delete) continue;
        }
        return foundInconsitency;
    }

    public void executeSQLscript(InputStream script) throws IOException, DatabaseException {
        Statement stmt = null;
        Connection conn = null;
        InputStreamReader reader = new InputStreamReader(script);
        StringBuffer line = null;
        try {
            conn = this.ocpds.getConnection();
            stmt = conn.createStatement();
        }
        catch (SQLException e2) {
            this.logger.warning("Could not initialize SQL connection: " + e2.toString());
            throw new DatabaseException(e2);
        }
        int read = reader.read();
        while (read != -1) {
            block18: {
                try {
                    line = new StringBuffer();
                    int lineRead = read;
                    while (lineRead != -1 && lineRead != 59) {
                        if (lineRead != 10 && lineRead != 47) {
                            line.append(new Character((char)lineRead));
                        }
                        lineRead = reader.read();
                    }
                    if (lineRead == -1) {
                        read = -1;
                    } else {
                        this.logger.finest("Executing SQL: " + String.valueOf(line));
                        stmt.executeUpdate(line.toString());
                    }
                }
                catch (SQLException e) {
                    String lineOut = line.toString().trim();
                    if (lineOut.substring(0, 5).equalsIgnoreCase("drop ")) break block18;
                    this.logger.warning("SQL exception: " + e.toString());
                }
            }
            read = reader.read();
        }
        try {
            conn.commit();
        }
        catch (SQLException e) {
            this.logger.warning("Could not commit connection: " + e.toString());
            throw new DatabaseException(e);
        }
        finally {
            try {
                this.ocpds.close(conn);
            }
            catch (SQLException e) {
                this.logger.info("Ignoring SQL Exception while closing resources: " + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLog() throws DatabaseException {
        String sql = "SELECT tname FROM system.tab where tname='" + "xml_logEntries".toUpperCase() + "'";
        boolean tableMissing = false;
        if (this.logConn == null) {
            throw new DatabaseException("No log connection available.");
        }
        try {
            if (this.logConn.isClosed()) {
                this.initLogConnection();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            Statement stmt = this.logConn.createStatement();
            try {
                ResultSet rs = stmt.executeQuery(sql);
                try {
                    if (!rs.next()) {
                        tableMissing = true;
                    }
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
        if (tableMissing) {
            throw new DatabaseException("Table xml_logEntries does not exist.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getAllEntitiesTables(Statement stmt, String ... exclude) throws SQLException {
        String sql = BuildString.buildString("SELECT TNAME FROM SYSTEM.TAB WHERE TNAME LIKE '", "xml_".toUpperCase(), "%", "_entities".toUpperCase(), "'");
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Executing SQL: " + sql);
        }
        ResultSet rs = stmt.executeQuery(sql);
        LinkedList<String> tableNames = new LinkedList<String>();
        try {
            HashSet<String> excludeSet = new HashSet<String>();
            if (exclude != null) {
                excludeSet.addAll(Arrays.asList(exclude));
            }
            StringBuilder sBuilder = new StringBuilder("Exclude: ");
            for (String exc : excludeSet) {
                sBuilder.append(exc);
                sBuilder.append(" ");
            }
            this.logger.fine(sBuilder.toString());
            while (rs.next()) {
                String name = rs.getString("TNAME");
                if (excludeSet.contains(name)) continue;
                tableNames.add(name);
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
        return tableNames;
    }

    private void updateUidLookup(Statement stmt, String ... exclude) throws SQLException, DatabaseException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- updateUidLookup");
        }
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("CREATE OR REPLACE VIEW ");
        sBuilder.append(viewName_uidLookup);
        sBuilder.append(" AS ");
        LinkedList<String> schemas = new LinkedList<String>(this.dbCache.getSchemas());
        schemas.add(schemaTable_schema);
        int i = schemas.size();
        for (String schemaName : schemas) {
            sBuilder.append("SELECT ");
            sBuilder.append("archive_uid");
            sBuilder.append(", '");
            sBuilder.append(schemaName);
            sBuilder.append("' AS ");
            sBuilder.append(colName_schemaName);
            sBuilder.append(" FROM ");
            sBuilder.append(DBConfig.schemaTabName(schemaName).toUpperCase());
            if (--i <= 0) continue;
            sBuilder.append(" UNION ALL ");
        }
        String sql = sBuilder.toString();
        this.logger.fine("Executing: " + sql);
        stmt.executeUpdate(sql);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- updateUidLookup");
        }
    }

    private void initLogConnection() throws DatabaseException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("-> initLogConnection");
        }
        String sql = BuildString.buildString("INSERT INTO ", "xml_logEntries", " (", "Log_Level", ", ", "LogTimeStamp", ", ", "Filename", ", ", "Line", ", ", "Routine", ", ", "SourceObject", ", ", "Host", ", ", "Process", ", ", "Context", ", ", "Thread", ", ", "LogId", ", ", "Priority", ", ", "Uri", ", ", "Audience", ", ", "Alma_Array", ", ", "Antenna", ", ", "dataStrings", ", ", "Message", ", ", "xml", ", ", "steEnv", ") VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        this.logger.finest("Constructing PreparedStatement for Log entries: " + sql);
        try {
            this.logConn = this.ocpds.getLogConnection();
            if (this.logConn == null) {
                this.logger.info("using custom DataSource, couldn't write a log entry to the DB");
            } else {
                this.logConn.setAutoCommit(false);
                this.logStmt = this.logConn.prepareStatement(sql);
                this.logArrayDesc = ArrayDescriptor.createDescriptor((String)"STRING_VARRAY", (Connection)this.logConn);
            }
        }
        catch (SQLException e) {
            this.logger.severe("Could not create PreparedStatement for Log entries. NO LOGS WILL BE STORED IN ORACLE!\n" + e.getMessage());
            this.closeLogConnection();
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- initLogConnection");
        }
    }
}

