/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.oracle;

import alma.archive.database.helpers.BuildString;
import alma.archive.database.helpers.DatabaseHelper;
import alma.archive.database.helpers.SQLCache;
import alma.archive.database.interfaces.DBCursor;
import alma.archive.database.oracle.CursorImpl;
import alma.archive.database.oracle.DBConfig;
import alma.archive.database.oracle.DatabaseCache;
import alma.archive.database.oracle.DatabaseConnectionPool;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ArchiveGeneralException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.access.EntityDirtyException;
import alma.archive.exceptions.access.PermissionDeniedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.DocumentDoesNotExistException;
import alma.archive.exceptions.general.EntityDoesNotExistException;
import alma.archive.exceptions.general.HistoryInconsistencyException;
import alma.archive.exceptions.general.UnknownSchemaException;
import alma.archive.exceptions.syntax.MalformedQueryException;
import alma.archive.wrappers.ArchiveTimeStamp;
import alma.archive.wrappers.DocumentData;
import alma.archive.wrappers.Permissions;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.xdb.XMLType;
import org.jaxen.JaxenException;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.Step;
import org.jaxen.jdom.JDOMXPath;

public class DatabaseReader {
    private static final String tableName_schemas = "xml_schema_entities";
    private static final String viewName_uidLookup = "uid_lookup";
    private static final String tableName_metaInf = "xml_metaInfo";
    private static final String tableName_schemaNamespaces = "xml_schemaNamespaces";
    private static final String tableName_namespaces = "xml_namespaces";
    private static final String colName_uid = "archive_uid";
    private static final String colName_schemaName = "schemaName";
    private static final String colName_version = "version";
    private static final String colName_timestamp = "timestamp";
    private static final String colName_xml = "xml";
    private static final String colName_schemaUid = "schemaUID";
    private static final String colName_owner = "owner";
    private static final String colName_deleted = "deleted";
    private static final String colName_readPermissions = "readPermissions";
    private static final String colName_writePermissions = "writePermissions";
    private static final String colName_hidden = "hidden";
    private static final String colName_dirty = "dirty";
    private static final String colName_paramName = "name";
    private static final String colName_paramValue = "value";
    private static final String colName_prefix = "prefix";
    private static final String colName_namespace = "namespace";
    private static final String colName_virtual = "virtual";
    private static final String GET_SCHEMA_SQL = BuildString.buildString("SELECT ", "schemaName", " FROM ", "uid_lookup", " WHERE ", "archive_uid", "=?");
    private final DatabaseCache dbCache;
    private final SQLCache getSQL;
    private final DatabaseConnectionPool dbConnPool;
    private final Logger logger;

    public DatabaseReader(Logger logger, DatabaseConnectionPool dbConnPool, DatabaseCache cache) throws DatabaseException, ModuleCriticalException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("-> con1");
        }
        this.logger = logger;
        this.dbCache = cache;
        this.getSQL = new SQLCache(BuildString.buildString("SELECT ", colName_xml, ", ", colName_owner, ", ", colName_deleted, ", ", colName_dirty, ", ", colName_hidden, ", ", colName_readPermissions, " FROM %s WHERE ", colName_uid, "=?"), 200);
        this.dbConnPool = dbConnPool;
        this.initSchemaMaps();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("<- con1");
        }
    }

    public static void main(String[] args) throws Exception {
        DatabaseReader dbr = new DatabaseReader(Logger.getAnonymousLogger(), new DatabaseConnectionPool(Logger.getAnonymousLogger()), new DatabaseCache());
        ArrayList<String[]> out = args.length > 4 ? dbr.querySubmissions(Short.parseShort(args[0]), args[1], Boolean.parseBoolean(args[2]), Boolean.parseBoolean(args[3]), args[4]) : dbr.querySubmissions(Short.parseShort(args[0]), args[1], Boolean.parseBoolean(args[2]), Boolean.parseBoolean(args[3]), "");
        for (Object[] objectArray : out) {
            System.out.println(Arrays.toString(objectArray));
        }
        System.out.println("And now something different:");
        for (String[] stringArray : out) {
            for (String s : stringArray) {
                String utf8 = new String(s.getBytes("UTF-8"), "UTF-8");
                System.out.print(utf8 + ", ");
            }
            System.out.println("");
        }
        System.out.println("Found " + out.size() + " matching results.");
    }

    private Connection getConn(String connInfo) throws ModuleCriticalException {
        Connection readConn = null;
        try {
            readConn = this.dbConnPool.getConnection();
        }
        catch (SQLException e) {
            this.logger.severe("Could not initialize JDBC connection to Oracle, exception code: " + e.getErrorCode() + " exception was: " + e.toString());
            throw new ModuleCriticalException(new DatabaseException(e), 1, "Could not initialize JDBC connection to Oracle");
        }
        return readConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(URI uid, String schemaName, boolean dirtyRead, String user) throws EntityDoesNotExistException, ArchiveGeneralException, PermissionDeniedException, EntityDirtyException, ModuleCriticalException {
        String xmlResult;
        block16: {
            xmlResult = null;
            Connection readConn = this.getConn("RD, get(" + String.valueOf(uid) + ")");
            try {
                String sql = this.getSQL.get(DBConfig.schemaTabName(schemaName));
                PreparedStatement stmt = readConn.prepareStatement(sql);
                try {
                    stmt.setString(1, uid == null ? null : uid.toString());
                    this.logger.finest("Executing SQL: " + sql);
                    ResultSet rSet = stmt.executeQuery();
                    try {
                        if (rSet.next()) {
                            if (rSet.getBoolean(colName_deleted) || rSet.getBoolean(colName_hidden)) {
                                throw new EntityDoesNotExistException(String.valueOf(uid) + " schema: " + schemaName);
                            }
                            if (!dirtyRead && rSet.getBoolean(colName_dirty)) {
                                this.logger.warning("Dirty flag of " + uid.toString() + " is equal to 1");
                            }
                            if (schemaName.equals("schema")) {
                                Clob schemaClob = rSet.getClob(colName_xml);
                                xmlResult = schemaClob.getSubString(1L, (int)schemaClob.length());
                            } else {
                                xmlResult = ((XMLType)rSet.getObject(colName_xml)).getStringVal();
                            }
                            xmlResult = xmlResult.trim();
                            break block16;
                        }
                        throw new EntityDoesNotExistException(String.valueOf(uid) + " schema: " + schemaName);
                    }
                    finally {
                        this.close(rSet);
                    }
                }
                finally {
                    this.close(stmt);
                }
            }
            catch (SQLException e) {
                this.logger.warning("SQL command raised exception: " + e.toString());
                throw new DatabaseException(e);
            }
            finally {
                this.close(readConn);
            }
        }
        return xmlResult;
    }

    public String[] queryGet(URI uid, String schemaName, String query, Map<String, String> namespaces, boolean dirtyRead, String user) throws PermissionDeniedException, ArchiveGeneralException, DatabaseException, ModuleCriticalException {
        Connection readConn = this.getConn("RD, queryGet(" + String.valueOf(uid) + ")");
        Statement stmt = null;
        ResultSet rs = null;
        Vector<String> out = new Vector<String>();
        this.logger.finer("Executing query " + query + " on entity " + String.valueOf(uid));
        query = query.replace('\'', '\"');
        try {
            stmt = readConn.createStatement();
            String oracleNSstring = this.constructNamespaceString(namespaces);
            String sql = BuildString.buildString("SELECT value(xmlres) ", colName_xml, ", ", colName_owner, ", ", colName_readPermissions, " FROM ", DBConfig.schemaTabName(schemaName), ", table(xmlsequence(extract(", colName_xml, ", '", query, "', '", oracleNSstring, "'))) xmlres WHERE ", colName_uid, "='", uid == null ? null : uid.toString(), "' AND ", colName_deleted, "=0 AND ", colName_hidden, "=0", dirtyRead ? "" : " AND dirty=0");
            this.logger.finest("Executing SQL: " + sql);
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                do {
                    out.add(((XMLType)rs.getObject(colName_xml)).getStringVal());
                } while (rs.next());
            }
            this.close(rs, stmt, readConn);
        }
        catch (SQLException e) {
            try {
                this.logger.warning("SQL raised exception: " + String.valueOf(e));
                throw new DatabaseException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, stmt, readConn);
                throw throwable;
            }
        }
        return out.toArray(new String[out.size()]);
    }

    public DocumentData status(URI uid, String schemaName, String user) throws ArchiveException {
        DocumentData docData;
        Connection readConn = this.getConn("RD, status(" + String.valueOf(uid) + ")");
        Statement stmt = null;
        ResultSet rs = null;
        Timestamp timestamp = null;
        try {
            stmt = readConn.createStatement();
            String sql = BuildString.buildString("SELECT ", colName_timestamp, ", ", colName_schemaUid, ", ", colName_owner, ", ", colName_readPermissions, ", ", colName_writePermissions, ", ", colName_deleted, ", ", colName_dirty, ", ", colName_hidden, ", ", colName_virtual, " FROM ", DBConfig.schemaTabName(schemaName), " WHERE ", colName_uid, "='", uid == null ? null : uid.toString(), "'");
            this.logger.finer("Executing SQL: " + sql);
            rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                this.logger.info("Entity " + String.valueOf(uid) + "does not exist in table " + DBConfig.schemaTabName(schemaName) + ".");
                throw new EntityDoesNotExistException("Entity " + String.valueOf(uid) + "does not exist in table " + DBConfig.schemaTabName(schemaName) + ".");
            }
            timestamp = rs.getTimestamp(colName_timestamp);
            String schemaUid = rs.getString(colName_schemaUid);
            String owner = rs.getString(colName_owner);
            String readPermissions = rs.getString(colName_readPermissions);
            String writePermissions = rs.getString(colName_writePermissions);
            boolean deleted = rs.getBoolean(colName_deleted);
            boolean dirty = rs.getBoolean(colName_dirty);
            boolean hidden = rs.getBoolean(colName_hidden);
            boolean virtual = rs.getBoolean(colName_virtual);
            try {
                docData = new DocumentData(new ArchiveTimeStamp(timestamp), new URI(schemaUid), owner, new Permissions(readPermissions, writePermissions), hidden, dirty, deleted, virtual, "ADMIN");
            }
            catch (URISyntaxException e1) {
                this.logger.warning("Invalid uid format in entitiy " + String.valueOf(uid) + "refering to schema: " + schemaUid);
                throw new ArchiveException("Invalid uid format in entitiy " + String.valueOf(uid) + "refering to schema: " + schemaUid);
            }
            this.close(rs, stmt, readConn);
        }
        catch (SQLException e) {
            try {
                this.logger.warning("SQL raised exception: " + e.toString());
                throw new DatabaseException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, stmt, readConn);
                throw throwable;
            }
        }
        return docData;
    }

    public URI[] queryInterval(ArchiveTimeStamp timeFrom, ArchiveTimeStamp timeTo, String schema, String pathQuery, String user) throws ArchiveException {
        Vector<URI> uids = new Vector<URI>();
        boolean basicQuery = this.isBasicQuery(pathQuery, schema);
        DBCursor cursor = basicQuery ? this.query(pathQuery, schema, this.getSchemaNamespaces(this.dbCache.getURI(schema)), false, user, timeFrom.toISOString(), timeTo.toISOString()) : this.queryContent(pathQuery, schema, this.getSchemaNamespaces(this.dbCache.getURI(schema)), false, user, timeFrom.toISOString(), timeTo.toISOString());
        while (cursor.hasNext()) {
            uids.add(cursor.next().getUri());
        }
        cursor.close();
        return uids.toArray(new URI[0]);
    }

    public URI[] queryRecent(ArchiveTimeStamp timestamp, String schema, String user) throws ModuleCriticalException, DatabaseException, ArchiveException {
        Connection readConn = this.getConn("RD, queryRecent(" + String.valueOf(timestamp) + ")");
        Statement stmt = null;
        ResultSet rs = null;
        Vector<URI> out = new Vector<URI>();
        String uid = null;
        try {
            stmt = readConn.createStatement();
            String sql = BuildString.buildString("SELECT ", colName_uid, " FROM ", DBConfig.schemaTabName(schema), " WHERE ", colName_deleted, "=0 AND ", colName_hidden, "=0", " AND ", colName_dirty, "=0 AND ", colName_timestamp, " > '", timestamp.toSQLString(), "'");
            this.logger.finest("Executing SQL: " + sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                uid = rs.getString(colName_uid);
                try {
                    out.add(new URI(uid));
                }
                catch (URISyntaxException e) {
                    this.logger.warning("Found incorrect UID in table for schema " + schema + ":" + uid);
                }
            }
            this.close(rs, stmt, readConn);
        }
        catch (SQLException e) {
            try {
                this.logger.info("SQL raised exception: " + e.toString());
                throw new DatabaseException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, stmt, readConn);
                throw throwable;
            }
        }
        return out.toArray(new URI[0]);
    }

    public DBCursor queryContent(String query, String schema, Map<String, String> namespaces, boolean dirtyRead, String user, String timeFrom, String timeTo) throws DatabaseException, MalformedQueryException, ModuleCriticalException {
        JDOMXPath xpath;
        try {
            xpath = new JDOMXPath((String)query);
        }
        catch (JaxenException e) {
            throw new MalformedQueryException("Could not parse query: " + (String)query);
        }
        List locSteps = ((LocationPath)xpath.getRootExpr()).getSteps();
        Step lastStep = (Step)locSteps.get(locSteps.size() - 1);
        query = (String)query + "/..";
        CursorImpl cursor = (CursorImpl)this.query((String)query, schema, namespaces, dirtyRead, user, timeFrom, timeTo);
        cursor.reevaluateLastStep(lastStep);
        return cursor;
    }

    public DBCursor query(String query, String schema, Map<String, String> namespaces, boolean dirtyRead, String user, String timeFrom, String timeTo) throws DatabaseException, MalformedQueryException, ModuleCriticalException {
        Connection readConn = this.getConn("RD, query(" + query + ")");
        Statement stmt = null;
        ResultSet rs = null;
        this.logger.finer("Executing query " + query + " against schema " + schema);
        query = query.replace('\'', '\"');
        try {
            stmt = readConn.createStatement();
            String oracleNSstring = this.constructNamespaceString(namespaces);
            boolean basicQuery = this.isBasicQuery(query, schema);
            String sql = basicQuery ? BuildString.buildString("SELECT ", colName_uid, ", ", colName_xml, ", ", colName_owner, ", ", colName_readPermissions, " FROM ", DBConfig.schemaTabName(schema)) : BuildString.buildString("SELECT ", colName_uid, ", value(xmlres) ", colName_xml, ", ", colName_owner, ", ", colName_readPermissions, " FROM ", DBConfig.schemaTabName(schema), ", table(xmlsequence(extract(", colName_xml, ", '", query, "', '", oracleNSstring, "'))) xmlres");
            sql = BuildString.buildString(sql, " WHERE ", colName_deleted, "=0 AND ", colName_hidden, "=0", dirtyRead ? "" : " AND dirty=0");
            if (timeFrom != null && timeTo != null) {
                sql = BuildString.buildString(sql, " AND (timestamp BETWEEN '", new ArchiveTimeStamp(timeFrom).toSQLString(), "' AND '", new ArchiveTimeStamp(timeTo).toSQLString(), "')");
            }
            this.logger.finest("Executing SQL: " + sql);
            rs = stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            this.logger.info("SQL raised exception: " + e.toString());
            this.close(stmt);
            throw new DatabaseException(e);
        }
        return new CursorImpl(this.logger, this.dbConnPool, rs, readConn, user);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URI[] queryIDs(String query, String schema, Map<String, String> namespaces, boolean dirtyRead, boolean readAll, String user) throws ArchiveException {
        Connection readConn = this.getConn("RD, queryIDs(" + query + ")");
        Statement stmt = null;
        ResultSet rs = null;
        Vector<URI> out = new Vector<URI>();
        String uid = null;
        this.logger.finer("Executing query " + query);
        query = query.replace('\'', '\"');
        try {
            stmt = readConn.createStatement();
            String oracleNSstring = this.constructNamespaceString(namespaces);
            boolean basicQuery = this.isBasicQuery(query, schema);
            String sql = basicQuery ? BuildString.buildString("SELECT ", colName_uid, ", ", colName_owner, ", ", colName_readPermissions, " FROM ", DBConfig.schemaTabName(schema), readAll ? "" : " WHERE 1=1 ") : BuildString.buildString("SELECT ", colName_uid, ", ", colName_owner, ", ", colName_readPermissions, " FROM ", DBConfig.schemaTabName(schema), " WHERE existsNode(", colName_xml, ", '", query, "', '", oracleNSstring, "')=1");
            if (!readAll) {
                sql = BuildString.buildString(sql, " AND ", colName_deleted, "=0 AND ", colName_hidden, "=0");
                if (!dirtyRead) {
                    sql = BuildString.buildString(sql, " AND ", colName_dirty, "=0");
                }
            }
            this.logger.finest("Executing SQL: " + sql);
            rs = stmt.executeQuery(sql);
            while (true) {
                if (!rs.next()) {
                    this.close(rs, stmt, readConn);
                    return out.toArray(new URI[0]);
                }
                uid = rs.getString(colName_uid);
                out.add(new URI(uid));
            }
        }
        catch (SQLException e) {
            try {
                this.logger.info("SQL raised exception: " + e.toString());
                throw new DatabaseException(e);
                catch (URISyntaxException e2) {
                    this.logger.warning("Found uid not conforming to URI syntax: " + uid);
                    throw new ArchiveException(e2);
                }
            }
            catch (Throwable throwable) {
                this.close(rs, stmt, readConn);
                throw throwable;
            }
        }
    }

    public ArrayList<String[]> querySubmissions(short fieldID, String searchString, boolean caseSensitive, boolean containsQuery, String PiCoIfilter) throws ArchiveException {
        String searchSQL;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.getClass().getName(), "querySubmissions", new Object[]{fieldID, searchString, caseSensitive, containsQuery, PiCoIfilter});
        }
        String[] myKeys = new String[]{"author.userid", "author.userid", "title", "prj_code", "s.domain_entity_state"};
        Object filterSQL = "";
        if (!"".equals(PiCoIfilter)) {
            filterSQL = fieldID == 1 || fieldID == 0 ? " and exists (select a.archive_uid from bmmv_obsproposal_authors a where a.archive_uid=prop.archive_uid and a.userid='" + PiCoIfilter + "')" : " AND author.userid='" + PiCoIfilter + "'";
        }
        if (containsQuery) {
            searchString = "%" + (String)searchString + "%";
            searchSQL = " like ?";
        } else {
            searchSQL = "= ?";
        }
        Object fieldSQL = myKeys[fieldID];
        if (!caseSensitive) {
            searchString = ((String)searchString).toLowerCase();
            fieldSQL = "lower(" + (String)fieldSQL + ")";
        }
        String sql = "select distinct  prop.obsproject_archive_uid, proj.title, proj.prj_code, prop.pi_userid, proj.PRJ_TIME_OF_CREATION, prop.datereceived, s.domain_entity_state from bmmv_obsproposal prop   inner join bmmv_obsproject proj     on prop.obsproject_archive_uid = proj.prj_archive_uid   inner join obs_project_status s     on s.obs_project_id = proj.prj_archive_uid   inner join bmmv_obsproposal_authors author     on author.archive_uid = prop.archive_uid   inner join xml_obsproject_entities e     on proj.prj_archive_uid = e.archive_uid where domain_entity_state != 'Canceled' and prop.deleted = 0 AND \n" + (String)fieldSQL + searchSQL + (String)filterSQL;
        if (fieldID == 0) {
            sql = sql + " AND author.authtype = 'PI'";
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Submitting SQL: " + sql);
        }
        Connection readConn = this.getConn("RD, querySubmission(" + (String)fieldSQL + ")");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<String[]> out = new ArrayList<String[]>();
        try {
            stmt = readConn.prepareStatement(sql);
            stmt.setString(1, (String)searchString);
            rs = stmt.executeQuery();
            while (rs.next()) {
                int numColumns = rs.getMetaData().getColumnCount();
                String[] row = new String[numColumns];
                for (int i = 0; i < numColumns; ++i) {
                    String col = rs.getString(i + 1);
                    if (col == null) {
                        col = "";
                    }
                    row[i] = col;
                }
                out.add(row);
            }
            this.close(rs, stmt, readConn);
        }
        catch (Exception e) {
            try {
                throw new DatabaseException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, stmt, readConn);
                throw throwable;
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.getClass().getName(), "querySubmissions");
        }
        return out;
    }

    public Collection<String> queryLog(String timeFrom, String timeTo, int minType, int maxType, String routine, String source, String process, int maxRow) throws ArchiveException {
        Statement stmt = null;
        ResultSet rs = null;
        LinkedList<String> out = new LinkedList<String>();
        String steEnv = System.getenv("LOCATION");
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append(colName_xml);
        sb.append(" FROM xml_logEntries WHERE '");
        sb.append(new ArchiveTimeStamp(timeFrom).toSQLString());
        sb.append("'<");
        sb.append("LogTimeStamp");
        sb.append(" AND ");
        sb.append("LogTimeStamp");
        sb.append("<'");
        sb.append(new ArchiveTimeStamp(timeTo).toSQLString());
        sb.append("' AND (");
        sb.append("Log_Level");
        sb.append(" BETWEEN '");
        sb.append(minType);
        sb.append("' AND '");
        sb.append(maxType);
        sb.append("')");
        if (routine != null && !routine.equals("*")) {
            sb.append(" AND ");
            sb.append("Routine");
            sb.append(" = '");
            sb.append(routine);
            sb.append("'");
        }
        if (source != null && !source.equals("*")) {
            sb.append(" AND ");
            sb.append("SourceObject");
            sb.append(" = '");
            sb.append(source);
            sb.append("'");
        }
        if (process != null && !process.equals("*")) {
            sb.append(" AND ");
            sb.append("Process");
            sb.append(" = '");
            sb.append(process);
            sb.append("'");
        }
        if (steEnv != null && !steEnv.equals("")) {
            sb.append(" AND ");
            sb.append("steEnv");
            sb.append(" = '");
            sb.append(steEnv);
            sb.append("'");
        }
        sb.append(" ORDER BY ");
        sb.append("LogTimeStamp");
        String sql = sb.toString();
        sb = null;
        Connection readConn = null;
        try {
            readConn = this.dbConnPool.getLogConnection();
            stmt = readConn.createStatement();
            rs = stmt.executeQuery(sql);
            for (int logCount = 0; logCount < maxRow && rs.next(); ++logCount) {
                out.add(rs.getString(1));
            }
            this.close(rs, stmt, readConn);
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, stmt, readConn);
                throw throwable;
            }
        }
        return out;
    }

    public String getSchemaName(URI schema) throws UnknownSchemaException, DatabaseException, ModuleCriticalException {
        Statement stmt = null;
        ResultSet rs = null;
        String ret = this.dbCache.getSchema(schema);
        if (ret == null) {
            Connection readConn = this.getConn("RD, getSchemaName(" + String.valueOf(schema) + ")");
            try {
                stmt = readConn.createStatement();
                String sql = BuildString.buildString("SELECT ", colName_schemaName, " FROM ", tableName_schemas, " WHERE ", colName_uid, "='", schema == null ? null : schema.toString(), "'");
                this.logger.finer("Executing SQL: " + sql);
                rs = stmt.executeQuery(sql);
                if (!rs.next()) {
                    throw new UnknownSchemaException(schema.toString());
                }
                ret = rs.getString(colName_schemaName);
                this.close(rs, stmt, readConn);
            }
            catch (SQLException e) {
                try {
                    this.logger.warning("SQL raised exception: " + e.toString());
                    throw new DatabaseException(e);
                }
                catch (Throwable throwable) {
                    this.close(rs, stmt, readConn);
                    throw throwable;
                }
            }
        }
        return ret;
    }

    public int getSchemaVersion(URI schemaUri) throws DatabaseException, ModuleCriticalException {
        ResultSet rs;
        Statement stmt;
        Connection readConn;
        block5: {
            readConn = this.getConn("RD, getSchemaVersion(" + String.valueOf(schemaUri) + ")");
            stmt = null;
            rs = null;
            String sql = BuildString.buildString("SELECT ", colName_version, " FROM ", tableName_schemas, " WHERE ", colName_uid, "='", schemaUri == null ? null : schemaUri.toString(), "'");
            this.logger.finest("Executing SQL: " + sql);
            stmt = readConn.createStatement();
            rs = stmt.executeQuery(sql);
            if (!rs.next()) break block5;
            int n = rs.getInt(colName_version);
            this.close(rs, stmt, readConn);
            return n;
        }
        try {
            int n = 0;
            this.close(rs, stmt, readConn);
            return n;
        }
        catch (SQLException e) {
            try {
                this.logger.warning("Could not access schema table: " + e.toString());
                throw new DatabaseException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, stmt, readConn);
                throw throwable;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public URI getSchemaURI(String schema, int version) throws UnknownSchemaException, DatabaseException, ModuleCriticalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean ping() {
        try {
            return this.getMetaParamValue("archiveID") != null;
        }
        catch (Throwable e) {
            this.logger.severe("Could not read archive ID.\n" + DatabaseHelper.traceToString(e));
            return false;
        }
    }

    protected String constructNamespaceString(Map<String, String> namespaces) {
        String namespacesStr = null;
        if (namespaces == null) {
            namespacesStr = "";
        } else {
            StringBuilder out = new StringBuilder();
            for (Map.Entry<String, String> entry : namespaces.entrySet()) {
                out.append(" xmlns:");
                out.append(entry.getKey());
                out.append("=\"");
                out.append(entry.getValue());
                out.append('\"');
            }
            namespacesStr = out.toString();
        }
        return namespacesStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> getSchemaNamespaces(URI schemaUri) throws DatabaseException, ModuleCriticalException {
        Connection readConn = this.getConn("RD, getSchemaNamespaces(" + String.valueOf(schemaUri) + ")");
        Statement stmt = null;
        ResultSet rs = null;
        HashMap<String, String> namespaces = new HashMap<String, String>();
        String sql = BuildString.buildString("SELECT ns.", colName_prefix, ", ", colName_namespace, " FROM ", tableName_namespaces, " ns");
        if (schemaUri != null) {
            sql = BuildString.buildString(sql, " , ", tableName_schemaNamespaces, " sns WHERE ns.", "prefix = sns.", colName_prefix, " AND ", colName_schemaUid, "='", schemaUri.toString(), "'");
        }
        this.logger.finest("Executing SQL: " + sql);
        try {
            stmt = readConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String prefix = rs.getString(colName_prefix);
                String namespace = rs.getString(colName_namespace);
                namespaces.put(prefix, namespace);
            }
        }
        catch (Throwable e) {
            this.logger.warning("Could not retrieve namespaces for schema " + String.valueOf(schemaUri));
        }
        finally {
            this.close(rs, stmt, readConn);
        }
        return namespaces;
    }

    public boolean namespaceExists(URI namespace) throws DatabaseException, ModuleCriticalException {
        Connection readConn = this.getConn("RD, namespaceExists(" + String.valueOf(namespace) + ")");
        Statement stmt = null;
        ResultSet rs = null;
        String sql = BuildString.buildString("SELECT ", colName_prefix, " FROM ", tableName_namespaces, " WHERE ", colName_namespace, "='", namespace == null ? null : namespace.toString(), "'");
        this.logger.finest("Executing SQL: " + sql);
        try {
            stmt = readConn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            this.logger.warning("Could not access namespace " + String.valueOf(namespace));
            throw new DatabaseException(e);
        }
        finally {
            this.close(rs, stmt, readConn);
        }
    }

    public void close() throws DatabaseException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getSchema(URI uid) throws ModuleCriticalException, SQLException, EntityDoesNotExistException, URISyntaxException {
        String schema = null;
        Connection readConn = this.getConn("RD, getURI " + String.valueOf(uid));
        try {
            PreparedStatement stmt = readConn.prepareStatement(GET_SCHEMA_SQL);
            try {
                block10: {
                    stmt.setString(1, uid == null ? null : uid.toString());
                    ResultSet rSet = stmt.executeQuery();
                    try {
                        if (rSet.next()) {
                            schema = rSet.getString(1);
                            break block10;
                        }
                        throw new EntityDoesNotExistException(uid.toString());
                    }
                    finally {
                        this.close(rSet);
                    }
                }
                this.logger.finest("Looking up uid " + String.valueOf(uid) + " schema " + schema);
            }
            finally {
                this.close(stmt);
            }
        }
        finally {
            this.close(readConn);
        }
        return schema;
    }

    protected boolean checkSchemaConsistency(String schemaName, URI schemaURI) throws DatabaseException, DocumentDoesNotExistException, ModuleCriticalException {
        Connection readConn = this.getConn("RD, checkSchemaConsistency(" + schemaName + ")");
        Statement stmt = null;
        ResultSet rs = null;
        String sql = null;
        try {
            stmt = readConn.createStatement();
            sql = BuildString.buildString("SELECT ", colName_timestamp, " FROM ", tableName_schemas, " WHERE ", colName_uid, "='", schemaURI.toString(), "'");
            this.logger.finest("Executing SQL: " + sql);
            rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                throw new DocumentDoesNotExistException(schemaURI.toString());
            }
            String time = new ArchiveTimeStamp(rs.getTimestamp(colName_timestamp)).toSQLString();
            sql = BuildString.buildString("SELECT ", colName_uid, " FROM ", tableName_schemas, " WHERE ", colName_schemaName, "='", schemaName, "' AND ", colName_timestamp, "> '", time, "'");
            this.logger.finest("Executing SQL: " + sql);
            rs = stmt.executeQuery(sql);
            boolean found = rs.next();
            boolean bl = !found;
            this.close(rs, stmt, readConn);
            return bl;
        }
        catch (SQLException e) {
            try {
                this.logger.info("SQL raised exception: " + sql);
                throw new DatabaseException(e.toString());
            }
            catch (Throwable throwable) {
                this.close(rs, stmt, readConn);
                throw throwable;
            }
        }
    }

    protected void checkTimestampConsistency(URI uid, String schemaName, ArchiveTimeStamp timeStamp) throws HistoryInconsistencyException, EntityDoesNotExistException, DatabaseException, ModuleCriticalException {
        Connection readConn = this.getConn("RD, checkTimestampConsistency(" + String.valueOf(uid) + ")");
        Statement stmt = null;
        String sql = null;
        ResultSet rs = null;
        try {
            sql = BuildString.buildString("SELECT ", colName_timestamp, " FROM ", DBConfig.schemaTabName(schemaName), " WHERE ", colName_uid, "='", uid == null ? null : uid.toString(), "'");
            stmt = readConn.createStatement();
            rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                throw new EntityDoesNotExistException(uid.toString());
            }
            Timestamp dbTimeStamp = rs.getTimestamp(colName_timestamp);
            if (!timeStamp.equals(dbTimeStamp)) {
                throw new HistoryInconsistencyException("Timestamp mismatch! DB timestamp: " + String.valueOf(dbTimeStamp) + ", doc timestamp: " + timeStamp.toISOString());
            }
            this.close(rs, stmt, readConn);
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, stmt, readConn);
                throw throwable;
            }
        }
    }

    @Deprecated
    protected void checkPermission(URI uid, String schemaName, String user, boolean writePermission) throws EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        String docPermissions;
        String docOwner;
        Connection readConn = this.getConn("RD, checkPermission(" + String.valueOf(uid) + ")");
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = readConn.createStatement();
            String sql = BuildString.buildString("SELECT ", colName_schemaName, " FROM ", viewName_uidLookup, " WHERE ", colName_uid, "='", uid == null ? null : uid.toString(), "'");
            this.logger.finest("Executing SQL: " + sql);
            rs = stmt.executeQuery(sql);
            String actSchemaName = null;
            if (!rs.next()) {
                throw new EntityDoesNotExistException(uid.toString());
            }
            actSchemaName = rs.getString(1);
            sql = BuildString.buildString("SELECT ", colName_owner, ", ", writePermission ? colName_writePermissions : colName_readPermissions, " FROM ", DBConfig.schemaTabName(actSchemaName), " WHERE ", colName_uid, "='", uid == null ? null : uid.toString(), "'");
            this.logger.finest("Executing SQL: " + sql);
            rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                throw new DatabaseException(uid.toString() + " is in lookup table, but not in schema table for " + actSchemaName);
            }
            docOwner = rs.getString(colName_owner);
            docPermissions = rs.getString(writePermission ? colName_writePermissions : colName_readPermissions);
            this.close(rs, stmt, readConn);
        }
        catch (SQLException e) {
            try {
                this.logger.warning("SQL raised exception: " + e.toString());
                throw new DatabaseException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, stmt, readConn);
                throw throwable;
            }
        }
        if (!DatabaseHelper.checkAccessPermissions(user, docPermissions, docOwner)) {
            this.logger.info("Permission for user " + user + " to " + (writePermission ? "write" : "read") + " document " + String.valueOf(uid) + " denied");
            throw new PermissionDeniedException(uid.toString());
        }
    }

    protected boolean exists(Connection conn, URI uid) throws EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        boolean exists = true;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            String sql = BuildString.buildString("SELECT ", colName_schemaName, " FROM ", viewName_uidLookup, " WHERE ", colName_uid, "='", uid == null ? null : uid.toString(), "'");
            this.logger.finest("Executing SQL: " + sql);
            rs = stmt.executeQuery(sql);
            exists = rs.next();
            this.close(rs);
            this.close(stmt);
        }
        catch (SQLException e) {
            try {
                this.logger.warning("SQL raised exception: " + e.toString());
                throw new DatabaseException(e);
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(stmt);
                throw throwable;
            }
        }
        return exists;
    }

    protected boolean existsSchema(String schemaName) {
        return this.dbCache.getURI(schemaName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSchemaMaps() throws DatabaseException, ModuleCriticalException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("-> initSchemaMaps");
        }
        this.dbCache.clear();
        Connection readConn = this.getConn("RD, initSchemaMaps");
        String sql = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = readConn.createStatement();
            sql = BuildString.buildString("WITH actSchemas AS ( SELECT ", colName_schemaName, " actName", ", MAX(", colName_timestamp, ") actTime FROM ", tableName_schemas, " GROUP BY ", colName_schemaName, ") SELECT ", colName_uid, ", actName FROM actSchemas, ", tableName_schemas, " WHERE actName=", colName_schemaName, " and actTime=", colName_timestamp);
            this.logger.finest("Executing SQL: " + sql);
            rs = stmt.executeQuery(sql);
            String schemaURI = null;
            while (rs.next()) {
                String schemaName = rs.getString("actName");
                try {
                    schemaURI = rs.getString(colName_uid);
                    this.dbCache.put(new URI(schemaURI), schemaName);
                    this.logger.finest("Found schema: " + schemaName + " with UID " + schemaURI);
                }
                catch (URISyntaxException e1) {
                    this.logger.severe("UID of schema " + schemaName + " does not respect URI syntax: " + schemaURI);
                }
            }
            this.close(rs, stmt, readConn);
        }
        catch (SQLException e) {
            this.logger.severe("Could not initialize schema name map: " + e.getMessage());
        }
        finally {
            this.close(rs, stmt, readConn);
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- initSchemaMaps");
        }
    }

    protected String getMetaParamValue(String paramName) throws DatabaseException, ModuleCriticalException {
        Object msg = "DatabaseReader.getMetaParamValue:";
        long time1 = System.nanoTime();
        Connection readConn = this.getConn("RD, getMetaParamValue(" + paramName + ")");
        long time2 = System.nanoTime();
        msg = (String)msg + " Connect (" + (double)(time2 - time1) / 1000000.0 + "[ms]).";
        Statement stmt = null;
        String out = null;
        ResultSet rs = null;
        try {
            String sql = BuildString.buildString("SELECT ", colName_paramValue, " FROM ", tableName_metaInf, " WHERE ", colName_paramName, "='", paramName, "'");
            this.logger.finest("Executing SQL: " + sql);
            time1 = System.nanoTime();
            msg = (String)msg + " Create Query (" + (double)(time1 - time2) / 1000000.0 + "[ms]).";
            stmt = readConn.createStatement();
            rs = stmt.executeQuery(sql);
            time2 = System.nanoTime();
            msg = (String)msg + " Execute Query (" + (double)(time2 - time1) / 1000000.0 + "[ms]).";
            if (rs.next()) {
                out = rs.getString(colName_paramValue);
            } else {
                this.logger.info("Could not find parameter value for parameter " + paramName + " in table xml_metaInfo");
            }
            time1 = System.nanoTime();
            msg = (String)msg + " Retrieve Results (" + (double)(time1 - time2) / 1000000.0 + "[ms]).";
            this.close(rs, stmt, readConn);
        }
        catch (SQLException e) {
            try {
                this.logger.info("Oracle error: " + e.toString());
                throw new DatabaseException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, stmt, readConn);
                time2 = System.nanoTime();
                msg = (String)msg + " Disconnect (" + (double)(time2 - time1) / 1000000.0 + "[ms]).";
                this.logger.fine((String)msg);
                throw throwable;
            }
        }
        time2 = System.nanoTime();
        msg = (String)msg + " Disconnect (" + (double)(time2 - time1) / 1000000.0 + "[ms]).";
        this.logger.fine((String)msg);
        return out;
    }

    protected String getLastUIDstored() throws DatabaseException, ModuleCriticalException {
        Connection readConn = this.getConn("RD, get(lastUID)");
        Statement stmt = null;
        String out = null;
        ResultSet rs = null;
        try {
            String sql = BuildString.buildString("SELECT ", "uid_seq", ".", "nextval", " FROM DUAL");
            this.logger.finest("Executing SQL: " + sql);
            stmt = readConn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                out = rs.getString("nextval");
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Retrieved " + out + " as decimal value for UIDs from SEQUENCEuid_seq");
                }
            } else {
                this.logger.severe("Could not access SEQUENCE value for uid_seq");
            }
            this.close(rs, stmt, readConn);
        }
        catch (SQLException e) {
            try {
                this.logger.info("Oracle error: " + e.toString());
                throw new DatabaseException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, stmt, readConn);
                throw throwable;
            }
        }
        return out;
    }

    private boolean isBasicQuery(String query, String schema) throws MalformedQueryException {
        if (!query.startsWith("/")) {
            throw new MalformedQueryException("XPath query has to start with \"/\": " + query);
        }
        boolean basicQuery = false;
        if (query.substring(1).indexOf(47) < 0 && query.indexOf(64) < 0) {
            String afterPrefix = query.substring(1);
            if (afterPrefix.indexOf(58) >= 0) {
                afterPrefix = afterPrefix.substring(afterPrefix.indexOf(58) + 1);
            }
            if (afterPrefix.equals(schema) || afterPrefix.equals("*")) {
                basicQuery = true;
            }
        }
        return basicQuery;
    }

    private void close(ResultSet rs, Statement stmt, Connection conn) {
        this.close(rs);
        this.close(stmt);
        this.close(conn);
    }

    private void close(AutoCloseable ac) {
        try {
            if (ac != null) {
                ac.close();
            }
        }
        catch (Exception e) {
            this.logger.warning(e.getMessage());
        }
    }

    private void close(Connection conn) {
        try {
            if (conn != null) {
                this.dbConnPool.close(conn);
            }
        }
        catch (SQLException e) {
            this.logger.warning(e.toString());
        }
    }
}

