/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.oracle;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class DatabaseCache {
    private final Map<URI, String> uri2schemaName = new HashMap<URI, String>();
    private final Map<String, URI> schemaName2uri = new HashMap<String, URI>();

    public void setLogger(Logger logger) {
    }

    public synchronized void clear() {
        this.uri2schemaName.clear();
        this.schemaName2uri.clear();
    }

    public synchronized void put(URI uri, String schema) {
        this.uri2schemaName.put(uri, schema);
        this.schemaName2uri.put(schema, uri);
    }

    public synchronized URI getURI(String schema) {
        return this.schemaName2uri.get(schema);
    }

    public synchronized String getSchema(URI uri) {
        return this.uri2schemaName.get(uri);
    }

    public synchronized void remove(String schema) {
        URI uri = this.schemaName2uri.get(schema);
        if (uri != null) {
            this.schemaName2uri.remove(schema);
            this.uri2schemaName.remove(uri);
        }
    }

    public synchronized Set<String> getSchemas() {
        return this.schemaName2uri.keySet();
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder("DatabaseCache: ");
        for (Map.Entry<String, URI> entry : this.schemaName2uri.entrySet()) {
            sBuilder.append(entry.getKey());
            sBuilder.append("=");
            sBuilder.append(entry.getValue());
            sBuilder.append(" ");
        }
        return sBuilder.toString();
    }
}

