/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.helpers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

public class SQLCache {
    private final Map<String, String> cache;
    private final int maxSize;
    private final String sqlTemplate;
    private final Random rnd;

    public SQLCache(String sqlTemplate, int maxSize) {
        this.cache = new HashMap<String, String>(maxSize);
        this.maxSize = maxSize;
        this.sqlTemplate = sqlTemplate;
        this.rnd = new Random();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        String sql = null;
        Map<String, String> map = this.cache;
        synchronized (map) {
            sql = this.cache.get(key);
            if (sql == null) {
                sql = String.format(this.sqlTemplate, key);
                if (this.cache.size() >= this.maxSize) {
                    Iterator<String> iterator = this.cache.keySet().iterator();
                    for (int index = Math.abs(this.rnd.nextInt() % this.maxSize); index > 1; --index) {
                        iterator.next();
                    }
                    this.cache.remove(iterator.next());
                }
                this.cache.put(key, sql);
            }
        }
        return sql;
    }
}

