/*
 * Decompiled with CFR 0.152.
 */
package alma.hla.runtime.obsprep.util;

import alma.hla.runtime.obsprep.util.XmlConversionException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.castor.mapping.BindingType;
import org.exolab.castor.core.exceptions.CastorException;
import org.exolab.castor.xml.ClassDescriptorResolverFactory;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.XMLClassDescriptorResolver;

public class XmlMarshaller {
    private static final XMLClassDescriptorResolver cdr = (XMLClassDescriptorResolver)ClassDescriptorResolverFactory.createClassDescriptorResolver((BindingType)BindingType.XML);
    protected StringWriter w;
    protected Marshaller m;

    public XmlMarshaller() throws XmlConversionException {
        try {
            this.w = new StringWriter();
            this.m = new Marshaller((Writer)this.w);
            this.m.setValidation(false);
            this.m.setResolver(cdr);
            this.configure(this.m);
        }
        catch (IOException exc) {
            throw new XmlConversionException(exc.getMessage(), exc);
        }
    }

    protected void configure(Marshaller m) {
        m.setNamespaceMapping("ent", "Alma/CommonEntity");
        m.setNamespaceMapping("val", "Alma/ValueTypes");
        m.setNamespaceMapping("prp", "Alma/ObsPrep/ObsProposal");
        m.setNamespaceMapping("orv", "Alma/ObsPrep/ObsReview");
        m.setNamespaceMapping("ps", "Alma/ObsPrep/ProjectStatus");
        m.setNamespaceMapping("oat", "Alma/ObsPrep/ObsAttachment");
        m.setNamespaceMapping("prj", "Alma/ObsPrep/ObsProject");
        m.setNamespaceMapping("sbl", "Alma/ObsPrep/SchedBlock");
    }

    public Marshaller getMarshaller() {
        return this.m;
    }

    public String marshalToString(Object object) throws XmlConversionException {
        try {
            this.w.getBuffer().setLength(0);
            this.m.marshal(object);
            return this.w.toString();
        }
        catch (CastorException exc) {
            throw new XmlConversionException(exc.getMessage(), exc);
        }
    }
}

