/*
 * Decompiled with CFR 0.152.
 */
package alma.hla.runtime;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DatamodelInstanceChecker
extends DefaultHandler {
    private String datamodelVersion;
    private String schemaVersion;
    private String rootElemName;

    public String getDatamodelVersion(StringReader rdr) throws IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            this.datamodelVersion = "-1";
            this.schemaVersion = "-1";
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new InputSource(rdr), (DefaultHandler)this);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error while searching for datamodelVersion");
        }
        rdr.close();
        System.out.println("Datamodel version = " + this.datamodelVersion);
        System.out.println("Schema version = " + this.schemaVersion);
        this.rootElemName = null;
        if (this.schemaVersion != "-1") {
            this.datamodelVersion = this.schemaVersion;
        }
        return this.datamodelVersion;
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        String eName = lName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (this.rootElemName == null) {
            this.rootElemName = eName;
        } else if (eName.endsWith(this.rootElemName + "Entity") && attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String aName = attrs.getLocalName(i);
                if ("".equals(aName)) {
                    aName = attrs.getQName(i);
                }
                if (aName.equals("datamodelVersion")) {
                    this.datamodelVersion = attrs.getValue(i);
                }
                if (!aName.equals("schemaVersion")) continue;
                this.schemaVersion = attrs.getValue(i);
            }
        }
    }
}

