/*
 * Decompiled with CFR 0.152.
 */
package alma.entity.xmlbinding.schedblock;

import alma.entity.xmlbinding.obsattachment.ObsAttachmentRefT;
import alma.entity.xmlbinding.schedblock.FieldSourceTChoice;
import alma.entity.xmlbinding.schedblock.QuerySourceT;
import alma.entity.xmlbinding.schedblock.ReferenceT;
import alma.entity.xmlbinding.schedblock.SourcePropertyT;
import alma.entity.xmlbinding.schedblock.types.FieldSourceTSolarSystemObjectType;
import alma.entity.xmlbinding.valuetypes.AngleT;
import alma.entity.xmlbinding.valuetypes.AngularVelocityT;
import alma.entity.xmlbinding.valuetypes.SkyCoordinatesT;
import alma.entity.xmlbinding.valuetypes.VelocityT;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class FieldSourceT
implements Serializable {
    private String entityPartId;
    private String almatype = "APDM::FieldSource";
    private FieldSourceTSolarSystemObjectType solarSystemObject = FieldSourceTSolarSystemObjectType.valueOf("Unspecified");
    private SkyCoordinatesT sourceCoordinates;
    private String sourceName;
    private VelocityT sourceVelocity;
    private String sourceEphemeris;
    private AngularVelocityT pMRA;
    private AngularVelocityT pMDec;
    private boolean nonSiderealMotion = false;
    private boolean _hasnonSiderealMotion;
    private AngleT parallax;
    private String name;
    private boolean isQuery = false;
    private boolean _hasisQuery;
    private String ephemerisFileName;
    private FieldSourceTChoice fieldSourceTChoice;
    private QuerySourceT querySource;
    private List<ReferenceT> referenceList;
    private List<SourcePropertyT> sourcePropertyList;
    private ObsAttachmentRefT imageRef;

    public FieldSourceT() {
        this.setAlmatype("APDM::FieldSource");
        this.setSolarSystemObject(FieldSourceTSolarSystemObjectType.valueOf("Unspecified"));
        this.referenceList = new ArrayList<ReferenceT>();
        this.sourcePropertyList = new ArrayList<SourcePropertyT>();
    }

    public void addReference(ReferenceT vReference) throws IndexOutOfBoundsException {
        if (this.referenceList.size() >= 2) {
            throw new IndexOutOfBoundsException("addReference has a maximum of 2");
        }
        this.referenceList.add(vReference);
    }

    public void addReference(int index, ReferenceT vReference) throws IndexOutOfBoundsException {
        if (this.referenceList.size() >= 2) {
            throw new IndexOutOfBoundsException("addReference has a maximum of 2");
        }
        this.referenceList.add(index, vReference);
    }

    public void addSourceProperty(SourcePropertyT vSourceProperty) throws IndexOutOfBoundsException {
        this.sourcePropertyList.add(vSourceProperty);
    }

    public void addSourceProperty(int index, SourcePropertyT vSourceProperty) throws IndexOutOfBoundsException {
        this.sourcePropertyList.add(index, vSourceProperty);
    }

    public void deleteIsQuery() {
        this._hasisQuery = false;
    }

    public void deleteNonSiderealMotion() {
        this._hasnonSiderealMotion = false;
    }

    public Enumeration<? extends ReferenceT> enumerateReference() {
        return Collections.enumeration(this.referenceList);
    }

    public Enumeration<? extends SourcePropertyT> enumerateSourceProperty() {
        return Collections.enumeration(this.sourcePropertyList);
    }

    public String getAlmatype() {
        return this.almatype;
    }

    public String getEntityPartId() {
        return this.entityPartId;
    }

    public String getEphemerisFileName() {
        return this.ephemerisFileName;
    }

    public FieldSourceTChoice getFieldSourceTChoice() {
        return this.fieldSourceTChoice;
    }

    public ObsAttachmentRefT getImageRef() {
        return this.imageRef;
    }

    public boolean getIsQuery() {
        return this.isQuery;
    }

    public String getName() {
        return this.name;
    }

    public boolean getNonSiderealMotion() {
        return this.nonSiderealMotion;
    }

    public AngularVelocityT getPMDec() {
        return this.pMDec;
    }

    public AngularVelocityT getPMRA() {
        return this.pMRA;
    }

    public AngleT getParallax() {
        return this.parallax;
    }

    public QuerySourceT getQuerySource() {
        return this.querySource;
    }

    public ReferenceT getReference(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.referenceList.size()) {
            throw new IndexOutOfBoundsException("getReference: Index value '" + index + "' not in range [0.." + (this.referenceList.size() - 1) + "]");
        }
        return this.referenceList.get(index);
    }

    public ReferenceT[] getReference() {
        ReferenceT[] array = new ReferenceT[]{};
        return this.referenceList.toArray(array);
    }

    public int getReferenceCount() {
        return this.referenceList.size();
    }

    public FieldSourceTSolarSystemObjectType getSolarSystemObject() {
        return this.solarSystemObject;
    }

    public SkyCoordinatesT getSourceCoordinates() {
        return this.sourceCoordinates;
    }

    public String getSourceEphemeris() {
        return this.sourceEphemeris;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public SourcePropertyT getSourceProperty(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.sourcePropertyList.size()) {
            throw new IndexOutOfBoundsException("getSourceProperty: Index value '" + index + "' not in range [0.." + (this.sourcePropertyList.size() - 1) + "]");
        }
        return this.sourcePropertyList.get(index);
    }

    public SourcePropertyT[] getSourceProperty() {
        SourcePropertyT[] array = new SourcePropertyT[]{};
        return this.sourcePropertyList.toArray(array);
    }

    public int getSourcePropertyCount() {
        return this.sourcePropertyList.size();
    }

    public VelocityT getSourceVelocity() {
        return this.sourceVelocity;
    }

    public boolean hasIsQuery() {
        return this._hasisQuery;
    }

    public boolean hasNonSiderealMotion() {
        return this._hasnonSiderealMotion;
    }

    public boolean isIsQuery() {
        return this.isQuery;
    }

    public boolean isNonSiderealMotion() {
        return this.nonSiderealMotion;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends ReferenceT> iterateReference() {
        return this.referenceList.iterator();
    }

    public Iterator<? extends SourcePropertyT> iterateSourceProperty() {
        return this.sourcePropertyList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllReference() {
        this.referenceList.clear();
    }

    public void removeAllSourceProperty() {
        this.sourcePropertyList.clear();
    }

    public boolean removeReference(ReferenceT vReference) {
        boolean removed = this.referenceList.remove(vReference);
        return removed;
    }

    public ReferenceT removeReferenceAt(int index) {
        ReferenceT obj = this.referenceList.remove(index);
        return obj;
    }

    public boolean removeSourceProperty(SourcePropertyT vSourceProperty) {
        boolean removed = this.sourcePropertyList.remove(vSourceProperty);
        return removed;
    }

    public SourcePropertyT removeSourcePropertyAt(int index) {
        SourcePropertyT obj = this.sourcePropertyList.remove(index);
        return obj;
    }

    public void setAlmatype(String almatype) {
        this.almatype = almatype;
    }

    public void setEntityPartId(String entityPartId) {
        this.entityPartId = entityPartId;
    }

    public void setEphemerisFileName(String ephemerisFileName) {
        this.ephemerisFileName = ephemerisFileName;
    }

    public void setFieldSourceTChoice(FieldSourceTChoice fieldSourceTChoice) {
        this.fieldSourceTChoice = fieldSourceTChoice;
    }

    public void setImageRef(ObsAttachmentRefT imageRef) {
        this.imageRef = imageRef;
    }

    public void setIsQuery(boolean isQuery) {
        this.isQuery = isQuery;
        this._hasisQuery = true;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNonSiderealMotion(boolean nonSiderealMotion) {
        this.nonSiderealMotion = nonSiderealMotion;
        this._hasnonSiderealMotion = true;
    }

    public void setPMDec(AngularVelocityT pMDec) {
        this.pMDec = pMDec;
    }

    public void setPMRA(AngularVelocityT pMRA) {
        this.pMRA = pMRA;
    }

    public void setParallax(AngleT parallax) {
        this.parallax = parallax;
    }

    public void setQuerySource(QuerySourceT querySource) {
        this.querySource = querySource;
    }

    public void setReference(int index, ReferenceT vReference) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.referenceList.size()) {
            throw new IndexOutOfBoundsException("setReference: Index value '" + index + "' not in range [0.." + (this.referenceList.size() - 1) + "]");
        }
        this.referenceList.set(index, vReference);
    }

    public void setReference(ReferenceT[] vReferenceArray) {
        this.referenceList.clear();
        for (int i = 0; i < vReferenceArray.length; ++i) {
            this.referenceList.add(vReferenceArray[i]);
        }
    }

    public void setSolarSystemObject(FieldSourceTSolarSystemObjectType solarSystemObject) {
        this.solarSystemObject = solarSystemObject;
    }

    public void setSourceCoordinates(SkyCoordinatesT sourceCoordinates) {
        this.sourceCoordinates = sourceCoordinates;
    }

    public void setSourceEphemeris(String sourceEphemeris) {
        this.sourceEphemeris = sourceEphemeris;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void setSourceProperty(int index, SourcePropertyT vSourceProperty) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.sourcePropertyList.size()) {
            throw new IndexOutOfBoundsException("setSourceProperty: Index value '" + index + "' not in range [0.." + (this.sourcePropertyList.size() - 1) + "]");
        }
        this.sourcePropertyList.set(index, vSourceProperty);
    }

    public void setSourceProperty(SourcePropertyT[] vSourcePropertyArray) {
        this.sourcePropertyList.clear();
        for (int i = 0; i < vSourcePropertyArray.length; ++i) {
            this.sourcePropertyList.add(vSourcePropertyArray[i]);
        }
    }

    public void setSourceVelocity(VelocityT sourceVelocity) {
        this.sourceVelocity = sourceVelocity;
    }

    public static FieldSourceT unmarshalFieldSourceT(Reader reader) throws MarshalException, ValidationException {
        return (FieldSourceT)Unmarshaller.unmarshal(FieldSourceT.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

