/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.exceptions;

import alma.ACSErr.Completion;
import alma.ACSErr.ErrorTrace;
import alma.acs.exceptions.AcsJException;
import alma.acs.exceptions.CorbaExceptionConverter;
import alma.acs.exceptions.DefaultAcsJException;
import alma.acs.util.UTCUtility;
import java.util.Properties;

public class AcsJCompletion {
    private int m_type;
    private int m_code;
    private long m_timestamp;
    private AcsJException m_jex;
    protected Properties m_properties;

    protected AcsJCompletion() {
    }

    protected AcsJCompletion(int type, int code) {
        this.init(type, code);
    }

    protected AcsJCompletion(AcsJException acsJEx) {
        this.init(acsJEx);
    }

    protected void init(int type, int code) {
        this.m_type = type;
        this.m_code = code;
        this.m_timestamp = System.currentTimeMillis();
        this.m_jex = null;
    }

    protected void init(AcsJException acsJEx) {
        if (acsJEx == null) {
            throw new NullPointerException("argument 'acsJEx' must not be null!");
        }
        this.m_type = acsJEx.getErrorType();
        this.m_code = acsJEx.getErrorCode();
        this.m_timestamp = acsJEx.getTimestampMillis();
        this.m_jex = acsJEx;
    }

    public int getType() {
        return this.m_type;
    }

    public int getCode() {
        return this.m_code;
    }

    public long getTimeStamp() {
        return this.m_timestamp;
    }

    public boolean isError() {
        return this.m_jex != null;
    }

    public AcsJException getAcsJException() {
        return this.m_jex;
    }

    public Completion toCorbaCompletion() {
        Completion corbaCompl = new Completion();
        corbaCompl.type = this.getType();
        corbaCompl.code = this.getCode();
        corbaCompl.timeStamp = UTCUtility.utcJavaToOmg((long)this.getTimeStamp());
        if (this.isError()) {
            corbaCompl.previousError = new ErrorTrace[1];
            corbaCompl.previousError[0] = this.getAcsJException().getErrorTrace();
        } else {
            corbaCompl.previousError = new ErrorTrace[0];
        }
        return corbaCompl;
    }

    public static AcsJCompletion fromCorbaCompletion(Completion corbaCompletion) {
        if (corbaCompletion == null) {
            throw new NullPointerException("argument 'completion' must not be null!");
        }
        AcsJCompletion jcompletion = new AcsJCompletion();
        if (corbaCompletion.previousError != null && corbaCompletion.previousError.length > 0) {
            AcsJException jex = null;
            ErrorTrace et = corbaCompletion.previousError[0];
            Throwable thr = CorbaExceptionConverter.recursiveGetThrowable(et);
            jex = !(thr instanceof AcsJException) ? new DefaultAcsJException(et) : (AcsJException)thr;
            jcompletion.init(jex);
        } else {
            jcompletion.init(corbaCompletion.type, corbaCompletion.code);
        }
        return jcompletion;
    }

    public Object setProperty(String key, String value) {
        if (this.isError()) {
            return this.getAcsJException().setProperty(key, value);
        }
        throw new IllegalStateException("Failed to set property '" + key + "' because properties are not supported for ok-completion classes.");
    }

    public String getProperty(String key) {
        if (this.isError()) {
            return this.getAcsJException().getProperty(key);
        }
        throw new IllegalStateException("Failed to get property '" + key + "' because properties are not supported for ok-completion classes.");
    }
}

