/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JComponent;
import jsky.catalog.gui.CatalogHistoryItem;
import jsky.util.Preferences;

public class CatalogHistoryList {
    private static final String HISTORY_LIST_NAME = "catalogHistoryList";
    private LinkedList<CatalogHistoryItem> _historyList;
    private int _maxHistoryItems = 20;

    public CatalogHistoryList() {
        this._load();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                CatalogHistoryList.this._save(true);
            }
        });
    }

    public void add(CatalogHistoryItem historyItem) {
        for (CatalogHistoryItem item : new LinkedList<CatalogHistoryItem>(this._historyList)) {
            if (!item.getName().equals(historyItem.getName())) continue;
            this._historyList.remove(item);
        }
        this._historyList.addFirst(historyItem);
        if (this._historyList.size() > this._maxHistoryItems) {
            this._historyList.removeLast();
        }
    }

    public int getMaxHistoryItems() {
        return this._maxHistoryItems;
    }

    public void setMaxHistoryItems(int n) {
        this._maxHistoryItems = n;
    }

    public Iterator<CatalogHistoryItem> iterator() {
        return this._historyList.iterator();
    }

    public void clear() {
        this._historyList = new LinkedList();
        this._save(false);
    }

    private void _load() {
        try {
            this._historyList = (LinkedList)Preferences.getPreferences().deserialize(HISTORY_LIST_NAME);
        }
        catch (Exception e) {
            this._historyList = new LinkedList();
        }
    }

    private LinkedList<CatalogHistoryItem> _merge() {
        LinkedList<CatalogHistoryItem> savedHistory = this._historyList;
        this._load();
        ListIterator it = savedHistory.listIterator(savedHistory.size());
        while (it.hasPrevious()) {
            this.add((CatalogHistoryItem)it.previous());
        }
        return this._historyList;
    }

    private void _save(boolean merge) {
        try {
            LinkedList<CatalogHistoryItem> l = merge ? this._merge() : this._historyList;
            Preferences.getPreferences().serialize(HISTORY_LIST_NAME, l);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CatalogHistoryItem getItemForQueryComponent(JComponent queryComp) {
        for (CatalogHistoryItem item : this._historyList) {
            if (item.getQueryComponent() != queryComp) continue;
            return item;
        }
        return null;
    }
}

