/*
 * Decompiled with CFR 0.152.
 */
package skyview.util;

import nom.tam.util.ArrayFuncs;

public abstract class Scaler {
    private boolean useDefault = true;
    private double minVal;
    private double maxVal;
    private int minOutput = 0;
    private int maxOutput = 255;

    public Scaler() {
    }

    public Scaler(double minVal, double maxVal, int minOutput, int maxOutput) {
        this.useDefault = false;
        this.minVal = minVal;
        this.maxVal = maxVal;
        this.minOutput = minOutput;
        this.maxOutput = maxOutput;
    }

    protected boolean getUseDefault() {
        return this.useDefault;
    }

    protected double getMinVal() {
        return this.minVal;
    }

    protected double getMaxVal() {
        return this.maxVal;
    }

    protected int getMinOutput() {
        return this.minOutput;
    }

    protected int getMaxOutput() {
        return this.maxOutput;
    }

    protected void setMinVal(double minVal) {
        this.minVal = minVal;
    }

    protected void setMaxVal(double maxVal) {
        this.maxVal = maxVal;
    }

    public Object scaleArray(Object array) {
        int[] dims = ArrayFuncs.getDimensions(array);
        double[] c = (double[])ArrayFuncs.flatten(array);
        if (c == array) {
            c = (double[])((double[])array).clone();
        }
        int len = c.length;
        byte[] out1 = new byte[len];
        if (this.useDefault) {
            this.setMinMax(c);
        }
        this.prepareScaling(c);
        for (int i = 0; i < len; ++i) {
            out1[i] = c[i] < this.minVal ? (byte)this.minOutput : (c[i] > this.maxVal ? (byte)this.maxOutput : this.scale(c[i]));
        }
        return ArrayFuncs.curl(out1, dims);
    }

    protected void setMinMax(double[] c) {
        if (c.length == 0) {
            return;
        }
        this.minVal = c[0];
        this.maxVal = c[0];
        for (int i = 0; i < c.length; ++i) {
            if (c[i] > this.maxVal) {
                this.maxVal = c[i];
                continue;
            }
            if (!(c[i] < this.minVal)) continue;
            this.minVal = c[i];
        }
    }

    protected abstract void prepareScaling(double[] var1);

    protected abstract byte scale(double var1);
}

