/*
 * Decompiled with CFR 0.152.
 */
package skyview.survey;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.ivoa.util.CGI;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;
import skyview.executive.Settings;
import skyview.request.HTMLWriter;
import skyview.survey.ParsingTermination;
import skyview.survey.Util;
import skyview.survey.XMLSurveyFinder;

public class XMLSurveyDescription {
    static XMLSurveyFinder sf = new XMLSurveyFinder();
    static CGI cgi = new CGI();
    static String currentRegime;

    public static void main(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                Settings.updateFromFile(args[i]);
            }
            String survey = cgi.value("survey");
            if (survey == null) {
                XMLSurveyDescription.allSurveys();
            } else {
                String name = sf.findFile(survey);
                if (name == null) {
                    XMLSurveyDescription.error("No survey description availble for specified survey");
                } else {
                    XMLSurveyDescription.printSurvey(name);
                }
            }
        }
        catch (Exception e) {
            XMLSurveyDescription.error("Exception processing request: " + e);
        }
    }

    public static void printSurvey(String name) throws Exception {
        System.out.println("Content-type: text/html\n");
        System.out.println("<html><head><title>Survey Description:" + name + "</title></head><body>");
        XMLSurveyDescription.printDescription(name);
        System.out.println("</body></html>");
    }

    public static void error(String msg) {
        System.out.println("Content-type: text/html\n\n<h2>Error during processing</h2>" + msg);
    }

    public static void printDescription(String filename) throws Exception {
        String xslt = Settings.get("DescriptionXSLT");
        if (xslt == null) {
            XMLSurveyDescription.error("No description transformation file in settings");
        }
        StreamSource xmlSource = new StreamSource(Util.getResourceOrFile(filename));
        StreamSource xslSource = new StreamSource(Util.getResourceOrFile(xslt));
        StringWriter sw = new StringWriter();
        StreamResult output = new StreamResult(sw);
        Transformer trans = TransformerFactory.newInstance().newTransformer(xslSource);
        trans.transform(xmlSource, output);
        sw.close();
        String outHTML = sw.toString();
        int off1 = outHTML.indexOf(62);
        if (off1 > 0) {
            outHTML = outHTML.substring(off1 + 1);
        }
        outHTML = outHTML.replace("</HTML>", "");
        outHTML = outHTML.replaceAll("\\<H2\\>\\s*([^>]*)\\s*\\</H2\\>", "<A NAME='$1'><H2>$1</H2></A>");
        System.out.print(outHTML);
    }

    public static void allSurveys() throws Exception {
        String header;
        String[] files;
        String[] names = sf.getSurveys();
        HashMap<String, String> fileHash = new HashMap<String, String>();
        for (String name : names) {
            String file = sf.findFile(name);
            fileHash.put(file, "");
        }
        for (String file : files = fileHash.keySet().toArray(new String[0])) {
            fileHash.put(file, XMLSurveyDescription.getRegime(file));
        }
        boolean wroteHeader = false;
        if (Settings.has("SurveysHeader") && (header = HTMLWriter.slurp(Settings.get("SurveysHeader"))).length() > 10) {
            System.out.print(header);
            wroteHeader = true;
        }
        String[] regimes = new String[]{"Radio", "Infrared", "Optical", "Ultraviolet", "X-ray", "Gamma ray"};
        if (!wroteHeader) {
            XMLSurveyDescription.printAllHeader();
        }
        for (String regime : regimes) {
            fileHash = XMLSurveyDescription.processRegime(regime, fileHash);
        }
        XMLSurveyDescription.processRemaining(fileHash);
        if (Settings.has("SurveysTrailer")) {
            String trailer = HTMLWriter.slurp(Settings.get("SurveysTrailer"));
            System.out.print(trailer);
        } else {
            XMLSurveyDescription.printAllTrailer();
        }
    }

    public static String getRegime(String file) {
        RegimeFinder handler = new RegimeFinder();
        try {
            SAXParser sp = SAXParserFactory.newInstance().newSAXParser();
            InputStream is = Util.getResourceOrFile(file);
            is = new BufferedInputStream(is);
            sp.parse(new InputSource(is), (DefaultHandler)handler);
            is.close();
        }
        catch (ParsingTermination p) {
            return handler.getRegime();
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    static void printAllHeader() {
        System.out.println("Content-type: text/html\n\n<HTML><HEAD><Title>SkyView Surveys</Title></HEAD><BODY>");
    }

    static void printAllTrailer() {
        System.out.println("</BODY></HTML>");
    }

    static HashMap<String, String> processRegime(String regime, HashMap<String, String> surveys) throws Exception {
        System.out.println("<h1> " + regime + " surveys </h1>");
        HashMap<String, String> remaining = new HashMap<String, String>();
        regime = regime.toLowerCase();
        ArrayList<String> names = new ArrayList<String>();
        for (String s : surveys.keySet()) {
            if (surveys.get(s).toLowerCase().equals(regime)) {
                names.add(s);
                continue;
            }
            remaining.put(s, surveys.get(s));
        }
        Collections.sort(names);
        for (String s : names) {
            XMLSurveyDescription.printDescription(s);
        }
        return remaining;
    }

    static void processRemaining(HashMap<String, String> surveys) throws Exception {
        if (surveys.size() < 1) {
            return;
        }
        System.out.println("<p>-------------- Other surveys --------------<p>");
        for (String s : surveys.keySet()) {
            XMLSurveyDescription.printDescription(s);
        }
    }

    private static class RegimeFinder
    extends DefaultHandler {
        private StringBuffer buf;
        private boolean active = false;
        private boolean inRegime = true;
        private static String regime;

        private RegimeFinder() {
        }

        public String getRegime() {
            return regime;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrib) {
            String lq = qName.toLowerCase();
            if (this.inRegime) {
                this.active = true;
                this.buf = new StringBuffer();
            }
            if (lq.equals("regime")) {
                this.inRegime = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            String lq = qName.toLowerCase();
            if (lq.equals("regime")) {
                regime = new String(this.buf).trim();
                throw new ParsingTermination();
            }
        }

        @Override
        public void characters(char[] arr, int start, int len) {
            if (this.active) {
                this.buf.append(arr, start, len);
            }
        }
    }
}

