/*
 * Decompiled with CFR 0.152.
 */
package skyview.survey;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;
import skyview.executive.Settings;
import skyview.geometry.Position;
import skyview.survey.Image;
import skyview.survey.ImageFactory;
import skyview.survey.ImageGenerator;
import skyview.survey.Survey;
import skyview.survey.Util;
import skyview.util.Utilities;

public class XMLSurvey
implements Survey {
    private String xmlFile;
    private double surveySize;
    private ArrayList<String> images;

    public XMLSurvey(String file) {
        this.xmlFile = file;
    }

    @Override
    public String getName() {
        return "Survey:XML";
    }

    @Override
    public String getDescription() {
        return "A survey defined by an XML file which contains the metadata and image descriptions";
    }

    @Override
    public Image[] getImages(Position pos, double size) throws Exception {
        SAXParser sp = SAXParserFactory.newInstance().newSAXParser();
        this.images = new ArrayList();
        boolean needImages = true;
        if (Settings.has("MaxRequestSize") && Settings.has("LargeImage") && Double.parseDouble(Settings.get("MaxRequestSize")) < size) {
            String[] fields;
            for (String fld : fields = Settings.getArray("LargeImage")) {
                this.images.add(fld);
            }
            needImages = false;
        }
        this.doParse(sp, new ImageFinderCallBack(pos, size, needImages));
        String imageFactory = Settings.get("ImageFactory");
        if (this.images.size() == 0) {
            return new Image[0];
        }
        Image[] list = new Image[this.images.size()];
        ImageFactory imFac = (ImageFactory)Utilities.newInstance(imageFactory, "skyview.survey");
        if (imFac == null) {
            throw new Error("Unable to create image factory");
        }
        for (int i = 0; i < this.images.size(); ++i) {
            String s = this.images.get(i);
            list[i] = imFac.factory(s);
        }
        return list;
    }

    @Override
    public void updateHeader(Header h) {
        HeaderUpdateCallBack dh = null;
        try {
            SAXParser sp = SAXParserFactory.newInstance().newSAXParser();
            dh = new HeaderUpdateCallBack(h);
            this.doParse(sp, new HeaderUpdateCallBack(h));
        }
        catch (Exception e) {
            throw new Error("Error updating header:" + e);
        }
    }

    @Override
    public void updateSettings() {
        try {
            SAXParser sp = SAXParserFactory.newInstance().newSAXParser();
            this.doParse(sp, new SettingsCallBack());
        }
        catch (Exception e) {
            throw new Error("Error updating header when reading file:" + this.xmlFile + "\n" + e);
        }
    }

    protected void doParse(SAXParser sp, DefaultHandler handler) throws Exception {
        InputStream is = Util.getResourceOrFile(this.xmlFile);
        is = new BufferedInputStream(is);
        sp.parse(new InputSource(is), handler);
        is.close();
    }

    private class HeaderUpdateCallBack
    extends DefaultHandler {
        private StringBuffer buf;
        private boolean active = false;
        private boolean meta = false;
        private boolean firstMeta = true;
        private Header h;
        private Pattern pat = Pattern.compile("\\n");

        HeaderUpdateCallBack(Header fitsHeader) {
            this.h = fitsHeader;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrib) {
            if (this.meta || qName.equals("FITS")) {
                this.active = true;
                this.buf = new StringBuffer();
            }
            if (qName.equals("MetaTable")) {
                this.meta = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            try {
                if (this.active) {
                    this.active = false;
                    String s = new String(this.buf).trim();
                    if (this.meta) {
                        if (this.firstMeta) {
                            this.h.insertComment("");
                            this.h.insertComment(" SkyView Survey metadata ");
                            this.h.insertComment("");
                            this.firstMeta = false;
                        }
                        s = Util.replace(s, "<[^>]*>", "", true);
                        s = Util.replace(s, "&amp;", "&", true);
                        s = Util.replace(s, "&gt;", ">", true);
                        s = Util.replace(s, "&lt;", "<", true);
                        s = Util.replace(s, "\n", " ", true);
                        String comHead = qName + ":";
                        if (comHead.length() < 13) {
                            comHead = comHead + "               ".substring(0, 13 - comHead.length());
                        }
                        String comment = comHead + s;
                        while (comment != null && comment.length() > 0) {
                            if (comment.length() > 70) {
                                String next = "          " + comment.substring(70);
                                String current = comment.substring(0, 70);
                                this.h.insertComment(current);
                                comment = next;
                                continue;
                            }
                            this.h.insertComment(comment);
                            comment = null;
                        }
                    }
                    if (qName.equals("FITS")) {
                        String[] tokens;
                        this.h.insertComment("");
                        this.h.insertComment("Survey specific cards");
                        this.h.insertComment("");
                        for (String tok : tokens = this.pat.split(s)) {
                            this.h.addLine(tok);
                        }
                    }
                }
                if (qName.equals("MetaTable")) {
                    this.meta = false;
                }
            }
            catch (FitsException e) {
                throw new Error("Unexpected FITS exception in HeaderUpdateCallBack:" + e);
            }
        }

        @Override
        public void characters(char[] arr, int start, int len) {
            if (this.active) {
                this.buf.append(arr, start, len);
            }
        }
    }

    private class ImageFinderCallBack
    extends DefaultHandler {
        private StringBuffer buf;
        private boolean active = false;
        private double ra;
        private double dec;
        private double requestSize;
        private Pattern pat = Pattern.compile("\\s+");
        private boolean inImages = false;
        private boolean firstImage = true;
        private Position pos;
        private boolean needImages;

        private void updatePosition() {
            try {
                double[] coords = this.pos.getCoordinates(Settings.get("SurveyCoordinateSystem"));
                this.ra = coords[0];
                this.dec = coords[1];
            }
            catch (Exception e) {
                System.err.println("Error with SurveyCoordinateSystem!" + Settings.get("SurveyCoordinateSystem"));
                throw new Error(e);
            }
        }

        ImageFinderCallBack(Position pos, double size, boolean needImages) {
            this.pos = pos;
            this.needImages = needImages;
            this.updatePosition();
            this.requestSize = size;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrib) {
            if (this.inImages) {
                this.active = true;
                this.buf = new StringBuffer();
            }
            if (qName.equals("Images")) {
                this.inImages = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.active) {
                this.active = false;
                String s = new String(this.buf).trim();
                if (qName.equals("Image") && this.needImages) {
                    if (this.firstImage) {
                        XMLSurvey.this.surveySize = Double.parseDouble(Settings.get("ImageSize"));
                        this.firstImage = false;
                    }
                    String[] tokens = this.pat.split(s);
                    double xRA = 0.0;
                    double xDec = 0.0;
                    try {
                        xRA = Double.parseDouble(tokens[1]);
                        xDec = Double.parseDouble(tokens[2]);
                    }
                    catch (Exception e) {
                        throw new Error(e);
                    }
                    double distance = skyview.geometry.Util.sphdistDeg(this.ra, this.dec, xRA, xDec);
                    if (distance < XMLSurvey.this.surveySize + this.requestSize) {
                        XMLSurvey.this.images.add(tokens[0]);
                    }
                } else if (qName.equals("ImageGenerator")) {
                    ImageGenerator gen = (ImageGenerator)Utilities.newInstance(s, "skyview.survey");
                    if (gen == null) {
                        throw new Error("Unable to create image generator:" + s);
                    }
                    try {
                        gen.getImages(this.ra, this.dec, this.requestSize, XMLSurvey.this.images);
                    }
                    catch (Exception e) {
                        System.err.println("Unable to invoke ImageGenerator:" + s + "\nException: " + e);
                    }
                } else {
                    Settings.put(qName, s);
                    if (qName.toLowerCase().equals("surveycoordinatesystem")) {
                        this.updatePosition();
                    }
                }
            }
        }

        @Override
        public void characters(char[] arr, int start, int len) {
            if (this.active) {
                this.buf.append(arr, start, len);
            }
        }
    }

    private class SettingsCallBack
    extends DefaultHandler {
        private StringBuffer buf;
        private boolean active = false;
        private boolean inSettings = true;
        private boolean inMeta = false;

        private SettingsCallBack() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrib) {
            String lq = qName.toLowerCase();
            if (lq.equals("settings") || lq.equals("metatable") || lq.equals("name") || lq.equals("shortname") || lq.equals("onlinetext")) {
                this.inSettings = true;
            }
            if (lq.equals("metatable")) {
                this.inMeta = true;
            }
            if (this.inSettings) {
                this.active = true;
                this.buf = new StringBuffer();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            String lq = qName.toLowerCase();
            if (lq.equals("settings") || lq.equals("metatable") || lq.equals("name") || lq.equals("onlinetext")) {
                this.inSettings = false;
                this.active = false;
            }
            if (this.active || lq.equals("name") || lq.equals("onlinetext")) {
                this.active = false;
                String s = new String(this.buf).trim();
                qName = qName.toLowerCase();
                if (this.inMeta) {
                    qName = "_meta_" + qName;
                }
                if (s.length() > 0) {
                    Settings.suggest(qName, s);
                }
            }
            if (lq.equals("metatable")) {
                this.inMeta = false;
            }
        }

        @Override
        public void characters(char[] arr, int start, int len) {
            if (this.active) {
                this.buf.append(arr, start, len);
            }
        }
    }
}

