/*
 * Decompiled with CFR 0.152.
 */
package skyview.survey;

import skyview.geometry.TransformationException;
import skyview.geometry.Transformer;
import skyview.geometry.WCS;
import skyview.survey.Image;
import skyview.survey.ImageFactory;

public class ProxyImage
extends Image {
    private Image realImage;
    private Image proxyImage;
    private Image currentImage;
    private ImageFactory fac;
    private String spell;

    @Override
    public String getName() {
        return this.currentImage.getName();
    }

    @Override
    protected void setName(String name) {
        this.currentImage.setName(name);
    }

    public void setFactory(ImageFactory imFac) {
        this.fac = imFac;
    }

    public ProxyImage(String spell, WCS wcs, int width, int height, int depth) throws TransformationException {
        this.spell = spell;
        this.currentImage = this.proxyImage = new Image(null, wcs, width, height, depth);
    }

    @Override
    public WCS getWCS() {
        return this.currentImage.getWCS();
    }

    @Override
    public double getData(int npix) {
        return this.currentImage.getData(npix);
    }

    @Override
    public double[] getDataArray() {
        return this.currentImage.getDataArray();
    }

    @Override
    public void setData(int npix, double newData) {
        this.currentImage.setData(npix, newData);
    }

    @Override
    public void clearData() {
        this.currentImage.clearData();
    }

    @Override
    public void setDataArray(double[] newData) {
        this.currentImage.setDataArray(newData);
    }

    @Override
    public Transformer getTransformer() {
        return this.currentImage.getTransformer();
    }

    @Override
    public int getWidth() {
        return this.currentImage.getWidth();
    }

    @Override
    public int getHeight() {
        return this.currentImage.getHeight();
    }

    @Override
    public int getDepth() {
        return this.currentImage.getDepth();
    }

    @Override
    public double[] getCenter(int npix) {
        return this.currentImage.getCenter(npix);
    }

    @Override
    public double[][] getCorners(int npix) {
        return this.currentImage.getCorners(npix);
    }

    @Override
    public void validate() {
        if (this.realImage == null) {
            this.realImage = this.fac.factory(this.spell);
        }
        this.currentImage = this.realImage;
    }

    @Override
    public boolean valid() {
        return this.realImage != null;
    }

    @Override
    public Image getBaseImage() {
        return this.currentImage;
    }
}

