/*
 * Decompiled with CFR 0.152.
 */
package skyview.survey;

import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.Fits;
import nom.tam.fits.Header;
import nom.tam.util.ArrayDataInput;
import skyview.geometry.CoordinateSystem;
import skyview.geometry.Projection;
import skyview.geometry.Scaler;
import skyview.geometry.TransformationException;
import skyview.geometry.WCS;
import skyview.geometry.projecter.Hpx;
import skyview.survey.Image;
import skyview.survey.SurveyException;

public class HealPixImage
extends Image {
    private String fitsFile;
    private Header fitsHeader;
    private Hpx hpp;
    private float[] vals;
    private int nside;

    @Override
    public int getWidth() {
        return 4 * this.nside;
    }

    @Override
    public int getHeight() {
        return 6 * this.nside;
    }

    @Override
    public int getDepth() {
        return 1;
    }

    public HealPixImage(String file) throws SurveyException {
        this.setName(file);
        this.data = null;
        int dim = 0;
        this.fitsFile = file;
        ArrayDataInput inp = null;
        try {
            Fits f = new Fits(file);
            inp = f.getStream();
            BasicHDU hdu = f.getHDU(1);
            dim = 0;
            this.nside = hdu.getHeader().getIntValue("NSIDE");
            for (int cnt = 1; cnt < this.nside; cnt *= 2) {
                ++dim;
            }
            BinaryTable bt = (BinaryTable)hdu.getData();
            this.vals = (float[])bt.getColumn(0);
        }
        catch (Exception e) {
            System.err.println("Error is:" + e);
            e.printStackTrace();
            throw new SurveyException("Unable to read file:" + this.fitsFile);
        }
        finally {
            if (inp != null) {
                try {
                    inp.close();
                }
                catch (Exception e) {}
            }
        }
        try {
            Projection proj = new Projection("Hpx");
            CoordinateSystem cs = CoordinateSystem.Gal;
            Scaler s1 = new Scaler(-2.356194490192345, 0.0, 1.0, 0.0, 0.0, 1.0);
            double isqrt2 = 1.0 / Math.sqrt(2.0);
            s1 = s1.add(new Scaler(0.0, 0.0, isqrt2, isqrt2, -isqrt2, isqrt2));
            double pixlen = Math.PI / ((double)this.nside * Math.sqrt(8.0));
            double crpix1 = 2 * this.nside;
            double crpix2 = 3 * this.nside;
            s1 = s1.add(new Scaler(crpix1, crpix2, 1.0 / pixlen, 0.0, 0.0, 1.0 / pixlen));
            WCS wcs = new WCS(cs, proj, s1);
            this.hpp = (Hpx)proj.getProjecter();
            this.hpp.setDimension(dim);
            this.initialize(null, wcs, 4 * this.nside, 6 * this.nside, 1);
        }
        catch (TransformationException e) {
            throw new SurveyException("Error generating tranformation for file: " + file);
        }
    }

    @Override
    public double getData(int ipix) {
        int npix = this.hpp.cvtPixel(ipix);
        double val = npix < 0 || npix >= this.vals.length ? -1.0 : (double)this.vals[npix];
        return val;
    }

    @Override
    public double[] getDataArray() {
        double[] data = new double[24 * this.nside * this.nside];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.getData(i);
        }
        return data;
    }

    @Override
    public void setData(int npix, double val) {
        if ((npix = this.hpp.cvtPixel(npix)) != -1) {
            this.vals[npix] = (float)val;
        }
    }
}

