/*
 * Decompiled with CFR 0.152.
 */
package skyview.sia;

import java.net.URLEncoder;
import nom.tam.fits.Header;
import skyview.executive.Settings;
import skyview.geometry.DepthSampler;
import skyview.geometry.Sampler;
import skyview.process.Processor;
import skyview.sia.Checker;
import skyview.sia.SIA;
import skyview.survey.Image;

public class SIAWriter
implements Processor {
    static int count = 0;

    static int getCount() {
        return count;
    }

    @Override
    public String getName() {
        return "SIAWriter";
    }

    @Override
    public String getDescription() {
        return "Write an SIA record or records for the given survey.";
    }

    @Override
    public void process(Image[] input, Image output, int[] osource, Sampler samp, DepthSampler dSampler) {
        String survey = Settings.get("_currentSurvey");
        String[] pos = Settings.getArray("POS");
        String[] pixels = Settings.getArray("Pixels");
        String[] size = Settings.getArray("Size");
        String quicklook = SIA.getSIA().quicklook();
        String[] scale = Settings.getArray("scale");
        if (scale.length > 0) {
            try {
                double xscale = Double.parseDouble(scale[0]);
                double big = 10000.0;
                double small = 5.0;
                double xsize = Double.parseDouble(size[0]);
                if (Settings.has("small") && (small = Double.parseDouble(Settings.get("small"))) < 0.0) {
                    small = 0.0;
                }
                if (Settings.has("big")) {
                    big = Double.parseDouble(Settings.get("big"));
                }
                if (xsize / xscale < small) {
                    return;
                }
                if (xsize / xscale > big) {
                    return;
                }
            }
            catch (Exception e) {
                System.err.println("Error parsing big/small parameters");
            }
        }
        String url = this.getURL(survey);
        if (Checker.getStatus()) {
            ++count;
            if (SIA.getSIA().useFits()) {
                this.doRecord(survey, pos, pixels, size, "image/fits", url + "&return=FITS", "" + count);
            }
            if (quicklook != null) {
                url = url + "&nofits=1&quicklook=" + quicklook;
                this.doRecord(survey, pos, pixels, size, "image/" + quicklook, url + "&return=" + quicklook, "" + count);
            }
        }
    }

    String getURL(String survey) {
        String url = "http://skyview.gsfc.nasa.gov/cgi-bin/images?";
        if (Settings.has("SIABase")) {
            url = Settings.get("SIABase");
        }
        url = url + "position=" + this.encode(Settings.get("position"));
        url = url + "&survey=" + this.encode(survey);
        url = url + "&pixels=" + this.encode(Settings.get("pixels"));
        url = url + "&sampler=" + this.encode(Settings.get("sampler"));
        url = url + "&size=" + this.encode(Settings.get("size"));
        url = url + "&projection=" + this.encode(Settings.get("projection"));
        url = url + "&coordinates=" + Settings.get("coordinates");
        return url;
    }

    void doRecord(String survey, String[] pos, String[] pixels, String[] size, String format, String url, String log) {
        String[] scale = new String[]{"NaN", "NaN"};
        try {
            scale[0] = "-" + Double.parseDouble(size[0]) / Double.parseDouble(pixels[0]);
            scale[1] = "" + Double.parseDouble(size[1]) / Double.parseDouble(pixels[1]);
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.print("<TR>");
        this.writeSingle(survey);
        this.writeSingle(pos[0]);
        this.writeSingle(pos[1]);
        this.writeSingle("2");
        this.writeDuo(pixels);
        this.writeDuo(scale);
        this.writeSingle(format);
        this.writeSingle("F");
        System.out.println("<TD><![CDATA[" + url + "]]></TD>");
        this.writeSingle(log);
        System.out.println("</TR>");
    }

    void writeSingle(String input) {
        System.out.print("<TD>" + input + "</TD>");
    }

    void writeDuo(String[] input) {
        if (input.length > 1) {
            System.out.print("<TD>" + input[0] + " " + input[1] + "</TD>");
        } else {
            System.out.print("<TD>" + input[0] + " " + input[0] + "</TD>");
        }
    }

    @Override
    public void updateHeader(Header h) {
    }

    private String encode(String input) {
        try {
            return URLEncoder.encode(input, "UTF-8");
        }
        catch (Exception e) {
            return input;
        }
    }
}

