/*
 * Decompiled with CFR 0.152.
 */
package skyview.request;

import java.util.regex.Pattern;
import skyview.request.Detainter;

public class SkyViewDetainter
extends Detainter {
    public SkyViewDetainter() {
        super.addPattern("catalogName", Pattern.compile("[\\sA-Za-z0-9,_\\(\\)\\-\\/\\.\\[\\]a\\(\\)\\+\\&]+"));
        super.addPattern("surveyName", Pattern.compile("[\\sA-Za-z0-9,_\\(\\)\\-\\<\\>\\/\\.\\:]+"));
        super.addPattern("alphaNumeric", Pattern.compile("[\\sA-Za-z0-9,_\\-\\.\\+\\(\\)\\/]+"));
        super.addPattern("string", Pattern.compile("[\\sA-Za-z_\\-\\(\\)\\/,]+"));
        super.addPattern("file", Pattern.compile("[\\sA-Za-z0-9_\\-\\/\\.\\+]+"));
        super.addPattern("url", Pattern.compile("[\\s,A-Za-z0-9_\\-\\/\\.\\+\\:\\#\\%\\?]+"));
        super.addPattern("numeric", Pattern.compile("[\\s0-9\\.\\-\\+]+"));
        super.addPattern("scientificnotation", Pattern.compile("[e\\s0-9\\.\\-\\+,]+"));
        super.addPattern("default_range", Pattern.compile("[\\sDdEeFfAaUuLlTt\\s0-9\\.\\-\\+,]+"));
        super.addPattern("numericRange", Pattern.compile("[\\s0-9\\.\\-\\+,]+"));
        super.addPattern("position", Pattern.compile("[\\sA-Za-z0-9,'_\\-\\.\\+:\\&\\[\\]\\*\\\"]+"));
        super.addPattern("script", Pattern.compile("<\\s*script\\s*>"));
    }

    @Override
    public boolean validate(String name, String input) throws Exception {
        if (name.equalsIgnoreCase("survey") || name.equalsIgnoreCase("imredd") || name.equalsIgnoreCase("imgreen") || name.equalsIgnoreCase("imgree") || name.equalsIgnoreCase("imblue") || name.equalsIgnoreCase("contour") || name.equalsIgnoreCase("contours")) {
            if (!this.isValid(super.getPattern("surveyName"), name, input)) {
                return false;
            }
            return this.checkInvalid(super.getPattern("script"), name, input);
        }
        if (name.equalsIgnoreCase("catalog") || name.equalsIgnoreCase("catlog") || name.equalsIgnoreCase("cataloglist")) {
            if (!this.isValid(super.getPattern("catalogName"), name, input)) {
                return false;
            }
            return this.checkInvalid(super.getPattern("script"), name, input);
        }
        if (name.equalsIgnoreCase("position") || name.equalsIgnoreCase("scoord") || name.equalsIgnoreCase("vcoord")) {
            return this.isValid(super.getPattern("position"), name, input);
        }
        if (name.equalsIgnoreCase("smooth") || name.equalsIgnoreCase("rotation") || name.equalsIgnoreCase("catalogradius") || name.equalsIgnoreCase("contoursmooth") || Pattern.compile("^.*BIN|STR|END$").matcher(name).find() || name.equalsIgnoreCase("contourmin") || name.equalsIgnoreCase("contournumber") || name.equalsIgnoreCase("is_smooth") || name.equalsIgnoreCase("is_rotation") || name.equalsIgnoreCase("is_degtext") || name.equalsIgnoreCase("savebysurvey") || name.equalsIgnoreCase("contourmax")) {
            return this.isValid(super.getPattern("numeric"), name, input);
        }
        if (name.equalsIgnoreCase("filename") || name.equalsIgnoreCase("file") || name.equalsIgnoreCase("surveymanifest") || name.equalsIgnoreCase("lut") || name.equalsIgnoreCase("cache") || name.equalsIgnoreCase("outputroot") || name.equalsIgnoreCase("webrootpath") || name.equalsIgnoreCase("lutcbarpath") || name.equalsIgnoreCase("htmlwriter") || name.equalsIgnoreCase("rgbwriter") || name.equalsIgnoreCase("surveytemplate") || name.equalsIgnoreCase("nullimagedir") || name.equalsIgnoreCase("descriptionxslt") || name.equalsIgnoreCase("galleryxslt") || name.equalsIgnoreCase("headertemplate") || name.equalsIgnoreCase("rgbtemplate") || name.equalsIgnoreCase("xmlroot") || name.equalsIgnoreCase("surveysheader") || name.equalsIgnoreCase("footertemplate") || name.equalsIgnoreCase("output")) {
            return this.isValid(super.getPattern("file"), name, input);
        }
        if (name.equalsIgnoreCase("localurl")) {
            return this.isValid(super.getPattern("url"), name, input);
        }
        if (name.equalsIgnoreCase("catalogfilter")) {
            return this.checkInvalid(super.getPattern("script"), name, input);
        }
        if (name.equalsIgnoreCase("plotcolor") || name.equalsIgnoreCase("catalogids") || name.equalsIgnoreCase("nwindow") || name.equalsIgnoreCase("submit") || name.equalsIgnoreCase("namres") || name.equalsIgnoreCase("resolver")) {
            return this.isValid(super.getPattern("string"), name, input);
        }
        if (name.equalsIgnoreCase("resamp") || name.equalsIgnoreCase("sampler") || name.equalsIgnoreCase("projection") || name.equalsIgnoreCase("spcoordinates") || name.equalsIgnoreCase("coordinates") || name.equalsIgnoreCase("equinox") || name.equalsIgnoreCase("equinx") || name.equalsIgnoreCase("pxlcnt") || name.equalsIgnoreCase("deedger") || name.equalsIgnoreCase("coordselect") || name.equalsIgnoreCase("interface") || name.equalsIgnoreCase("grid") || name.equalsIgnoreCase("griddd") || name.equalsIgnoreCase("gridd") || name.equalsIgnoreCase("gridlabels") || name.equalsIgnoreCase("cs") || name.equalsIgnoreCase("invert") || name.equalsIgnoreCase("float") || name.equalsIgnoreCase("compress") || name.equalsIgnoreCase("cont_scaling") || name.equalsIgnoreCase("scaling") || name.equalsIgnoreCase("surveyfinder") || name.equalsIgnoreCase("settingsupdaters") || name.equalsIgnoreCase("finalpostprocessor") || name.equalsIgnoreCase("quicklook") || name.equalsIgnoreCase("nullimages") || name.equalsIgnoreCase("return") || name.equalsIgnoreCase("coltab") || name.equalsIgnoreCase("nofits") || name.equalsIgnoreCase("iscaln") || name.equalsIgnoreCase("maproj")) {
            return this.isValid(super.getPattern("alphaNumeric"), name, input);
        }
        if (name.equalsIgnoreCase("size") || name.equalsIgnoreCase("imscale") || name.equalsIgnoreCase("sfactr")) {
            return this.isValid(super.getPattern("default_range"), name, input);
        }
        if (name.equalsIgnoreCase("pixelx") || name.equalsIgnoreCase("pixely") || name.equalsIgnoreCase("pixels") || name.equalsIgnoreCase("iosmooth") || name.equalsIgnoreCase("ebins")) {
            return this.isValid(super.getPattern("numericRange"), name, input);
        }
        System.err.println("  --using negative pattern for " + name + "-->" + input);
        return this.checkInvalid(super.getPattern("negative"), name, input);
    }

    public boolean isValid(Pattern pattern, String name, String input) throws Exception {
        if (!(input == null || input.equals("") || input.equals("null") || pattern.matcher(input).matches())) {
            System.err.println("*Input validation failed for " + name + "==>" + input + ", pattern=" + pattern.pattern());
            String msg = "Input value";
            if (input != null) {
                msg = msg + " for " + name;
            }
            msg = msg + " is not valid";
            throw new Exception(msg);
        }
        return true;
    }

    public boolean checkInvalid(Pattern pattern, String name, String input) throws Exception {
        if (pattern.matcher(input).find()) {
            System.err.println("*Input validation failed for " + name + "==>" + input + ", pattern=" + pattern.pattern());
            String msg = "Input value";
            if (name != null) {
                msg = msg + " for " + name;
            }
            msg = msg + " is not valid";
            throw new Exception(msg);
        }
        return true;
    }
}

