/*
 * Decompiled with CFR 0.152.
 */
package skyview.request;

import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.regex.Pattern;
import net.ivoa.util.CGI;
import skyview.executive.Imager;
import skyview.executive.Settings;
import skyview.request.Detainter;
import skyview.request.HTMLWriter;
import skyview.request.SkyViewDetainter;

public class CGIInitiator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        System.err.println("\n--- Starting CGIInitiator ---");
        boolean wroteHeader = false;
        long time = System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("EST"));
        String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("EST"));
        System.err.println("[" + sdf.format(calendar.getTime()) + "]:");
        for (int i = 0; i < args.length; ++i) {
            Settings.updateFromFile(args[i]);
        }
        HTMLWriter writer = null;
        try {
            String[] values;
            CGI params = new CGI();
            String[] keys = params.keys();
            HashMap newArgs = new HashMap();
            String delim = "";
            String projwordkey = "maproj";
            String projwordval = "Gnonomic";
            SkyViewDetainter detainter = new SkyViewDetainter();
            for (String key : keys) {
                for (String val : values = params.values(key)) {
                    System.err.print(delim + key + "=" + val + '&');
                }
            }
            System.err.println();
            for (String key : keys) {
                values = params.values(key);
                boolean first = true;
                for (String val : values) {
                    if (Pattern.compile(projwordkey, 2).matcher(key).find() && Pattern.compile(projwordval, 2).matcher(val).find()) {
                        val = "Gnomonic";
                    }
                    if (!((Detainter)detainter).validate(key, val)) {
                        System.err.println("invalid parameter: " + key);
                    }
                    if (first) {
                        Settings.put(key, val);
                        first = false;
                        delim = ",";
                        continue;
                    }
                    Settings.add(key, val);
                }
            }
            System.err.println();
            String id = "";
            if (Settings.has("outputRoot") && !(id = id + Settings.get("outputRoot")).endsWith("/")) {
                id = id + "/";
            }
            id = id + "skv" + Math.abs(System.nanoTime() / 1000L);
            boolean html = true;
            String retVal = null;
            if (Settings.has("return")) {
                retVal = Settings.get("return").toLowerCase();
                if (!retVal.equals("simple")) {
                    html = false;
                }
                if (retVal.equals("gif") || retVal.equals("jpeg") || retVal.equals("png") || retVal.equals("jpg") || retVal.equals("tiff") || retVal.equals("bmp")) {
                    Settings.put("quicklook", retVal);
                }
                if (retVal.equals("filename")) {
                    Settings.put("quicklook", "gif");
                }
                if (retVal.equals("compfits")) {
                    Settings.put("compressed", "1");
                }
                Settings.suggest("float", "");
            }
            if (html) {
                String htmlWriter = Settings.has("rgb") ? Settings.get("RGBWriter") : Settings.get("HTMLWriter");
                if (htmlWriter == null) {
                    htmlWriter = "skyview.request.HTMLWriter";
                }
                Settings.add("PostProcessor", "skyview.ij.IJProcessor");
                Settings.add("PostProcessor", htmlWriter);
                if (!Settings.has("Quicklook")) {
                    Settings.put("Quicklook", "JPG");
                }
                writer = (HTMLWriter)Class.forName(htmlWriter).newInstance();
                writer.writeHeader();
                wroteHeader = true;
            }
            if (Settings.has("catlog") || Settings.has("catalog")) {
                Settings.put("catalogFile", id + ".cat");
            }
            Settings.put("output", id);
            Settings.put("NOEXIT", "");
            Imager.main(new String[]{"Dummy"});
            if (html) {
                writer.writeFooter();
            } else {
                CGIInitiator.copyFile(id, retVal);
            }
        }
        catch (Throwable e) {
            if (!wroteHeader) {
                try {
                    writer = (HTMLWriter)Class.forName("skyview.request.HTMLWriter").newInstance();
                    writer.writeHeader();
                    wroteHeader = true;
                }
                catch (Throwable err) {
                    System.out.println("Not able to display user input validation summary<p>");
                }
            }
            System.out.println("<h2> Exception encountered</h2>\n");
            System.out.println("An irrecoverable error terminated the request.<p>");
            System.out.println("Reason: " + e.getMessage() + "<p>");
            System.out.println("Please refer to the <a href='/help/fields.html'>SkyView documentation</a> or <a href='http://heasarc.gsfc.nasa.gov/cgi-bin/Feedback?selected=skyview'>contact us</a> if you have questions about this error.\n We welcome your questions and feedback. <p>");
            System.out.println("<br><input type=button onclick='document.getElementById(\"traceback\").style.visibility=\"visible\"' value='Show Traceback'>");
            System.out.println("<div id=traceback style='visibility:hidden'><pre>");
            System.out.println("Java Traceback<br>");
            e.printStackTrace(System.out);
            System.out.println("</pre></div></body></html>");
        }
        finally {
            System.exit(0);
        }
    }

    static void copyFile(String id, String type) throws Exception {
        if (type.equals("gif")) {
            id = id + ".gif";
            CGIInitiator.copyToOutput(id, "gif");
        } else if (type.equals("jpeg") || type.equals("jpg")) {
            id = id + ".jpg";
            CGIInitiator.copyToOutput(id, "jpeg");
        } else if (type.equals("png")) {
            id = id + ".png";
            CGIInitiator.copyToOutput(id, "png");
        } else if (type.equals("tiff")) {
            id = id + ".tiff";
            CGIInitiator.copyToOutput(id, "tiff");
        } else if (type.equals("bmp")) {
            id = id + ".bmp";
            CGIInitiator.copyToOutput(id, "bmp");
        } else if (type.equals("compfits") || type.equals("fits") || type.equals("batch")) {
            id = id + ".fits";
            if (Settings.has("compressed")) {
                id = id + ".gz";
            }
            CGIInitiator.copyToOutput(id, "fits");
        } else if (type.equals("filename")) {
            if (id.indexOf("/") >= 0) {
                id = id.substring(id.lastIndexOf("/") + 1);
            }
            System.out.println("Content-type: text/plain\n\n" + id);
        }
    }

    static void copyToOutput(String file, String type) throws Exception {
        int len;
        String dispo = "inline";
        if (type.indexOf("fits") >= 0) {
            dispo = "attachment";
        }
        String last = file.substring(file.lastIndexOf("/") + 1);
        File f = new File(file);
        if (!f.exists()) {
            file = Settings.get("NullImageDir") + "/nodata." + type;
        }
        System.out.println("Content-disposition: " + dispo + "; filename=" + last);
        System.out.print("Content-type: image/" + type + "\n\n");
        FileInputStream ifs = new FileInputStream(file);
        byte[] block = new byte[32768];
        while ((len = ifs.read(block, 0, block.length)) > 0) {
            System.out.write(block, 0, len);
        }
        System.out.close();
    }

    private static String join(String[] input, String sep) {
        String out = "";
        String xsep = "";
        for (int i = 0; i < input.length; ++i) {
            out = out + xsep + input[i];
            xsep = sep;
        }
        return out;
    }
}

